/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.insurance;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.openvpms.archetype.test.builder.insurance.TestClaimBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestClaimItemBuilder
extends AbstractTestIMObjectBuilder<FinancialAct, TestClaimItemBuilder> {
    private final TestClaimBuilder parent;
    private Date startTime = new Date();
    private Date endTime = new Date();
    private String diagnosis;
    private FinancialAct[] invoiceItems;

    public TestClaimItemBuilder(TestClaimBuilder parent, ArchetypeService service) {
        super("act.patientInsuranceClaimItem", FinancialAct.class, service);
        this.parent = parent;
    }

    public TestClaimItemBuilder treatmentDates(Date startTime, Date endTime) {
        this.treatmentStart(startTime);
        return this.treatmentEnd(endTime);
    }

    public TestClaimItemBuilder treatmentDates(String startTime, String endTime) {
        this.treatmentStart(this.parseDate(startTime));
        return this.treatmentEnd(this.parseDate(endTime));
    }

    public TestClaimItemBuilder treatmentStart(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public TestClaimItemBuilder treatmentEnd(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public TestClaimItemBuilder diagnosis(String diagnosis) {
        return this.diagnosis(diagnosis, diagnosis, diagnosis);
    }

    public TestClaimItemBuilder diagnosis(String code, String name, String dictionaryId) {
        Lookup lookup = (Lookup)((TestLookupBuilder)((TestLookupBuilder)new TestLookupBuilder("lookup.diagnosisVeNom", this.getService()).code(code)).name(name)).build(false);
        IMObjectBean bean = this.getBean((IMObject)lookup);
        bean.setValue("dataDictionaryId", (Object)dictionaryId);
        bean.save();
        this.diagnosis = lookup.getCode();
        return this;
    }

    public TestClaimItemBuilder invoiceItems(FinancialAct ... invoiceItems) {
        this.invoiceItems = invoiceItems;
        return this;
    }

    public TestClaimBuilder add() {
        FinancialAct item = (FinancialAct)this.build(false);
        this.parent.addItem(item);
        return this.parent;
    }

    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        object.setActivityStartTime(this.startTime);
        object.setActivityEndTime(this.endTime);
        if (this.diagnosis != null) {
            object.setReason(this.diagnosis);
        }
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        if (this.invoiceItems != null) {
            for (FinancialAct invoiceItem : this.invoiceItems) {
                amount = amount.add(invoiceItem.getTotal());
                tax = tax.add(invoiceItem.getTaxAmount());
                bean.addTarget("items", (IMObject)invoiceItem, "claims");
                toSave.add((IMObject)invoiceItem);
            }
        }
        bean.setValue("amount", (Object)amount);
        bean.setValue("tax", (Object)tax);
    }
}

