/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.hl7;

import java.util.Set;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class TestHL7ConnectorBuilder<B extends TestHL7ConnectorBuilder<B>>
extends AbstractTestEntityBuilder<Entity, B> {
    private ValueStrategy port = ValueStrategy.unset();
    private ValueStrategy sendingApplication = ValueStrategy.unset();
    private ValueStrategy sendingFacility = ValueStrategy.unset();
    private ValueStrategy receivingApplication = ValueStrategy.unset();
    private ValueStrategy receivingFacility = ValueStrategy.unset();
    private Entity mapping;

    public TestHL7ConnectorBuilder(String archetype, ArchetypeService service) {
        super(archetype, Entity.class, service);
    }

    public B port(int port) {
        this.port = ValueStrategy.value(port);
        return (B)((TestHL7ConnectorBuilder)this.getThis());
    }

    public B sendingApplication(String sendingApplication) {
        this.sendingApplication = ValueStrategy.value(sendingApplication);
        return (B)((TestHL7ConnectorBuilder)this.getThis());
    }

    public B sendingFacility(String sendingFacility) {
        this.sendingFacility = ValueStrategy.value(sendingFacility);
        return (B)((TestHL7ConnectorBuilder)this.getThis());
    }

    public B receivingApplication(String receivingApplication) {
        this.receivingApplication = ValueStrategy.value(receivingApplication);
        return (B)((TestHL7ConnectorBuilder)this.getThis());
    }

    public B receivingFacility(String receivingFacility) {
        this.receivingFacility = ValueStrategy.value(receivingFacility);
        return (B)((TestHL7ConnectorBuilder)this.getThis());
    }

    public B mapping(Entity mapping) {
        this.mapping = mapping;
        return (B)((TestHL7ConnectorBuilder)this.getThis());
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.port.setValue(bean, "port");
        this.sendingApplication.setValue(bean, "sendingApplication");
        this.sendingFacility.setValue(bean, "sendingFacility");
        this.receivingApplication.setValue(bean, "receivingApplication");
        this.receivingFacility.setValue(bean, "receivingFacility");
        if (this.mapping != null) {
            bean.setTarget("mapping", (IMObject)this.mapping);
        }
    }
}

