/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.eft;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.doc.TextDocumentHandler;
import org.openvpms.archetype.test.builder.act.AbstractTestActBuilder;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class AbstractTestEFTPOSTransactionBuilder<B extends AbstractTestEFTPOSTransactionBuilder<B>>
extends AbstractTestActBuilder<FinancialAct, B> {
    private Party customer;
    private BigDecimal amount;
    private Entity terminal;
    private Entity location;
    private final List<ReceiptState> receipts = new ArrayList<ReceiptState>();

    public AbstractTestEFTPOSTransactionBuilder(String archetype, ArchetypeService service) {
        super(archetype, FinancialAct.class, service);
    }

    public B customer(Party customer) {
        this.customer = customer;
        return (B)((AbstractTestEFTPOSTransactionBuilder)this.getThis());
    }

    public B amount(BigDecimal amount) {
        this.amount = amount;
        return (B)((AbstractTestEFTPOSTransactionBuilder)this.getThis());
    }

    public B terminal(Entity terminal) {
        this.terminal = terminal;
        return (B)((AbstractTestEFTPOSTransactionBuilder)this.getThis());
    }

    public B location(Party location) {
        this.location = location;
        return (B)((AbstractTestEFTPOSTransactionBuilder)this.getThis());
    }

    public B addMerchantReceipt(String receipt, boolean signatureRequired) {
        if (receipt != null) {
            this.receipts.add(new ReceiptState(receipt, false, signatureRequired));
        }
        return (B)((AbstractTestEFTPOSTransactionBuilder)this.getThis());
    }

    public B addCustomerReceipt(String receipt) {
        if (receipt != null) {
            this.receipts.add(new ReceiptState(receipt, true, false));
        }
        return (B)((AbstractTestEFTPOSTransactionBuilder)this.getThis());
    }

    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.customer != null) {
            bean.setTarget("customer", (IMObject)this.customer);
        }
        if (this.amount != null) {
            bean.setValue("amount", (Object)this.amount);
        }
        if (this.terminal != null) {
            bean.setTarget("terminal", (IMObject)this.terminal);
        }
        if (this.location != null) {
            bean.setTarget("location", (IMObject)this.location);
        }
        if (!this.receipts.isEmpty()) {
            int sequence = this.getNextSequence(bean, "receipts");
            for (ReceiptState receipt : this.receipts) {
                String archetype = receipt.customer ? "act.EFTPOSReceiptCustomer" : "act.EFTPOSReceiptMerchant";
                DocumentAct act = this.create(archetype, DocumentAct.class);
                toSave.add((IMObject)act);
                IMObjectBean receiptBean = this.getBean((IMObject)act);
                if (receipt.text.length() > receiptBean.getMaxLength("receipt")) {
                    TextDocumentHandler handler = new TextDocumentHandler(this.getService());
                    Document document = handler.create(receiptBean.getDisplayName(), receipt.text);
                    act.setDocument((Reference)document.getObjectReference());
                    toSave.add((IMObject)document);
                } else {
                    receiptBean.setValue("receipt", (Object)receipt.text);
                }
                if (!receipt.customer) {
                    receiptBean.setValue("signatureRequired", (Object)receipt.signatureRequired);
                }
                ActRelationship relationship = (ActRelationship)bean.addTarget("receipts", (IMObject)act, "transaction");
                relationship.setSequence(sequence++);
            }
            this.receipts.clear();
        }
    }

    private static class ReceiptState {
        private final String text;
        private final boolean customer;
        private final boolean signatureRequired;

        public ReceiptState(String text, boolean customer, boolean signatureRequired) {
            this.text = text;
            this.customer = customer;
            this.signatureRequired = signatureRequired;
        }
    }
}

