/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.doc;

import java.util.Set;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.test.builder.act.AbstractTestActBuilder;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestLogoBuilder
extends AbstractTestActBuilder<DocumentAct, TestLogoBuilder> {
    private final boolean update;
    private Document logo;
    private Entity owner;

    public TestLogoBuilder(ArchetypeService service) {
        this(true, service);
    }

    public TestLogoBuilder(boolean update, ArchetypeService service) {
        super("act.documentLogo", DocumentAct.class, service);
        this.update = update;
    }

    public TestLogoBuilder logo(Document logo) {
        this.logo = logo;
        return this;
    }

    public TestLogoBuilder owner(Entity owner) {
        this.owner = owner;
        return this;
    }

    @Override
    protected DocumentAct getExisting() {
        DocumentAct result = (DocumentAct)super.getExisting();
        if (result == null && this.update) {
            DocumentRules rules = new DocumentRules(this.getService());
            result = rules.getLogo(this.owner);
        }
        return result;
    }

    @Override
    protected void build(DocumentAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        object.setFileName(this.logo.getName());
        object.setMimeType(this.logo.getMimeType());
        object.setDocument(this.logo.getObjectReference());
        bean.setTarget("owner", (IMObject)this.owner);
    }
}

