/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.doc;

import java.util.Set;
import org.openvpms.archetype.test.builder.doc.TestLogoBuilder;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestLetterheadBuilder
extends AbstractTestEntityBuilder<Entity, TestLetterheadBuilder> {
    private Document logo;
    private ValueStrategy logoFile = ValueStrategy.unset();
    private Party contacts;
    private ValueStrategy subreport = ValueStrategy.unset();
    private DocumentAct logoAct;

    public TestLetterheadBuilder(ArchetypeService service) {
        super("entity.letterhead", Entity.class, service);
        this.name(ValueStrategy.random());
    }

    public TestLetterheadBuilder(Entity object, ArchetypeService service) {
        super(object, service);
    }

    public TestLetterheadBuilder logo(Document logo) {
        this.logo = logo;
        return this;
    }

    public TestLetterheadBuilder logoFile(String logoFile) {
        this.logoFile = ValueStrategy.value(logoFile);
        return this;
    }

    public TestLetterheadBuilder contacts(Party contacts) {
        this.contacts = contacts;
        return this;
    }

    public TestLetterheadBuilder subreport(String subreport) {
        this.subreport = ValueStrategy.value(subreport);
        return this;
    }

    public DocumentAct getLogo() {
        return this.logoAct;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.logoAct = null;
        if (this.logo != null) {
            this.logoAct = this.createLogo(object);
            toSave.add((IMObject)this.logoAct);
            toSave.add((IMObject)this.logo);
        }
        this.logoFile.setValue(bean, "logoFile");
        if (this.contacts != null) {
            bean.setTarget("contacts", (IMObject)this.contacts);
        }
        this.subreport.setValue(bean, "subreport");
    }

    private DocumentAct createLogo(Entity letterhead) {
        return (DocumentAct)new TestLogoBuilder(this.getService()).logo(this.logo).owner(letterhead).build(false);
    }
}

