/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.doc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.archetype.test.builder.doc.AbstractTestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestEmailTemplateBuilder
extends AbstractTestDocumentTemplateBuilder<TestEmailTemplateBuilder> {
    private final TestDocumentTemplateBuilder parent;
    private final List<Entity> attachments = new ArrayList<Entity>();
    private ValueStrategy subjectType = ValueStrategy.unset();
    private ValueStrategy subject = ValueStrategy.unset();
    private ValueStrategy subjectSource = ValueStrategy.unset();
    private ValueStrategy contentType = ValueStrategy.unset();
    private ValueStrategy content = ValueStrategy.unset();
    private ValueStrategy contentSource = ValueStrategy.unset();
    private ValueStrategy defaultEmailAddress = ValueStrategy.unset();

    public TestEmailTemplateBuilder(String archetype, ArchetypeService service, DocumentHandlers handlers) {
        this(null, archetype, service, handlers);
    }

    TestEmailTemplateBuilder(Entity template, ArchetypeService service, DocumentHandlers handlers) {
        super(template, service, handlers);
        this.parent = null;
    }

    TestEmailTemplateBuilder(TestDocumentTemplateBuilder parent, String archetype, ArchetypeService service, DocumentHandlers handlers) {
        super(archetype, service, handlers);
        this.parent = parent;
        this.name(ValueStrategy.random("zemailtemplate"));
    }

    public TestEmailTemplateBuilder subjectType(EmailTemplate.SubjectType subjectType) {
        this.subjectType = ValueStrategy.value(subjectType.name());
        return this;
    }

    public TestEmailTemplateBuilder subject(String subject) {
        this.subject = ValueStrategy.value(subject);
        return this;
    }

    public TestEmailTemplateBuilder subjectSource(String subjectSource) {
        this.subjectSource = ValueStrategy.value(subjectSource);
        return this;
    }

    public TestEmailTemplateBuilder contentType(EmailTemplate.ContentType contentType) {
        this.contentType = ValueStrategy.value(contentType);
        return this;
    }

    public TestEmailTemplateBuilder contentSource(String contentSource) {
        this.contentSource = ValueStrategy.value(contentSource);
        return this;
    }

    public TestEmailTemplateBuilder content(String content) {
        this.content = ValueStrategy.value(content);
        if (this.contentType.getValue() == null) {
            this.contentType(EmailTemplate.ContentType.TEXT);
        }
        return this;
    }

    public TestEmailTemplateBuilder defaultEmailAddress(String defaultEmailAddress) {
        this.defaultEmailAddress = ValueStrategy.value(defaultEmailAddress);
        return this;
    }

    @Override
    public TestEmailTemplateBuilder document(Document document) {
        this.contentType(EmailTemplate.ContentType.DOCUMENT);
        return (TestEmailTemplateBuilder)super.document(document);
    }

    public TestEmailTemplateBuilder addAttachments(Entity ... attachments) {
        this.attachments.addAll(Arrays.asList(attachments));
        return this;
    }

    public TestDocumentTemplateBuilder add() {
        return this.parent.emailTemplate((Entity)this.build(false));
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.subjectType.setValue(bean, "subjectType");
        this.subject.setValue(bean, "subject");
        this.subjectSource.setValue(bean, "subjectSource");
        this.contentType.setValue(bean, "contentType");
        this.content.setValue(bean, "content");
        this.contentSource.setValue(bean, "contentSource");
        this.defaultEmailAddress.setValue(bean, "defaultEmailAddress");
        for (Entity attachment : this.attachments) {
            bean.addTarget("attachments", (IMObject)attachment);
        }
    }
}

