/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.doc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.test.builder.doc.AbstractTestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.doc.DefaultTestDocumentVerifier;
import org.openvpms.archetype.test.builder.doc.TestDocumentBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentVerifier;
import org.openvpms.archetype.test.builder.doc.TestEmailTemplateBuilder;
import org.openvpms.archetype.test.builder.doc.TestImageDocumentVerifier;
import org.openvpms.archetype.test.builder.doc.TestLetterheadBuilder;
import org.openvpms.archetype.test.builder.doc.TestSMSTemplateBuilder;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestDocumentFactory {
    private final ArchetypeService service;
    private final DocumentHandlers handlers;

    public TestDocumentFactory(ArchetypeService service, DocumentHandlers handlers) {
        this.service = service;
        this.handlers = handlers;
    }

    public Document createJRXML() {
        return this.createJRXML("blank.jrxml");
    }

    public Document createJRXML(String name) {
        return (Document)((TestDocumentBuilder)this.newDocumentFromStream("/documents/template-blank.jrxml", "text/xml").name(name)).build();
    }

    public Document createODT() {
        return this.createODT("blank.odt");
    }

    public Document createODT(String name) {
        return (Document)((TestDocumentBuilder)this.newDocumentFromStream("/documents/blank.odt", "application/vnd.oasis.opendocument.text").name(name)).build();
    }

    public Document createDOC() {
        return this.createDOC("blank.doc");
    }

    public Document createDOC(String name) {
        return (Document)((TestDocumentBuilder)this.newDocumentFromStream("/documents/blank.doc", "application/msword").name(name)).build();
    }

    public Document createImage() {
        return this.createPNG("image.png");
    }

    public Document createPNG(String name) {
        return (Document)((TestDocumentBuilder)this.newDocumentFromStream("/documents/image.png", "image/png").name(name)).build();
    }

    public Document createPDF() {
        return this.createPDF("doc.pdf");
    }

    public Document createPDF(String name) {
        return (Document)((TestDocumentBuilder)this.newDocumentFromStream("/documents/blank.pdf", "application/pdf").name(name)).build();
    }

    public Document createText() {
        return (Document)((TestDocumentBuilder)this.newDocument().name("plain.txt")).mimeType("text/plain").content("this is plain text").build();
    }

    public Document createDocument(String path) {
        return this.createDocument(path, null);
    }

    public Document createDocument(String path, String mimeType) {
        return (Document)this.newDocumentFromStream(path, mimeType).build();
    }

    public Document createDocument(File file) throws IOException {
        return (Document)((TestDocumentBuilder)this.newDocument().name(file.getName())).content(new FileInputStream(file)).build();
    }

    public TestDocumentBuilder newDocument() {
        return new TestDocumentBuilder(this.handlers, this.service);
    }

    public Entity createTemplate(String type) {
        return (Entity)((TestDocumentTemplateBuilder)this.newTemplate().type(type).blankDocument()).build();
    }

    public TestDocumentTemplateBuilder newTemplate() {
        return new TestDocumentTemplateBuilder(this.service, this.handlers);
    }

    public TestDocumentTemplateBuilder updateTemplate(Entity template) {
        return new TestDocumentTemplateBuilder(template, this.service, this.handlers);
    }

    public TestEmailTemplateBuilder newEmailTemplate() {
        return this.newEmailTemplate("entity.documentTemplateEmailUser");
    }

    public TestEmailTemplateBuilder newEmailTemplate(String archetype) {
        return new TestEmailTemplateBuilder(archetype, this.service, this.handlers);
    }

    public TestEmailTemplateBuilder updateEmailTemplate(Entity template) {
        return new TestEmailTemplateBuilder(template, this.service, this.handlers);
    }

    public DocumentAct attachDocument(Entity template, Document document) {
        AbstractTestDocumentTemplateBuilder builder;
        if (template.isA("entity.documentTemplate")) {
            builder = this.updateTemplate(template);
        } else if (template.isA("entity.documentTemplateEmail*")) {
            builder = this.updateEmailTemplate(template);
        } else {
            throw new IllegalArgumentException("Unsupported template " + template.getArchetype());
        }
        ((AbstractTestIMObjectBuilder)builder.document(document)).build();
        return builder.getTemplateAct();
    }

    public TestSMSTemplateBuilder newSMSTemplate(String archetype) {
        return new TestSMSTemplateBuilder(archetype, this.service);
    }

    public TestLetterheadBuilder newLetterhead() {
        return new TestLetterheadBuilder(this.service);
    }

    public TestLetterheadBuilder updateLetterhead(Entity letterhead) {
        return new TestLetterheadBuilder(letterhead, this.service);
    }

    public TestDocumentVerifier<?> newVerifier(String archetype) {
        TestImageDocumentVerifier result = archetype.equals("document.image") ? this.newImageVerifier() : new DefaultTestDocumentVerifier(this.handlers, this.service).archetype(archetype);
        return result;
    }

    public TestImageDocumentVerifier newImageVerifier() {
        return new TestImageDocumentVerifier(this.handlers, this.service);
    }

    public TestDocumentVerifier<?> newVerifier(Document document) {
        return this.newVerifier(document.getArchetype()).initialise(document);
    }

    public String toString(Document document) throws IOException {
        return IOUtils.toString((InputStream)this.handlers.get(document).getContent(document), (Charset)StandardCharsets.UTF_8);
    }

    private TestDocumentBuilder newDocumentFromStream(String path, String mimeType) {
        InputStream stream = this.getClass().getResourceAsStream(path);
        Assert.assertNotNull((Object)stream);
        return ((TestDocumentBuilder)this.newDocument().name(FilenameUtils.getName((String)path))).mimeType(mimeType).content(stream);
    }
}

