/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.order;

import java.math.BigDecimal;
import java.util.Set;
import org.openvpms.archetype.test.builder.act.AbstractTestActBuilder;
import org.openvpms.archetype.test.builder.customer.order.TestPharmacyOrderReturnBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestPharmacyOrderReturnItemBuilder<P extends TestPharmacyOrderReturnBuilder<P, B>, B extends TestPharmacyOrderReturnItemBuilder<P, B>>
extends AbstractTestActBuilder<FinancialAct, B> {
    private final P parent;
    private Party patient;
    private Product product;
    private ValueStrategy quantity = ValueStrategy.unset();

    public TestPharmacyOrderReturnItemBuilder(P parent, String archetype, ArchetypeService service) {
        super(archetype, FinancialAct.class, service);
        this.parent = parent;
    }

    public B patient(Party patient) {
        this.patient = patient;
        return (B)((TestPharmacyOrderReturnItemBuilder)this.getThis());
    }

    public B product(Product product) {
        this.product = product;
        return (B)((TestPharmacyOrderReturnItemBuilder)this.getThis());
    }

    public B quantity(int quantity) {
        return this.quantity(BigDecimal.valueOf(quantity));
    }

    public B quantity(BigDecimal quantity) {
        this.quantity = ValueStrategy.value(quantity);
        return (B)((TestPharmacyOrderReturnItemBuilder)this.getThis());
    }

    public P add() {
        FinancialAct item = (FinancialAct)this.build(false);
        ((TestPharmacyOrderReturnBuilder)this.parent).add(item);
        return this.parent;
    }

    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        bean.setTarget("patient", (IMObject)this.patient);
        bean.setTarget("product", (IMObject)this.product);
        this.quantity.setValue(bean, "quantity");
    }
}

