/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.account;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentRefundBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class TestPaymentRefundItemBuilder<P extends TestPaymentRefundBuilder<P>, B extends TestPaymentRefundItemBuilder<P, B>>
extends AbstractTestIMObjectBuilder<FinancialAct, B> {
    private final P parent;
    private BigDecimal amount;

    public TestPaymentRefundItemBuilder(P parent, String archetype, ArchetypeService service) {
        super(archetype, FinancialAct.class, service);
        this.parent = parent;
    }

    public TestPaymentRefundItemBuilder(FinancialAct object, P parent, ArchetypeService service) {
        super(object, service);
        this.parent = parent;
    }

    public B amount(int amount) {
        return this.amount(BigDecimal.valueOf(amount));
    }

    public B amount(BigDecimal amount) {
        this.amount = amount;
        return (B)((TestPaymentRefundItemBuilder)this.getThis());
    }

    public P add() {
        HashSet<IMObject> objects = new HashSet<IMObject>();
        FinancialAct item = (FinancialAct)this.build(objects, new LinkedHashSet<Reference>());
        ((TestPaymentRefundBuilder)this.parent).add(item);
        ((AbstractTestIMObjectBuilder)this.parent).collect(objects);
        return this.parent;
    }

    public P getParent() {
        return this.parent;
    }

    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.amount != null) {
            object.setTotal(this.amount);
        }
    }

    protected void setPaymentType(IMObjectBean bean, ValueStrategy paymentType) {
        if (paymentType.isSet()) {
            String code = paymentType.toString();
            if (code != null) {
                ((TestLookupBuilder)new TestLookupBuilder("lookup.customPaymentType", this.getService()).code(code)).build();
            }
            paymentType.setValue(bean, "paymentType");
        }
    }
}

