/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.account;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.test.builder.act.AbstractTestActBuilder;
import org.openvpms.archetype.test.builder.customer.account.AbstractTestCustomerAccountActBuilder;
import org.openvpms.archetype.test.builder.customer.account.AbstractTestCustomerActBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentRefundBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentRefundItemBuilder;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.paymentprocessor.TestPaymentProcessorTransactionBuilder;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class TestPaymentProcessorItemBuilder<P extends TestPaymentRefundBuilder<P>, B extends TestPaymentProcessorItemBuilder<P, B>>
extends TestPaymentRefundItemBuilder<P, B> {
    private final List<FinancialAct> transactions = new ArrayList<FinancialAct>();
    private final List<String> transactionsToCreate = new ArrayList<String>();
    private Entity paymentProcessor;
    private ValueStrategy transactionMode = ValueStrategy.unset();
    private List<FinancialAct> builtTransactions = new ArrayList<FinancialAct>();

    protected TestPaymentProcessorItemBuilder(P parent, String archetype, ArchetypeService service) {
        super(parent, archetype, service);
        this.transactionMode(TransactionMode.LINK);
    }

    public TestPaymentProcessorItemBuilder(FinancialAct object, P parent, ArchetypeService service) {
        super(object, parent, service);
        this.paymentProcessor = (Entity)this.getBean((IMObject)object).getTarget("paymentProcessor", Entity.class);
    }

    public B processor(Entity paymentProcessor) {
        this.paymentProcessor = paymentProcessor;
        return (B)((TestPaymentProcessorItemBuilder)this.getThis());
    }

    public B transactionMode(TransactionMode transactionMode) {
        this.transactionMode = ValueStrategy.value(transactionMode.toString());
        return (B)((TestPaymentProcessorItemBuilder)this.getThis());
    }

    public B addTransaction(String status) {
        if (this.getParent() == null) {
            throw new IllegalStateException("Parent builder is required by addTransaction(status)");
        }
        this.transactionsToCreate.add(status);
        return (B)((TestPaymentProcessorItemBuilder)this.getThis());
    }

    public B addTransaction(FinancialAct transaction) {
        this.transactions.add(transaction);
        return (B)((TestPaymentProcessorItemBuilder)this.getThis());
    }

    public List<FinancialAct> getTransactions() {
        return this.builtTransactions;
    }

    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        bean.setTarget("paymentProcessor", (IMObject)this.paymentProcessor);
        this.transactionMode.setValue(bean, "transactionMode");
        Object parent = this.getParent();
        if (!this.transactionsToCreate.isEmpty()) {
            for (String status : this.transactionsToCreate) {
                TestPaymentProcessorTransactionBuilder<?> builder = this.createTransactionBuilder();
                Party customer = ((AbstractTestCustomerActBuilder)parent).getCustomer();
                if (customer == null) {
                    throw new IllegalStateException("Parent customer has not been set");
                }
                Party location = ((AbstractTestCustomerAccountActBuilder)parent).getLocation();
                if (location == null) {
                    throw new IllegalStateException("Parent location has not been set");
                }
                FinancialAct act = (FinancialAct)((AbstractTestIMObjectBuilder)((TestPaymentProcessorTransactionBuilder)((TestPaymentProcessorTransactionBuilder)((AbstractTestActBuilder)((TestPaymentProcessorTransactionBuilder)builder.customer(customer)).amount(object.getTotal())).status(status)).paymentProcessor(this.paymentProcessor)).location(location)).build(false);
                this.transactions.add(act);
            }
        }
        if (!this.transactions.isEmpty()) {
            int sequence = this.getNextSequence(bean, "transactions");
            for (FinancialAct act : this.transactions) {
                ActRelationship relationship = (ActRelationship)bean.addTarget("transactions", (IMObject)act);
                act.addActRelationship(relationship);
                relationship.setSequence(sequence++);
                toSave.add((IMObject)act);
                if (!act.getIdentities("actIdentity.paymentProcessorParentId").isEmpty() || parent == null) continue;
                ((TestPaymentRefundBuilder)parent).addPostBuildAction((builtObject, builtBean) -> {
                    if (builtObject.isNew()) {
                        throw new IllegalStateException(builtObject.getArchetype() + " must be saved");
                    }
                    act.addIdentity(this.createActIdentity("actIdentity.paymentProcessorParentId", Long.toString(builtObject.getId())));
                    this.getService().save((IMObject)act);
                });
            }
            this.builtTransactions = new ArrayList<FinancialAct>(this.transactions);
            this.transactions.clear();
        }
    }

    protected abstract TestPaymentProcessorTransactionBuilder<?> createTransactionBuilder();

    public static enum TransactionMode {
        LINK,
        STORED_CARD;

    }
}

