/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.account;

import java.math.BigDecimal;
import java.util.Set;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.test.builder.customer.account.TestEstimateBuilder;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestEstimateItemBuilder
extends AbstractTestIMObjectBuilder<Act, TestEstimateItemBuilder> {
    private final TestEstimateBuilder parent;
    private final CustomerAccountRules rules;
    private Party patient;
    private User clinician;
    private Product product;
    private Product template;
    private Integer group;
    private BigDecimal lowQuantity;
    private BigDecimal highQuantity;
    private BigDecimal fixedPrice;
    private BigDecimal lowUnitPrice;
    private BigDecimal highUnitPrice;
    private BigDecimal lowDiscount;
    private BigDecimal highDiscount;
    private Boolean print;

    public TestEstimateItemBuilder(TestEstimateBuilder parent, ArchetypeService service, CustomerAccountRules rules) {
        super("act.customerEstimationItem", Act.class, service);
        this.parent = parent;
        this.rules = rules;
    }

    public TestEstimateItemBuilder patient(Party patient) {
        this.patient = patient;
        return (TestEstimateItemBuilder)this.getThis();
    }

    public TestEstimateItemBuilder clinician(User clinician) {
        this.clinician = clinician;
        return (TestEstimateItemBuilder)this.getThis();
    }

    public TestEstimateItemBuilder product(Product product) {
        this.product = product;
        return (TestEstimateItemBuilder)this.getThis();
    }

    public TestEstimateItemBuilder template(Product template) {
        this.template = template;
        return (TestEstimateItemBuilder)this.getThis();
    }

    public TestEstimateItemBuilder group(int group) {
        this.group = group;
        return (TestEstimateItemBuilder)this.getThis();
    }

    public TestEstimateItemBuilder lowQuantity(int lowQuantity) {
        return this.lowQuantity(BigDecimal.valueOf(lowQuantity));
    }

    public TestEstimateItemBuilder lowQuantity(BigDecimal lowQuantity) {
        this.lowQuantity = lowQuantity;
        return (TestEstimateItemBuilder)this.getThis();
    }

    public TestEstimateItemBuilder highQuantity(int highQuantity) {
        return this.highQuantity(BigDecimal.valueOf(highQuantity));
    }

    public TestEstimateItemBuilder highQuantity(BigDecimal highQuantity) {
        this.highQuantity = highQuantity;
        return (TestEstimateItemBuilder)this.getThis();
    }

    public TestEstimateItemBuilder fixedPrice(int fixedPrice) {
        return this.fixedPrice(BigDecimal.valueOf(fixedPrice));
    }

    public TestEstimateItemBuilder fixedPrice(BigDecimal fixedPrice) {
        this.fixedPrice = fixedPrice;
        return (TestEstimateItemBuilder)this.getThis();
    }

    public TestEstimateItemBuilder lowUnitPrice(int lowUnitPrice) {
        return this.lowUnitPrice(BigDecimal.valueOf(lowUnitPrice));
    }

    public TestEstimateItemBuilder lowUnitPrice(BigDecimal lowUnitPrice) {
        this.lowUnitPrice = lowUnitPrice;
        return (TestEstimateItemBuilder)this.getThis();
    }

    public TestEstimateItemBuilder highUnitPrice(int highUnitPrice) {
        return this.highUnitPrice(BigDecimal.valueOf(highUnitPrice));
    }

    public TestEstimateItemBuilder highUnitPrice(BigDecimal highUnitPrice) {
        this.highUnitPrice = highUnitPrice;
        return (TestEstimateItemBuilder)this.getThis();
    }

    public TestEstimateItemBuilder lowDiscount(BigDecimal lowDiscount) {
        this.lowDiscount = lowDiscount;
        return (TestEstimateItemBuilder)this.getThis();
    }

    public TestEstimateItemBuilder highDiscount(BigDecimal highDiscount) {
        this.highDiscount = highDiscount;
        return (TestEstimateItemBuilder)this.getThis();
    }

    public TestEstimateItemBuilder print(boolean print) {
        this.print = print;
        return (TestEstimateItemBuilder)this.getThis();
    }

    public TestEstimateBuilder add() {
        Act item = (Act)this.build(false);
        this.parent.add(item);
        return this.parent;
    }

    @Override
    protected void build(Act object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.patient != null) {
            bean.setTarget("patient", (IMObject)this.patient);
        }
        if (this.clinician != null) {
            bean.setTarget("clinician", (IMObject)this.clinician);
        }
        if (this.product != null) {
            bean.setTarget("product", (IMObject)this.product);
        }
        if (this.template != null) {
            bean.setTarget("template", (IMObject)this.template);
            Participation participation = (Participation)bean.getObject("template", Participation.class);
            IMObjectBean participationBean = bean.getBean((IMObject)participation);
            participationBean.setValue("group", (Object)this.group);
        }
        if (this.lowQuantity != null) {
            bean.setValue("lowQty", (Object)this.lowQuantity);
        }
        if (this.highQuantity != null) {
            bean.setValue("highQty", (Object)this.highQuantity);
        }
        if (this.fixedPrice != null) {
            bean.setValue("fixedPrice", (Object)this.fixedPrice);
        }
        if (this.lowUnitPrice != null) {
            bean.setValue("lowUnitPrice", (Object)this.lowUnitPrice);
        }
        if (this.highUnitPrice != null) {
            bean.setValue("highUnitPrice", (Object)this.highUnitPrice);
        }
        if (this.lowDiscount != null) {
            bean.setValue("lowDiscount", (Object)this.lowDiscount);
        }
        if (this.highDiscount != null) {
            bean.setValue("highDiscount", (Object)this.highDiscount);
        }
        if (this.print != null) {
            bean.setValue("print", (Object)this.print);
        }
        BigDecimal lowTotal = this.rules.calculateTotal(bean.getBigDecimal("fixedPrice", BigDecimal.ZERO), bean.getBigDecimal("lowUnitPrice", BigDecimal.ZERO), bean.getBigDecimal("lowQty", BigDecimal.ZERO), bean.getBigDecimal("lowDiscount", BigDecimal.ZERO));
        BigDecimal highTotal = this.rules.calculateTotal(bean.getBigDecimal("fixedPrice", BigDecimal.ZERO), bean.getBigDecimal("highUnitPrice", BigDecimal.ZERO), bean.getBigDecimal("highQty", BigDecimal.ZERO), bean.getBigDecimal("highDiscount", BigDecimal.ZERO));
        bean.setValue("lowTotal", (Object)lowTotal);
        bean.setValue("highTotal", (Object)highTotal);
    }
}

