/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.test.builder.act.AbstractTestActBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestEstimateItemBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestEstimateBuilder
extends AbstractTestActBuilder<Act, TestEstimateBuilder> {
    private final CustomerAccountRules rules;
    private final List<Act> items = new ArrayList<Act>();
    private List<Act> builtItems = new ArrayList<Act>();
    private Party customer;
    private User clinician;

    public TestEstimateBuilder(ArchetypeService service, CustomerAccountRules rules) {
        super("act.customerEstimation", Act.class, service);
        this.rules = rules;
    }

    public TestEstimateBuilder customer(Party customer) {
        this.customer = customer;
        return (TestEstimateBuilder)this.getThis();
    }

    public TestEstimateBuilder clinician(User clinician) {
        this.clinician = clinician;
        return (TestEstimateBuilder)this.getThis();
    }

    public TestEstimateBuilder add(Act item) {
        this.items.add(item);
        return this;
    }

    public TestEstimateItemBuilder item() {
        return new TestEstimateItemBuilder(this, this.getService(), this.rules);
    }

    public List<Act> getItems() {
        return this.builtItems;
    }

    @Override
    protected void build(Act object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.customer != null) {
            bean.setTarget("customer", (IMObject)this.customer);
        }
        if (this.clinician != null) {
            bean.setTarget("clinician", (IMObject)this.clinician);
        }
        BigDecimal lowTotal = BigDecimal.ZERO;
        BigDecimal highTotal = BigDecimal.ZERO;
        int sequence = this.getNextSequence(bean, "items");
        for (Act item : this.items) {
            ActRelationship relationship = (ActRelationship)bean.addTarget("items", (IMObject)item);
            relationship.setSequence(sequence++);
            item.addActRelationship(relationship);
            toSave.add((IMObject)item);
            IMObjectBean itemBean = bean.getBean((IMObject)item);
            highTotal = highTotal.add(itemBean.getBigDecimal("highTotal"));
            lowTotal = lowTotal.add(itemBean.getBigDecimal("lowTotal"));
        }
        bean.setValue("highTotal", (Object)highTotal);
        bean.setValue("lowTotal", (Object)lowTotal);
        this.builtItems = new ArrayList<Act>(this.items);
        this.items.clear();
    }
}

