/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.openvpms.archetype.test.builder.act.AbstractTestActBuilder;
import org.openvpms.archetype.test.builder.customer.account.AbstractTestCustomerAccountActBuilder;
import org.openvpms.archetype.test.builder.customer.account.AbstractTestCustomerActBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentRefundBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentRefundItemBuilder;
import org.openvpms.archetype.test.builder.eft.AbstractTestEFTPOSTransactionBuilder;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class TestEFTItemBuilder<P extends TestPaymentRefundBuilder<P>, B extends TestPaymentRefundItemBuilder<P, B>>
extends TestPaymentRefundItemBuilder<P, B> {
    private final List<FinancialAct> eft = new ArrayList<FinancialAct>();
    private final List<Pair<String, Entity>> eftToCreate = new ArrayList<Pair<String, Entity>>();
    private BigDecimal cashout;

    protected TestEFTItemBuilder(P parent, String archetype, ArchetypeService service) {
        super(parent, archetype, service);
    }

    public B cashout(int cashout) {
        return this.cashout(BigDecimal.valueOf(cashout));
    }

    public B cashout(BigDecimal cashout) {
        this.cashout = cashout;
        return (B)((TestPaymentRefundItemBuilder)this.getThis());
    }

    public B addTransaction(String status, Entity terminal) {
        this.eftToCreate.add((Pair<String, Entity>)new ImmutablePair((Object)status, (Object)terminal));
        return (B)((TestPaymentRefundItemBuilder)this.getThis());
    }

    public B addTransaction(FinancialAct transaction) {
        this.eft.add(transaction);
        return (B)((TestPaymentRefundItemBuilder)this.getThis());
    }

    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.cashout != null) {
            bean.setValue("cashout", (Object)this.cashout);
        }
        if (!this.eftToCreate.isEmpty()) {
            Object parent = this.getParent();
            for (Pair<String, Entity> pair : this.eftToCreate) {
                AbstractTestEFTPOSTransactionBuilder<?> builder = this.createEFTPOSTransactionBuilder();
                Party customer = ((AbstractTestCustomerActBuilder)parent).getCustomer();
                if (customer == null) {
                    throw new IllegalStateException("Parent customer has not been set");
                }
                Party location = ((AbstractTestCustomerAccountActBuilder)parent).getLocation();
                if (location == null) {
                    throw new IllegalStateException("Parent location has not been set");
                }
                FinancialAct act = (FinancialAct)((AbstractTestIMObjectBuilder)((AbstractTestEFTPOSTransactionBuilder)((AbstractTestEFTPOSTransactionBuilder)((AbstractTestActBuilder)((AbstractTestEFTPOSTransactionBuilder)builder.customer(customer)).amount(object.getTotal())).status((String)pair.getLeft())).terminal((Entity)pair.getRight())).location(location)).build(false);
                ((TestPaymentRefundBuilder)this.getParent()).addPostBuildAction((builtObject, builtBean) -> {
                    if (builtObject.isNew()) {
                        throw new IllegalStateException(builtObject.getArchetype() + " must be saved");
                    }
                    act.addIdentity(this.createActIdentity("actIdentity.EFTPOSParentId", Long.toString(builtObject.getId())));
                });
                this.eft.add(act);
            }
        }
        if (!this.eft.isEmpty()) {
            int sequence = this.getNextSequence(bean, "transactions");
            for (FinancialAct act : this.eft) {
                ActRelationship relationship = (ActRelationship)bean.addTarget("transactions", (IMObject)act);
                act.addActRelationship(relationship);
                relationship.setSequence(sequence++);
                toSave.add((IMObject)act);
            }
            this.eft.clear();
        }
    }

    protected abstract AbstractTestEFTPOSTransactionBuilder<?> createEFTPOSTransactionBuilder();
}

