/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.act;

import java.util.Set;
import org.openvpms.archetype.rules.doc.TextDocumentHandler;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class InplaceLongTextBuilder {
    private final String node;
    private final ArchetypeService service;

    public InplaceLongTextBuilder(String node, ArchetypeService service) {
        this.node = node;
        this.service = service;
    }

    public void build(ValueStrategy value, DocumentAct act, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        if (value.isSet()) {
            Document content;
            String text = value.toString();
            Document document = content = act.getDocument() != null ? (Document)bean.getObject(act.getDocument(), Document.class) : null;
            if (text == null || text.length() <= bean.getMaxLength(this.node)) {
                bean.setValue(this.node, (Object)text);
                act.setDocument(null);
                if (content != null) {
                    toRemove.add((Reference)content.getObjectReference());
                }
            } else {
                bean.setValue(this.node, null);
                TextDocumentHandler handler = new TextDocumentHandler(this.service);
                if (content == null) {
                    content = handler.create("document", text);
                    act.setDocument((Reference)content.getObjectReference());
                } else {
                    handler.update(content, text);
                }
                toSave.add((IMObject)content);
            }
        }
    }
}

