/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.act;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class AbstractTestActBuilder<T extends Act, B extends AbstractTestActBuilder<T, B>>
extends AbstractTestIMObjectBuilder<T, B> {
    private final List<ActIdentity> identities = new ArrayList<ActIdentity>();
    private ValueStrategy startTime = ValueStrategy.unset();
    private ValueStrategy endTime = ValueStrategy.unset();
    private ValueStrategy reason = ValueStrategy.unset();
    private ValueStrategy status = ValueStrategy.unset();
    private ValueStrategy status2 = ValueStrategy.unset();

    public AbstractTestActBuilder(Class<T> type, ArchetypeService service) {
        super(type, service);
    }

    public AbstractTestActBuilder(String archetype, Class<T> type, ArchetypeService service) {
        super(archetype, type, service);
    }

    public AbstractTestActBuilder(T object, ArchetypeService service) {
        super(object, service);
    }

    public B startTime(String startTime) {
        return this.startTime(this.parseDate(startTime));
    }

    public B startTime(Date startTime) {
        return this.startTime(ValueStrategy.value(startTime));
    }

    public B startTime(ValueStrategy startTime) {
        this.startTime = startTime;
        return (B)((AbstractTestActBuilder)this.getThis());
    }

    public B endTime(String endTime) {
        return this.endTime(this.parseDate(endTime));
    }

    public B endTime(Date endTime) {
        return this.endTime(ValueStrategy.value(endTime));
    }

    public B endTime(ValueStrategy endTime) {
        this.endTime = endTime;
        return (B)((AbstractTestActBuilder)this.getThis());
    }

    public B reason(String reason) {
        return this.reason(ValueStrategy.value(reason));
    }

    public B reason(ValueStrategy reason) {
        this.reason = reason;
        return (B)((AbstractTestActBuilder)this.getThis());
    }

    public B status(String status) {
        this.status = ValueStrategy.value(status);
        return (B)((AbstractTestActBuilder)this.getThis());
    }

    public B status2(String status2) {
        this.status2 = ValueStrategy.value(status2);
        return (B)((AbstractTestActBuilder)this.getThis());
    }

    public B addIdentity(String archetype, String identity) {
        return this.addIdentities(this.createActIdentity(archetype, identity));
    }

    public B addIdentities(ActIdentity ... identities) {
        this.identities.addAll(Arrays.asList(identities));
        return (B)((AbstractTestActBuilder)this.getThis());
    }

    @Override
    protected void build(T object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.startTime.setValue(bean, "startTime");
        this.endTime.setValue(bean, "endTime");
        this.reason.setValue(bean, "reason");
        this.status.setValue(bean, "status");
        this.status2.setValue(bean, "status2");
        if (!this.identities.isEmpty()) {
            for (ActIdentity identity : this.identities) {
                object.addIdentity(identity);
            }
            this.identities.clear();
        }
    }
}

