/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.Date;
import java.util.Iterator;
import org.joda.time.Period;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.AppointmentService;
import org.openvpms.archetype.rules.workflow.FreeSlotQuery;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.rules.workflow.Slot;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestScheduleBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.service.cache.BasicEhcacheManager;
import org.openvpms.component.business.service.cache.EhcacheManager;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.springframework.beans.factory.annotation.Autowired;

public class FreeSlotQueryTestCase
extends ArchetypeServiceTest {
    @Autowired
    private AppointmentRules appointmentRules;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    @Autowired
    private TestUserFactory userFactory;
    private AppointmentService appointmentService;
    private RosterService rosterService;
    private Party location;

    @Before
    public void setUp() {
        this.location = this.practiceFactory.createLocation();
        this.appointmentService = new AppointmentService(this.getArchetypeService(), this.getLookupService(), (EhcacheManager)new BasicEhcacheManager(30L));
        this.rosterService = new RosterService(this.getArchetypeService(), (EhcacheManager)new BasicEhcacheManager(30L));
    }

    @After
    public void tearDown() throws Exception {
        this.appointmentService.destroy();
        this.rosterService.destroy();
    }

    @Test
    public void testFindFreeSlotsForSingleSchedule() {
        this.checkFindFreeSlotsForSingleSchedule(true);
        this.checkFindFreeSlotsForSingleSchedule(false);
    }

    @Test
    public void testFindFreeSlotsForMultipleSchedules() {
        this.checkFindFreeSlotsForMultipleSchedules(true);
        this.checkFindFreeSlotsForMultipleSchedules(false);
    }

    @Test
    public void testFindFreeSlotsForEmptySchedule() {
        this.checkFindFreeSlotsForEmptySchedule(true);
        this.checkFindFreeSlotsForEmptySchedule(false);
    }

    @Test
    public void testFindFreeSlotsForAppointmentDuringDateRange() {
        this.checkFindFreeSlotsForAppointmentDuringDateRange(true);
        this.checkFindFreeSlotsForAppointmentDuringDateRange(false);
    }

    @Test
    public void testFindFreeSlotForAppointmentAtStartOfDateRange() {
        this.checkFindFreeSlotForAppointmentAtStartOfDateRange(true);
        this.checkFindFreeSlotForAppointmentAtStartOfDateRange(false);
    }

    @Test
    public void testFindFreeSlotForAppointmentOverlappingStart() {
        this.checkFindFreeSlotForAppointmentOverlappingStart(true);
        this.checkFindFreeSlotForAppointmentOverlappingStart(false);
    }

    @Test
    public void testFindFreeSlotsForSingleAppointment() {
        this.checkFindFreeSlotsForSingleAppointment(true);
        this.checkFindFreeSlotsForSingleAppointment(false);
    }

    @Test
    public void testDuplicateAppointments() {
        this.checkDuplicateAppointments(true);
        this.checkDuplicateAppointments(false);
    }

    @Test
    public void testOverlappingAppointments() {
        this.checkOverlappingAppointments(true);
        this.checkOverlappingAppointments(false);
    }

    @Test
    public void testMinSlotSize() {
        this.checkMinSlotSize(true);
        this.checkMinSlotSize(false);
    }

    @Test
    public void testFindFreeSlotsForLimitedScheduleTimes() {
        this.checkFindFreeSlotsForLimitedScheduleTimes(true);
        this.checkFindFreeSlotsForLimitedScheduleTimes(false);
    }

    @Test
    public void testFindFreeSlotsWithFromTimeRange() {
        this.checkFindFreeSlotsWithFromTimeRange(true);
        this.checkFindFreeSlotsWithFromTimeRange(false);
    }

    @Test
    public void testFindFreeSlotsWithToTimeRange() {
        this.checkFindFreeSlotsWithToTimeRange(true);
        this.checkFindFreeSlotsWithToTimeRange(false);
    }

    @Test
    public void testFindFreeSlotsWithFromToTimeRange() {
        this.checkFindFreeSlotsWithFromToTimeRange(true);
        this.checkFindFreeSlotsWithFromToTimeRange(false);
    }

    @Test
    public void testFreeSlotSplitsOverScheduleTimes() {
        this.checkFreeSlotSplitsOverScheduleTimes(true);
        this.checkFreeSlotSplitsOverScheduleTimes(false);
    }

    @Test
    public void testFindFreeSlotFor24HourSchedule() {
        this.checkFindFreeSlotFor24HourSchedule(true);
        this.checkFindFreeSlotFor24HourSchedule(false);
    }

    @Test
    public void testFindFreeSlotFor0HourStart() {
        this.checkFindFreeSlotFor0HourStart(true);
        this.checkFindFreeSlotFor0HourStart(false);
    }

    @Test
    public void testFindFreeSlotFor24HourEnd() {
        this.checkFindFreeSlotFor24HourEnd(true);
        this.checkFindFreeSlotFor24HourEnd(false);
    }

    @Test
    public void testFindFreeSlotForCageType() {
        Entity cageType1 = this.schedulingFactory.createCageType();
        Entity cageType2 = this.schedulingFactory.createCageType();
        Entity schedule = this.createSchedule("09:00", "24:00", cageType1);
        FreeSlotQuery query = this.createQuery("2014-01-01", "2014-01-03", schedule);
        query.setCageType(cageType1);
        Iterator<Slot> iterator1 = this.createIterator(query);
        this.checkSlot(iterator1, schedule, "2014-01-01 09:00:00", "2014-01-02 00:00:00");
        this.checkSlot(iterator1, schedule, "2014-01-02 09:00:00", "2014-01-03 00:00:00");
        query.setCageType(cageType2);
        Iterator<Slot> iterator2 = this.createIterator(query);
        Assert.assertFalse((boolean)iterator2.hasNext());
        query.setCageType(null);
        Iterator<Slot> iterator3 = this.createIterator(query);
        this.checkSlot(iterator3, schedule, "2014-01-01 09:00:00", "2014-01-02 00:00:00");
        this.checkSlot(iterator3, schedule, "2014-01-02 09:00:00", "2014-01-03 00:00:00");
    }

    @Test
    public void testUnrosteredClinician() {
        Entity schedule1 = this.createSchedule(null, null, true);
        this.createAppointment("2019-04-01 09:00:00", "2019-04-01 09:15:00", schedule1);
        this.createAppointment("2019-04-01 10:00:00", "2019-04-01 10:15:00", schedule1);
        FreeSlotQuery query = this.createQuery("2019-04-01", "2019-04-02", schedule1);
        query.setClinician(this.userFactory.createClinician());
        Iterator<Slot> iterator = this.createIterator(query);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testRosteredClinician() {
        User clinician = this.userFactory.createClinician();
        Entity schedule1 = this.createSchedule(null, null, true);
        Entity schedule2 = this.createSchedule(null, null, true);
        Entity area = this.schedulingFactory.createRosterArea(this.location, schedule1, schedule2);
        Act shift = ScheduleTestHelper.createRosterEvent(TestHelper.getDatetime("2019-04-01 09:00:00"), TestHelper.getDatetime("2019-04-01 17:00:00"), clinician, area, this.location);
        this.save((IMObject)shift);
        FreeSlotQuery query = this.createQuery("2019-04-01", "2019-04-02", schedule1);
        query.setClinician(clinician);
        Iterator<Slot> iterator1 = this.createIterator(query);
        this.checkSlot(iterator1, schedule1, "2019-04-01 09:00:00", "2019-04-01 17:00:00");
        this.createAppointment("2019-04-01 09:00:00", "2019-04-01 09:15:00", schedule1);
        this.createAppointment("2019-04-01 10:00:00", "2019-04-01 10:15:00", schedule1);
        this.createAppointment("2019-04-01 10:15:00", "2019-04-01 10:45:00", schedule2, clinician);
        this.createAppointment("2019-04-01 11:00:00", "2019-04-01 11:30:00", schedule2, clinician);
        Iterator<Slot> iterator2 = this.createIterator(query);
        this.checkSlot(iterator2, schedule1, "2019-04-01 09:15:00", "2019-04-01 10:00:00");
        this.checkSlot(iterator2, schedule1, "2019-04-01 10:45:00", "2019-04-01 11:00:00");
        this.checkSlot(iterator2, schedule1, "2019-04-01 11:30:00", "2019-04-01 17:00:00");
        this.createAppointment("2019-04-01 15:00:00", "2019-04-01 16:00:00", schedule2, clinician);
        Iterator<Slot> iterator3 = this.createIterator(query);
        this.checkSlot(iterator3, schedule1, "2019-04-01 09:15:00", "2019-04-01 10:00:00");
        this.checkSlot(iterator3, schedule1, "2019-04-01 10:45:00", "2019-04-01 11:00:00");
        this.checkSlot(iterator3, schedule1, "2019-04-01 11:30:00", "2019-04-01 15:00:00");
        this.checkSlot(iterator3, schedule1, "2019-04-01 16:00:00", "2019-04-01 17:00:00");
        this.createAppointment("2019-04-01 16:00:00", "2019-04-01 17:30:00", schedule2, clinician);
        Iterator<Slot> iterator4 = this.createIterator(query);
        this.checkSlot(iterator4, schedule1, "2019-04-01 09:15:00", "2019-04-01 10:00:00");
        this.checkSlot(iterator4, schedule1, "2019-04-01 10:45:00", "2019-04-01 11:00:00");
        this.checkSlot(iterator4, schedule1, "2019-04-01 11:30:00", "2019-04-01 15:00:00");
        query.setSchedules(new Entity[]{schedule2});
        Iterator<Slot> iterator5 = this.createIterator(query);
        this.checkSlot(iterator5, schedule2, "2019-04-01 09:00:00", "2019-04-01 10:15:00");
        this.checkSlot(iterator5, schedule2, "2019-04-01 10:45:00", "2019-04-01 11:00:00");
        this.checkSlot(iterator5, schedule2, "2019-04-01 11:30:00", "2019-04-01 15:00:00");
    }

    private void checkFindFreeSlotsForSingleSchedule(boolean maxDuration) {
        Entity schedule1 = this.createSchedule(null, null, maxDuration);
        this.createAppointment("2014-01-01 09:00:00", "2014-01-01 09:15:00", schedule1);
        this.createAppointment("2014-01-01 10:00:00", "2014-01-01 10:15:00", schedule1);
        Iterator<Slot> iterator = this.createIterator("2014-01-01", "2014-01-02", schedule1);
        this.checkSlot(iterator, schedule1, "2014-01-01 00:00:00", "2014-01-01 09:00:00");
        this.checkSlot(iterator, schedule1, "2014-01-01 09:15:00", "2014-01-01 10:00:00");
        this.checkSlot(iterator, schedule1, "2014-01-01 10:15:00", "2014-01-02 00:00:00");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private void checkFindFreeSlotsForMultipleSchedules(boolean maxDuration) {
        Entity schedule1 = this.createSchedule(null, null, maxDuration);
        Entity schedule2 = this.createSchedule(null, null, maxDuration);
        this.createAppointment("2014-01-01 09:00:00", "2014-01-01 09:15:00", schedule1);
        this.createAppointment("2014-01-01 10:00:00", "2014-01-01 10:15:00", schedule1);
        this.createAppointment("2014-01-01 09:00:00", "2014-01-01 09:30:00", schedule2);
        this.createAppointment("2014-01-01 09:45:00", "2014-01-01 10:30:00", schedule2);
        Iterator<Slot> query = this.createIterator("2014-01-01", "2014-01-02", schedule1, schedule2);
        this.checkSlot(query, schedule1, "2014-01-01 00:00:00", "2014-01-01 09:00:00");
        this.checkSlot(query, schedule2, "2014-01-01 00:00:00", "2014-01-01 09:00:00");
        this.checkSlot(query, schedule1, "2014-01-01 09:15:00", "2014-01-01 10:00:00");
        this.checkSlot(query, schedule2, "2014-01-01 09:30:00", "2014-01-01 09:45:00");
        this.checkSlot(query, schedule1, "2014-01-01 10:15:00", "2014-01-02 00:00:00");
        this.checkSlot(query, schedule2, "2014-01-01 10:30:00", "2014-01-02 00:00:00");
        Assert.assertFalse((boolean)query.hasNext());
    }

    private void checkFindFreeSlotsForEmptySchedule(boolean maxDuration) {
        Entity schedule = this.createSchedule(null, null, maxDuration);
        Iterator<Slot> query = this.createIterator("2014-01-01", "2014-01-02", schedule);
        this.checkSlot(query, schedule, "2014-01-01 00:00:00", "2014-01-02 00:00:00");
        Assert.assertFalse((boolean)query.hasNext());
    }

    private void checkFindFreeSlotsForAppointmentDuringDateRange(boolean maxDuration) {
        Entity schedule = this.createSchedule(null, null, maxDuration);
        this.createAppointment("2014-01-01 09:00:00", "2014-01-01 09:15:00", schedule);
        Iterator<Slot> query = this.createIterator("2014-01-01", "2014-01-02", schedule);
        this.checkSlot(query, schedule, "2014-01-01 00:00:00", "2014-01-01 09:00:00");
        this.checkSlot(query, schedule, "2014-01-01 09:15:00", "2014-01-02 00:00:00");
        Assert.assertFalse((boolean)query.hasNext());
    }

    private void checkFindFreeSlotForAppointmentAtStartOfDateRange(boolean maxDuration) {
        Entity schedule = this.createSchedule(null, null, maxDuration);
        this.createAppointment("2014-01-01 00:00:00", "2014-01-01 09:00:00", schedule);
        Iterator<Slot> query = this.createIterator("2014-01-01", "2014-01-02", schedule);
        this.checkSlot(query, schedule, "2014-01-01 09:00:00", "2014-01-02 00:00:00");
        Assert.assertFalse((boolean)query.hasNext());
    }

    private void checkFindFreeSlotForAppointmentOverlappingStart(boolean maxDuration) {
        Entity schedule = this.createSchedule(null, null, maxDuration);
        this.createAppointment("2013-12-31 09:00:00", "2014-01-01 08:00:00", schedule);
        Iterator<Slot> query = this.createIterator("2014-01-01", "2014-01-02", schedule);
        this.checkSlot(query, schedule, "2014-01-01 08:00:00", "2014-01-02 00:00:00");
        Assert.assertFalse((boolean)query.hasNext());
    }

    private void checkFindFreeSlotsForSingleAppointment(boolean maxDuration) {
        Entity schedule = this.createSchedule(null, null, maxDuration);
        this.createAppointment("2014-01-01 17:00:00", "2014-01-02 00:00:00", schedule);
        Iterator<Slot> query = this.createIterator("2014-01-01", "2014-01-02", schedule);
        this.checkSlot(query, schedule, "2014-01-01 00:00:00", "2014-01-01 17:00:00");
        Assert.assertFalse((boolean)query.hasNext());
    }

    private void checkDuplicateAppointments(boolean maxDuration) {
        Entity schedule1 = this.createSchedule(null, null, maxDuration);
        this.createAppointment("2014-01-01 09:00:00", "2014-01-01 09:15:00", schedule1);
        this.createAppointment("2014-01-01 09:00:00", "2014-01-01 09:15:00", schedule1);
        this.createAppointment("2014-01-01 10:00:00", "2014-01-01 10:15:00", schedule1);
        this.createAppointment("2014-01-01 10:00:00", "2014-01-01 10:15:00", schedule1);
        Iterator<Slot> query = this.createIterator("2014-01-01", "2014-01-02", schedule1);
        this.checkSlot(query, schedule1, "2014-01-01 00:00:00", "2014-01-01 09:00:00");
        this.checkSlot(query, schedule1, "2014-01-01 09:15:00", "2014-01-01 10:00:00");
        this.checkSlot(query, schedule1, "2014-01-01 10:15:00", "2014-01-02 00:00:00");
        Assert.assertFalse((boolean)query.hasNext());
    }

    private void checkOverlappingAppointments(boolean maxDuration) {
        Entity schedule = this.createSchedule(null, null, maxDuration);
        this.createAppointment("2014-01-01 09:00:00", "2014-01-01 09:15:00", schedule);
        this.createAppointment("2014-01-01 09:00:00", "2014-01-01 09:30:00", schedule);
        this.createAppointment("2014-01-01 09:45:00", "2014-01-01 10:15:00", schedule);
        this.createAppointment("2014-01-01 10:00:00", "2014-01-01 10:30:00", schedule);
        Iterator<Slot> query = this.createIterator("2014-01-01", "2014-01-02", schedule);
        this.checkSlot(query, schedule, "2014-01-01 00:00:00", "2014-01-01 09:00:00");
        this.checkSlot(query, schedule, "2014-01-01 09:30:00", "2014-01-01 09:45:00");
        this.checkSlot(query, schedule, "2014-01-01 10:30:00", "2014-01-02 00:00:00");
        Assert.assertFalse((boolean)query.hasNext());
    }

    private void checkMinSlotSize(boolean maxDuration) {
        Entity schedule = this.createSchedule(null, null, maxDuration);
        this.createAppointment("2013-12-31 09:00:00", "2014-01-01 08:00:00", schedule);
        this.createAppointment("2014-01-01 09:00:00", "2014-01-01 09:45:00", schedule);
        this.createAppointment("2014-01-01 10:00:00", "2014-01-01 10:15:00", schedule);
        this.createAppointment("2014-01-01 11:00:00", "2014-01-01 11:15:00", schedule);
        FreeSlotQuery query = this.createQuery("2014-01-01", "2014-01-02", schedule);
        query.setMinSlotSize(30, DateUnits.MINUTES);
        Iterator iterator = query.query();
        this.checkSlot((Iterator<Slot>)iterator, schedule, "2014-01-01 08:00:00", "2014-01-01 09:00:00");
        this.checkSlot((Iterator<Slot>)iterator, schedule, "2014-01-01 10:15:00", "2014-01-01 11:00:00");
        this.checkSlot((Iterator<Slot>)iterator, schedule, "2014-01-01 11:15:00", "2014-01-02 00:00:00");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private void checkFindFreeSlotsForLimitedScheduleTimes(boolean maxDuration) {
        Entity schedule = this.createSchedule("09:00", "17:00", maxDuration);
        this.createAppointment("2013-12-31 09:00:00", "2014-01-01 08:00:00", schedule);
        this.createAppointment("2014-01-01 09:30:00", "2014-01-01 09:45:00", schedule);
        this.createAppointment("2014-01-02 09:00:00", "2014-01-02 10:00:00", schedule);
        Iterator<Slot> query = this.createIterator("2014-01-01", "2014-01-03", schedule);
        this.checkSlot(query, schedule, "2014-01-01 09:00:00", "2014-01-01 09:30:00");
        this.checkSlot(query, schedule, "2014-01-01 09:45:00", "2014-01-01 17:00:00");
        this.checkSlot(query, schedule, "2014-01-02 10:00:00", "2014-01-02 17:00:00");
        Assert.assertFalse((boolean)query.hasNext());
    }

    private void checkFindFreeSlotsWithFromTimeRange(boolean maxDuration) {
        Entity schedule = this.createSchedule(null, null, maxDuration);
        this.createAppointment("2013-12-31 09:00:00", "2014-01-01 08:00:00", schedule);
        this.createAppointment("2014-01-01 09:00:00", "2014-01-01 09:15:00", schedule);
        this.createAppointment("2014-01-01 10:00:00", "2014-01-01 10:15:00", schedule);
        this.createAppointment("2014-01-01 10:30:00", "2014-01-01 11:00:00", schedule);
        FreeSlotQuery query = this.createQuery("2014-01-01", "2014-01-02", schedule);
        query.setFromTime(this.getTime("09:30"));
        Iterator<Slot> iterator = this.createIterator(query);
        this.checkSlot(iterator, schedule, "2014-01-01 09:30:00", "2014-01-01 10:00:00");
        this.checkSlot(iterator, schedule, "2014-01-01 10:15:00", "2014-01-01 10:30:00");
        this.checkSlot(iterator, schedule, "2014-01-01 11:00:00", "2014-01-02 00:00:00");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private void checkFindFreeSlotsWithToTimeRange(boolean maxDuration) {
        Entity schedule = this.createSchedule(null, null, maxDuration);
        this.createAppointment("2013-12-31 09:00:00", "2014-01-01 08:00:00", schedule);
        this.createAppointment("2014-01-01 09:00:00", "2014-01-01 09:15:00", schedule);
        this.createAppointment("2014-01-01 10:00:00", "2014-01-01 10:15:00", schedule);
        this.createAppointment("2014-01-01 10:30:00", "2014-01-01 11:00:00", schedule);
        FreeSlotQuery query = this.createQuery("2014-01-01", "2014-01-02", schedule);
        query.setToTime(this.getTime("09:30"));
        Iterator<Slot> iterator = this.createIterator(query);
        this.checkSlot(iterator, schedule, "2014-01-01 08:00:00", "2014-01-01 09:00:00");
        this.checkSlot(iterator, schedule, "2014-01-01 09:15:00", "2014-01-01 09:30:00");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private void checkFindFreeSlotsWithFromToTimeRange(boolean maxDuration) {
        Entity schedule = this.createSchedule(null, null, maxDuration);
        this.createAppointment("2013-12-31 09:00:00", "2014-01-01 08:00:00", schedule);
        this.createAppointment("2014-01-01 09:00:00", "2014-01-01 09:15:00", schedule);
        this.createAppointment("2014-01-01 10:00:00", "2014-01-01 10:15:00", schedule);
        this.createAppointment("2014-01-01 10:30:00", "2014-01-01 11:00:00", schedule);
        FreeSlotQuery query = this.createQuery("2014-01-01", "2014-01-02", schedule);
        query.setFromTime(this.getTime("9:00"));
        query.setToTime(this.getTime("10:00"));
        query.setSchedules(new Entity[]{schedule});
        Iterator<Slot> iterator = this.createIterator(query);
        this.checkSlot(iterator, schedule, "2014-01-01 09:15:00", "2014-01-01 10:00:00");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private void checkFreeSlotSplitsOverScheduleTimes(boolean maxDuration) {
        Entity schedule = this.createSchedule("09:00", "17:00", maxDuration);
        Iterator<Slot> query = this.createIterator("2014-01-01", "2014-01-03", schedule);
        this.checkSlot(query, schedule, "2014-01-01 09:00:00", "2014-01-01 17:00:00");
        this.checkSlot(query, schedule, "2014-01-02 09:00:00", "2014-01-02 17:00:00");
        Assert.assertFalse((boolean)query.hasNext());
    }

    private void checkFindFreeSlotFor24HourSchedule(boolean maxDuration) {
        Entity schedule = this.createSchedule("00:00", "24:00", maxDuration);
        Iterator<Slot> query1 = this.createIterator("2014-01-01", "2014-01-03", schedule);
        this.checkSlot(query1, schedule, "2014-01-01 00:00:00", "2014-01-03 00:00:00");
        Assert.assertFalse((boolean)query1.hasNext());
        this.createAppointment(TestHelper.getDate("2014-01-01"), TestHelper.getDate("2014-01-02"), schedule);
        Iterator<Slot> query2 = this.createIterator("2014-01-01", "2014-01-03", schedule);
        this.checkSlot(query2, schedule, "2014-01-02 00:00:00", "2014-01-03 00:00:00");
        this.createAppointment(TestHelper.getDate("2014-01-02"), TestHelper.getDate("2014-01-03"), schedule);
        Iterator<Slot> query3 = this.createIterator("2014-01-01", "2014-01-03", schedule);
        Assert.assertFalse((boolean)query3.hasNext());
    }

    private void checkFindFreeSlotFor0HourStart(boolean maxDuration) {
        Entity schedule = this.createSchedule("00:00", "17:00", maxDuration);
        Iterator<Slot> query = this.createIterator("2014-01-01", "2014-01-03", schedule);
        this.checkSlot(query, schedule, "2014-01-01 00:00:00", "2014-01-01 17:00:00");
        this.checkSlot(query, schedule, "2014-01-02 00:00:00", "2014-01-02 17:00:00");
        Assert.assertFalse((boolean)query.hasNext());
    }

    private void checkFindFreeSlotFor24HourEnd(boolean maxDuration) {
        Entity schedule = this.createSchedule("09:00", "24:00", maxDuration);
        Iterator<Slot> query = this.createIterator("2014-01-01", "2014-01-03", schedule);
        this.checkSlot(query, schedule, "2014-01-01 09:00:00", "2014-01-02 00:00:00");
        this.checkSlot(query, schedule, "2014-01-02 09:00:00", "2014-01-03 00:00:00");
        Assert.assertFalse((boolean)query.hasNext());
    }

    private FreeSlotQuery createQuery(String fromDate, String toDate, Entity ... schedules) {
        FreeSlotQuery query = new FreeSlotQuery(this.getArchetypeService(), this.appointmentService, this.rosterService, this.appointmentRules);
        query.setFromDate(TestHelper.getDate(fromDate));
        query.setToDate(TestHelper.getDate(toDate));
        query.setSchedules(schedules);
        return query;
    }

    private Iterator<Slot> createIterator(String fromDate, String toDate, Entity ... schedules) {
        FreeSlotQuery query = this.createQuery(fromDate, toDate, schedules);
        return this.createIterator(query);
    }

    private Iterator<Slot> createIterator(FreeSlotQuery query) {
        long start = System.currentTimeMillis();
        Iterator iterator = query.query();
        long end = System.currentTimeMillis();
        System.out.println("Executed query in " + (end - start) + "ms");
        return iterator;
    }

    private void checkSlot(Iterator<Slot> iterator, Entity schedule, String startTime, String endTime) {
        this.checkSlot(iterator, schedule, TestHelper.getDatetime(startTime), TestHelper.getDatetime(endTime));
    }

    private void checkSlot(Iterator<Slot> iterator, Entity schedule, Date startTime, Date endTime) {
        Assert.assertTrue((boolean)iterator.hasNext());
        Slot slot = iterator.next();
        Assert.assertEquals((long)schedule.getId(), (long)slot.getSchedule());
        this.checkDate(startTime, slot.getStartTime());
        this.checkDate(endTime, slot.getEndTime());
    }

    private void checkDate(Date expected, Date actual) {
        Assert.assertEquals((String)("expected=" + expected + ", actual=" + actual), (long)0L, (long)DateRules.compareTo((Date)expected, (Date)actual));
    }

    private Period getTime(String time) {
        PeriodFormatterBuilder builder = new PeriodFormatterBuilder().appendHours().appendLiteral(":").appendMinutes();
        PeriodFormatter formatter = builder.toFormatter();
        return formatter.parsePeriod(time);
    }

    private Entity createSchedule(String startTime, String endTime, boolean maxDuration) {
        TestScheduleBuilder builder = this.schedulingFactory.newSchedule();
        builder.location(this.location).times(startTime, endTime);
        if (maxDuration) {
            builder.maxDuration(24, DateUnits.HOURS);
        } else {
            builder.noMaxDuration();
        }
        return (Entity)builder.build();
    }

    private Entity createSchedule(String startTime, String endTime, Entity cageType) {
        return (Entity)this.schedulingFactory.newSchedule().location(this.location).times(startTime, endTime).cageType(cageType).build();
    }

    private void createAppointment(Date startTime, Date endTime, Entity schedule) {
        ((TestAppointmentBuilder)((TestAppointmentBuilder)this.newAppointment(schedule).startTime(startTime)).endTime(endTime)).build();
    }

    private TestAppointmentBuilder newAppointment(Entity schedule) {
        return ((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().schedule(schedule).customer(this.customerFactory.createCustomer())).patient(this.patientFactory.createPatient())).appointmentType(this.schedulingFactory.createAppointmentType());
    }

    private void createAppointment(String startTime, String endTime, Entity schedule) {
        ((TestAppointmentBuilder)((TestAppointmentBuilder)this.newAppointment(schedule).startTime(startTime)).endTime(endTime)).build();
    }

    private void createAppointment(String startTime, String endTime, Entity schedule, User clinician) {
        ((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.newAppointment(schedule).startTime(startTime)).endTime(endTime)).clinician(clinician)).build();
    }
}

