/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AbstractScheduleServiceTest;
import org.openvpms.archetype.rules.workflow.AppointmentService;
import org.openvpms.archetype.rules.workflow.ScheduleArchetypes;
import org.openvpms.archetype.rules.workflow.ScheduleEventCache;
import org.openvpms.archetype.rules.workflow.ScheduleEventFactory;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.ScheduleService;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.rules.workflow.ScheduleTimes;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.archetype.rules.workflow.cache.DayCache;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.service.cache.BasicEhcacheManager;
import org.openvpms.component.business.service.cache.EhcacheManager;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.util.PropertySet;
import org.springframework.beans.factory.annotation.Autowired;

public class AppointmentServiceTestCase
extends AbstractScheduleServiceTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    @Autowired
    private TestUserFactory userFactory;
    private Entity schedule;
    private Party location;

    @Before
    public void setUp() {
        this.location = this.practiceFactory.createLocation();
        this.schedule = this.schedulingFactory.createSchedule(this.location);
    }

    @Override
    @Test
    public void testAddEvent() {
        Date date1 = TestHelper.getDate("2008-01-01");
        Date date2 = TestHelper.getDate("2008-01-02");
        Date date3 = TestHelper.getDate("2008-01-03");
        AppointmentService service = this.initScheduleService(30);
        long hash1 = this.checkEvents(this.schedule, date1, 0);
        this.checkEvents(this.schedule, date2, 0);
        Act appointment = this.createAppointment(date1);
        ScheduleEvents events3 = service.getScheduleEvents(this.schedule, date1);
        Assert.assertEquals((long)1L, (long)events3.size());
        PropertySet set = (PropertySet)events3.getEvents().get(0);
        this.checkAppointment(appointment, set);
        Assert.assertNotEquals((long)hash1, (long)events3.getModHash());
        this.checkEvents(this.schedule, date2, 0);
        this.checkEvents(this.schedule, date3, 0);
    }

    @Override
    @Test
    public void testRemoveEvent() {
        Date date1 = TestHelper.getDate("2008-01-01");
        Date date2 = TestHelper.getDate("2008-01-02");
        Date date3 = TestHelper.getDate("2008-01-03");
        this.initScheduleService(30);
        long hash1 = this.checkEvents(this.schedule, date1, 0);
        long hash2 = this.checkEvents(this.schedule, date2, 0);
        long hash3 = this.checkEvents(this.schedule, date3, 0);
        Assert.assertNotEquals((long)hash1, (long)hash2);
        Assert.assertNotEquals((long)hash1, (long)hash3);
        Act appointment = this.createAppointment(date1);
        long hash4 = this.checkEvents(this.schedule, date1, 1);
        Assert.assertNotEquals((long)hash1, (long)hash4);
        this.checkEvents(this.schedule, date2, 0, hash2);
        this.checkEvents(this.schedule, date3, 0, hash3);
        this.remove((IMObject)appointment);
        long hash5 = this.checkEvents(this.schedule, date1, 0);
        Assert.assertNotEquals((long)hash1, (long)hash5);
        this.checkEvents(this.schedule, date2, 0, hash2);
        this.checkEvents(this.schedule, date3, 0, hash3);
    }

    @Test
    public void testGetEvents() {
        int count = 10;
        Entity schedule = this.schedulingFactory.createSchedule(this.location);
        Act[] appointments = new Act[10];
        Date date = TestHelper.getDate("2007-01-01");
        for (int i = 0; i < 10; ++i) {
            Act appointment;
            Date startTime = DateRules.getDate((Date)date, (int)150, (DateUnits)DateUnits.MINUTES);
            Date endTime = DateRules.getDate((Date)startTime, (int)15, (DateUnits)DateUnits.MINUTES);
            Date arrivalTime = i % 2 == 0 ? new Date() : null;
            Party patient = this.patientFactory.createPatient();
            User clinician = this.userFactory.createClinician();
            appointments[i] = appointment = (Act)((TestAppointmentBuilder)this.newAppointment(startTime, endTime, schedule, patient).clinician(clinician)).arrivalTime(arrivalTime).build();
        }
        AppointmentService service = this.initScheduleService(30);
        List results = service.getEvents(schedule, date);
        Assert.assertEquals((long)10L, (long)results.size());
        for (int i = 0; i < results.size(); ++i) {
            PropertySet set = (PropertySet)results.get(i);
            this.checkAppointment(appointments[i], set);
        }
    }

    @Override
    @Test
    public void testChangeEventDate() {
        Date date1 = TestHelper.getDate("2008-01-01");
        Date date2 = TestHelper.getDate("2008-03-01");
        this.initScheduleService(30);
        long hash1 = this.checkEvents(this.schedule, date1, 0);
        long hash2 = this.checkEvents(this.schedule, date2, 0);
        Act act = this.createAppointment(date1);
        long hash3 = this.checkEvents(this.schedule, date1, 1);
        Assert.assertNotEquals((long)hash1, (long)hash3);
        this.checkEvents(this.schedule, date2, 0, hash2);
        act.setActivityStartTime(date2);
        act.setActivityEndTime(DateRules.getDate((Date)date2, (int)15, (DateUnits)DateUnits.MINUTES));
        this.save((IMObject)act);
        long hash4 = this.checkEvents(this.schedule, date1, 0);
        long hash5 = this.checkEvents(this.schedule, date2, 1);
        Assert.assertNotEquals((long)hash3, (long)hash4);
        Assert.assertNotEquals((long)hash2, (long)hash5);
    }

    @Test
    public void testAddReason() {
        Date date1 = TestHelper.getDate("2008-01-01");
        Date date2 = TestHelper.getDate("2008-01-02");
        Party patient = TestHelper.createPatient();
        Act appointment1 = this.createAppointment(date1);
        AppointmentService service = this.initScheduleService(30);
        ScheduleEvents events = service.getScheduleEvents(this.schedule, date1);
        Assert.assertEquals((long)1L, (long)events.size());
        PropertySet set = (PropertySet)events.getEvents().get(0);
        this.checkAppointment(appointment1, set);
        String code = "XREASON" + System.currentTimeMillis();
        String name = "Added reason";
        Lookup reason = TestHelper.getLookup(ScheduleArchetypes.VISIT_REASON, code, name, false);
        this.save((IMObject)reason);
        Act appointment2 = this.createAppointment(date2, this.schedule, patient, false);
        appointment2.setReason(code);
        this.save((IMObject)appointment2);
        ScheduleEvents events2 = service.getScheduleEvents(this.schedule, date2);
        Assert.assertEquals((long)1L, (long)events2.size());
        set = (PropertySet)events2.getEvents().get(0);
        Assert.assertEquals((Object)code, (Object)set.getString("act.reason"));
        Assert.assertEquals((Object)name, (Object)set.getString("act.reasonName"));
    }

    @Test
    public void testUpdateReason() {
        Date date = TestHelper.getDate("2008-01-01");
        AppointmentService service = this.initScheduleService(30);
        this.lookupFactory.createLookup(ScheduleArchetypes.VISIT_REASON, "CHECKUP", true);
        Act appointment = this.createAppointment(date);
        ScheduleEvents events1 = service.getScheduleEvents(this.schedule, date);
        Assert.assertEquals((long)1L, (long)events1.size());
        PropertySet set1 = (PropertySet)events1.getEvents().get(0);
        this.checkAppointment(appointment, set1);
        Lookup reason = this.getLookupService().getLookup((IMObject)appointment, "reason");
        Assert.assertNotNull((Object)reason);
        String name = "New reason: " + System.currentTimeMillis();
        reason.setName(name);
        this.save((IMObject)reason);
        ScheduleEvents events2 = service.getScheduleEvents(this.schedule, date);
        Assert.assertEquals((long)1L, (long)events2.size());
        PropertySet set2 = (PropertySet)events2.getEvents().get(0);
        Assert.assertEquals((Object)reason.getCode(), (Object)set2.getString("act.reason"));
        Assert.assertEquals((Object)name, (Object)set2.getString("act.reasonName"));
        Assert.assertNotEquals((long)events1.getModHash(), (long)events2.getModHash());
    }

    @Test
    public void testRemoveReason() {
        Date date = TestHelper.getDate("2008-01-01");
        Party patient = TestHelper.createPatient();
        AppointmentService service = this.initScheduleService(30);
        Act appointment = this.createAppointment(date, this.schedule, patient, false);
        String code = "XREASON" + System.currentTimeMillis();
        String name = "Reason to remove";
        Lookup reason = TestHelper.getLookup(ScheduleArchetypes.VISIT_REASON, code, name, false);
        this.save((IMObject)reason);
        appointment.setReason(code);
        this.save((IMObject)appointment);
        ScheduleEvents events1 = service.getScheduleEvents(this.schedule, date);
        Assert.assertEquals((long)1L, (long)events1.size());
        PropertySet set1 = (PropertySet)events1.getEvents().get(0);
        Assert.assertEquals((Object)code, (Object)set1.getString("act.reason"));
        Assert.assertEquals((Object)name, (Object)set1.getString("act.reasonName"));
        this.remove((IMObject)appointment);
        this.remove((IMObject)reason);
        appointment = this.createAppointment(date, this.schedule, patient, false);
        appointment.setReason(code);
        this.save((IMObject)appointment);
        ScheduleEvents events2 = service.getScheduleEvents(this.schedule, date);
        Assert.assertEquals((long)1L, (long)events2.size());
        PropertySet set2 = (PropertySet)events2.getEvents().get(0);
        Assert.assertEquals((Object)code, (Object)set2.getString("act.reason"));
        Assert.assertNull((Object)set2.getString("act.reasonName"));
        Assert.assertNotEquals((long)events1.getModHash(), (long)events2.getModHash());
    }

    @Test
    public void testMultipleDayAppointment() {
        Date start = TestHelper.getDate("2008-01-01");
        Date end = TestHelper.getDate("2008-01-05");
        Party patient = TestHelper.createPatient();
        AppointmentService service = this.initScheduleService(30);
        ScheduleEvents events1 = service.getScheduleEvents(this.schedule, start, end);
        Assert.assertEquals((long)0L, (long)events1.size());
        Date startTime = DateRules.getDate((Date)start, (int)15, (DateUnits)DateUnits.MINUTES);
        Date endTime = DateRules.getDate((Date)end, (int)15, (DateUnits)DateUnits.MINUTES);
        Act appointment = this.createAppointment(startTime, endTime, this.schedule, patient, true);
        this.checkAppointment(appointment, 5);
        startTime = DateRules.getDate((Date)startTime, (int)2, (DateUnits)DateUnits.DAYS);
        appointment.setActivityStartTime(startTime);
        this.save((IMObject)appointment);
        ScheduleEvents events2 = service.getScheduleEvents(this.schedule, start, DateRules.getNextDate((Date)start));
        Assert.assertEquals((long)0L, (long)events2.size());
        Assert.assertNotEquals((long)events1.getModHash(), (long)events2.getModHash());
        Assert.assertEquals((long)events2.getModHash(), (long)service.getModHash(this.schedule, start, DateRules.getNextDate((Date)start)));
        this.checkAppointment(appointment, 3);
        Date newEndTime = DateRules.getDate((Date)endTime, (int)-1, (DateUnits)DateUnits.DAYS);
        appointment.setActivityEndTime(newEndTime);
        this.save((IMObject)appointment);
        this.checkAppointment(appointment, 2);
        ScheduleEvents events3 = service.getScheduleEvents(this.schedule, endTime);
        Assert.assertEquals((long)0L, (long)events3.size());
    }

    @Test
    public void testRepeatedSequentialRead() {
        Date start = TestHelper.getDate("2008-01-01");
        Party patient = TestHelper.createPatient();
        Set[] days = new Set[10];
        for (int i = 0; i < 10; ++i) {
            HashSet<Long> appointments = new HashSet<Long>();
            Date date = DateRules.getDate((Date)start, (int)i, (DateUnits)DateUnits.DAYS);
            for (int j = 0; j < 100; ++j) {
                Act appointment = this.createAppointment(date, this.schedule, patient, true);
                appointments.add(appointment.getId());
            }
            days[i] = appointments;
        }
        AppointmentService service = this.initScheduleService(6);
        for (int j = 0; j < 10; ++j) {
            for (int k = 0; k < 10; ++k) {
                Date date = DateRules.getDate((Date)start, (int)k, (DateUnits)DateUnits.DAYS);
                Set<Long> ids = this.getIds(date, this.schedule, (ScheduleService)service);
                Assert.assertEquals((Object)days[k], ids);
            }
        }
    }

    @Test
    public void testGetOverlappingEvent() {
        AppointmentService service = this.initScheduleService(1);
        Date start = TestHelper.getDatetime("2015-05-14 09:00:00");
        Date end = TestHelper.getDatetime("2015-05-14 09:15:00");
        Entity appointmentType = ScheduleTestHelper.createAppointmentType();
        Party schedule1 = ScheduleTestHelper.createSchedule(15, "MINUTES", 2, appointmentType, this.location);
        Party schedule2 = ScheduleTestHelper.createSchedule(15, "MINUTES", 2, appointmentType, this.location);
        this.save((IMObject)schedule1);
        this.save((IMObject)schedule2);
        Act appointment = this.createAppointment(start, end, (Entity)schedule1, false);
        Assert.assertNull((Object)service.getOverlappingEvent(appointment));
        this.save((IMObject)appointment);
        Assert.assertNull((Object)service.getOverlappingEvent(appointment));
        Act exactOverlap = this.createAppointment(start, end, (Entity)schedule1, false);
        Times expected = Times.create((Act)appointment);
        Assert.assertEquals((Object)expected, (Object)service.getOverlappingEvent(exactOverlap));
        Act overlap = this.createAppointment(TestHelper.getDatetime("2015-05-14 09:05:00"), TestHelper.getDatetime("2015-05-14 09:10:00"), (Entity)schedule1, true);
        Assert.assertEquals((Object)expected, (Object)service.getOverlappingEvent(overlap));
        Act after = this.createAppointment(TestHelper.getDatetime("2015-05-14 09:15:00"), TestHelper.getDatetime("2015-05-14 09:30:00"), (Entity)schedule1, false);
        Assert.assertNull((Object)service.getOverlappingEvent(after));
        Act before = this.createAppointment(TestHelper.getDatetime("2015-05-14 08:45:00"), TestHelper.getDatetime("2015-05-14 09:00:00"), (Entity)schedule1, false);
        Assert.assertNull((Object)service.getOverlappingEvent(before));
        Act appointment2 = this.createAppointment(start, end, (Entity)schedule2, false);
        Assert.assertNull((Object)service.getOverlappingEvent(appointment2));
        this.save((IMObject)appointment2);
        Assert.assertNull((Object)service.getOverlappingEvent(appointment2));
        Act appointment3 = this.create("act.customerAppointment", Act.class);
        Assert.assertNull((Object)service.getOverlappingEvent(appointment3));
        appointment3.setActivityStartTime(null);
        appointment3.setActivityEndTime(null);
        Assert.assertNull((Object)service.getOverlappingEvent(appointment3));
    }

    @Test
    public void getOverlappingEventTimes() {
        AppointmentService service = this.initScheduleService(1);
        Date start1 = TestHelper.getDatetime("2015-05-14 09:00:00");
        Date end1 = TestHelper.getDatetime("2015-05-14 09:15:00");
        Date start2 = TestHelper.getDatetime("2015-05-15 09:00:00");
        Date end2 = TestHelper.getDatetime("2015-05-15 09:15:00");
        Date beforeStart = TestHelper.getDatetime("2015-05-15 08:45:00");
        Date beforeEnd = TestHelper.getDatetime("2015-05-15 09:00:00");
        Date afterStart = TestHelper.getDatetime("2015-05-15 09:30:00");
        Date afterEnd = TestHelper.getDatetime("2015-05-15 09:45:00");
        Date overlap1Start = TestHelper.getDatetime("2015-05-15 09:05:00");
        Date overlap1End = TestHelper.getDatetime("2015-05-15 09:20:00");
        Date overlap2Start = TestHelper.getDatetime("2015-05-15 09:10:00");
        Date overlap2End = TestHelper.getDatetime("2015-05-15 09:25:00");
        Times times1 = new Times(start1, end1);
        Times times2 = new Times(start2, end2);
        List<Times> list = Arrays.asList(times1, times2);
        Assert.assertNull((Object)service.getOverlappingEvent(list, this.schedule));
        Act appointment1 = this.createAppointment(start1, end1, this.schedule, true);
        Assert.assertEquals((Object)Times.create((Act)appointment1), (Object)service.getOverlappingEvent(list, this.schedule));
        this.remove((IMObject)appointment1);
        Act appointment2 = this.createAppointment(start2, end2, this.schedule, true);
        Assert.assertEquals((Object)Times.create((Act)appointment2), (Object)service.getOverlappingEvent(list, this.schedule));
        this.remove((IMObject)appointment2);
        this.createAppointment(beforeStart, beforeEnd, this.schedule, true);
        Assert.assertNull((Object)service.getOverlappingEvent(list, this.schedule));
        this.createAppointment(afterStart, afterEnd, this.schedule, true);
        Assert.assertNull((Object)service.getOverlappingEvent(list, this.schedule));
        Act appointment5 = this.createAppointment(overlap1Start, overlap1End, this.schedule, true);
        Assert.assertEquals((Object)Times.create((Act)appointment5), (Object)service.getOverlappingEvent(list, this.schedule));
        this.remove((IMObject)appointment5);
        Act appointment6 = this.createAppointment(overlap2Start, overlap2End, this.schedule, true);
        Assert.assertEquals((Object)Times.create((Act)appointment6), (Object)service.getOverlappingEvent(list, this.schedule));
    }

    @Test
    public void testGetOverlappingEvents() {
        AppointmentService service = this.initScheduleService(1);
        Date start1 = TestHelper.getDatetime("2015-05-14 09:00:00");
        Date end1 = TestHelper.getDatetime("2015-05-14 09:15:00");
        Date start2 = TestHelper.getDatetime("2015-05-15 09:00:00");
        Date end2 = TestHelper.getDatetime("2015-05-15 09:15:00");
        Date beforeStart = TestHelper.getDatetime("2015-05-15 08:45:00");
        Date beforeEnd = TestHelper.getDatetime("2015-05-15 09:00:00");
        Date afterStart = TestHelper.getDatetime("2015-05-15 09:30:00");
        Date afterEnd = TestHelper.getDatetime("2015-05-15 09:45:00");
        Date overlap1Start = TestHelper.getDatetime("2015-05-15 09:05:00");
        Date overlap1End = TestHelper.getDatetime("2015-05-15 09:20:00");
        Date overlap2Start = TestHelper.getDatetime("2015-05-15 09:10:00");
        Date overlap2End = TestHelper.getDatetime("2015-05-15 09:25:00");
        Times times1 = new Times(start1, end1);
        Times times2 = new Times(start2, end2);
        List<Times> list = Arrays.asList(times1, times2);
        Assert.assertNull((Object)service.getOverlappingEvents(list, this.schedule, 1));
        Act appointment1 = this.createAppointment(start1, end1, this.schedule, true);
        this.checkOverlappingEvents(service.getOverlappingEvents(list, this.schedule, 1), times1);
        this.remove((IMObject)appointment1);
        Act appointment2 = this.createAppointment(start2, end2, this.schedule, true);
        this.checkOverlappingEvents(service.getOverlappingEvents(list, this.schedule, 1), times2);
        this.remove((IMObject)appointment2);
        this.createAppointment(beforeStart, beforeEnd, this.schedule, true);
        Assert.assertNull((Object)service.getOverlappingEvents(list, this.schedule, 1));
        this.createAppointment(afterStart, afterEnd, this.schedule, true);
        Assert.assertNull((Object)service.getOverlappingEvents(list, this.schedule, 1));
        Act appointment5 = this.createAppointment(overlap1Start, overlap1End, this.schedule, true);
        this.checkOverlappingEvents(service.getOverlappingEvents(list, this.schedule, 1), Times.create((Act)appointment5));
        this.remove((IMObject)appointment5);
        Act appointment6 = this.createAppointment(overlap2Start, overlap2End, this.schedule, true);
        this.checkOverlappingEvents(service.getOverlappingEvents(list, this.schedule, 1), Times.create((Act)appointment6));
    }

    @Test
    public void testAddCalendarBlock() throws Exception {
        Date date1 = TestHelper.getDate("2008-01-01");
        Date date2 = TestHelper.getDate("2008-01-02");
        Date date3 = TestHelper.getDate("2008-01-03");
        AppointmentService service = this.initScheduleService(30);
        long hash1 = this.checkEvents(this.schedule, date1, 0);
        this.checkEvents(this.schedule, date2, 0);
        Act block = this.createCalendarBlock(date1);
        ScheduleEvents events3 = service.getScheduleEvents(this.schedule, date1);
        Assert.assertEquals((long)1L, (long)events3.size());
        PropertySet set = (PropertySet)events3.getEvents().get(0);
        this.checkCalendarBlock(block, set);
        Assert.assertNotEquals((long)hash1, (long)events3.getModHash());
        this.checkEvents(this.schedule, date2, 0);
        this.checkEvents(this.schedule, date3, 0);
        this.destroyService((ScheduleService)service);
        service = this.initScheduleService(30);
        ScheduleEvents events4 = service.getScheduleEvents(this.schedule, date1);
        Assert.assertEquals((long)1L, (long)events4.size());
        this.checkCalendarBlock(block, (PropertySet)events4.getEvents().get(0));
    }

    @Test
    public void testAddAppointmentPriorToCacheLoad() throws Exception {
        Date date = new Date();
        final Semaphore load = new Semaphore(0);
        final AtomicBoolean addEventCacheNonEmpty = new AtomicBoolean();
        final AtomicBoolean preLoadCacheNonEmpty = new AtomicBoolean();
        AppointmentService service = new AppointmentService(this.getArchetypeService(), this.getLookupService(), (EhcacheManager)new BasicEhcacheManager(30L)){

            protected void addEvent(Act event) {
                super.addEvent(event);
                addEventCacheNonEmpty.set(this.getCache().iterator().hasNext());
                load.release();
            }

            ScheduleEventCache createScheduleEventCache(EhcacheManager cacheManager, String cacheName, ScheduleEventFactory factory) {
                return new ScheduleEventCache(cacheManager, cacheName, factory){

                    protected DayCache load(Reference reference, Entity entity, Date from, Date to) {
                        preLoadCacheNonEmpty.set(this.getCache().iterator().hasNext());
                        load.acquireUninterruptibly();
                        return super.load(reference, entity, from, to);
                    }
                };
            }
        };
        this.setScheduleService((ScheduleService)service);
        Act[] actHandle = new Act[1];
        ScheduleEvents[] eventHandle = new ScheduleEvents[1];
        Runnable add = () -> {
            actHandle[0] = this.createAppointment(date);
        };
        Runnable retrieve = () -> {
            eventHandle[0] = service.getScheduleEvents(this.schedule, date);
        };
        this.runConcurrent(add, retrieve);
        Assert.assertFalse((boolean)addEventCacheNonEmpty.get());
        Assert.assertFalse((boolean)preLoadCacheNonEmpty.get());
        Assert.assertTrue((boolean)service.getCache().iterator().hasNext());
        this.checkEvents(eventHandle[0], actHandle);
    }

    @Test
    public void testAddAppointmentAfterCacheCreation() throws Exception {
        Date date = new Date();
        final Semaphore cacheCreation = new Semaphore(0);
        final Semaphore eventAdd = new Semaphore(0);
        final AtomicInteger postAddSize = new AtomicInteger();
        AppointmentService service = new AppointmentService(this.getArchetypeService(), this.getLookupService(), (EhcacheManager)new BasicEhcacheManager(30L)){

            protected void addEvent(Act event) {
                cacheCreation.acquireUninterruptibly();
                super.addEvent(event);
                eventAdd.release();
            }

            ScheduleEventCache createScheduleEventCache(EhcacheManager cacheManager, String cacheName, ScheduleEventFactory factory) {
                return new ScheduleEventCache(cacheManager, cacheName, factory){

                    protected DayCache getDayCache(Reference reference, Date from, Date to) {
                        DayCache cache = super.getDayCache(reference, from, to);
                        cacheCreation.release();
                        eventAdd.acquireUninterruptibly();
                        postAddSize.set(cache.getEvents().size());
                        return cache;
                    }
                };
            }
        };
        this.setScheduleService((ScheduleService)service);
        Act[] actHandle = new Act[1];
        Runnable add = () -> {
            actHandle[0] = this.createAppointment(date);
        };
        Runnable retrieve = () -> service.getEvents(this.schedule, date);
        this.runConcurrent(add, retrieve);
        Assert.assertEquals((long)0L, (long)postAddSize.get());
        ScheduleEvents events = service.getScheduleEvents(this.schedule, date);
        this.checkEvents(events, actHandle);
    }

    @Test
    public void testSaveAppointmentAfterCacheCreation() throws Exception {
        Date date = new Date();
        final Semaphore cacheCreation = new Semaphore(0);
        final Semaphore eventSave = new Semaphore(0);
        AppointmentService service = new AppointmentService(this.getArchetypeService(), this.getLookupService(), (EhcacheManager)new BasicEhcacheManager(30L)){

            ScheduleEventCache createScheduleEventCache(EhcacheManager cacheManager, String cacheName, ScheduleEventFactory factory) {
                return new ScheduleEventCache(cacheManager, cacheName, factory){

                    protected DayCache getDayCache(Reference reference, Date from, Date to) {
                        DayCache cache = super.getDayCache(reference, from, to);
                        cacheCreation.release();
                        eventSave.acquireUninterruptibly();
                        return cache;
                    }
                };
            }
        };
        this.setScheduleService((ScheduleService)service);
        Act[] actHandle = new Act[1];
        Runnable add = () -> {
            cacheCreation.acquireUninterruptibly();
            actHandle[0] = this.createAppointment(date);
            eventSave.release();
        };
        Runnable retrieve = () -> service.getScheduleEvents(this.schedule, date);
        this.runConcurrent(add, retrieve);
        ScheduleEvents events = service.getScheduleEvents(this.schedule, date);
        this.checkEvents(events, actHandle);
    }

    @Test
    public void testSaveAppointmentAfterCacheLoad() throws Exception {
        Date date = new Date();
        final Semaphore load = new Semaphore(0);
        AppointmentService service = new AppointmentService(this.getArchetypeService(), this.getLookupService(), (EhcacheManager)new BasicEhcacheManager(30L)){

            ScheduleEventCache createScheduleEventCache(EhcacheManager cacheManager, String cacheName, ScheduleEventFactory factory) {
                return new ScheduleEventCache(cacheManager, cacheName, factory){

                    protected DayCache load(Reference reference, Entity entity, Date from, Date to) {
                        DayCache cache = super.load(reference, entity, from, to);
                        load.release();
                        return cache;
                    }
                };
            }
        };
        this.setScheduleService((ScheduleService)service);
        Act[] actHandle = new Act[1];
        Runnable add = () -> {
            load.acquireUninterruptibly();
            actHandle[0] = this.createAppointment(date);
        };
        Runnable retrieve = () -> service.getScheduleEvents(this.schedule, date);
        this.runConcurrent(add, retrieve);
        ScheduleEvents events = service.getScheduleEvents(this.schedule, date);
        this.checkEvents(events, actHandle);
    }

    @Test
    public void testMoveAppointmentToUncachedDay() {
        Date date1 = DateRules.getToday();
        Date date2 = DateRules.getNextDate((Date)date1);
        AppointmentService service = this.initScheduleService(10);
        Act appointment = this.createAppointment(date1);
        ScheduleEvents events1A = service.getScheduleEvents(this.schedule, date1);
        this.checkEvents(events1A, appointment);
        appointment.setActivityStartTime(date2);
        appointment.setActivityEndTime(DateRules.getDate((Date)date2, (int)15, (DateUnits)DateUnits.MINUTES));
        this.save((IMObject)appointment);
        ScheduleEvents events1B = service.getScheduleEvents(this.schedule, date1);
        this.checkEvents(events1B, new Act[0]);
        ScheduleEvents events2 = service.getScheduleEvents(this.schedule, date2);
        this.checkEvents(events2, appointment);
    }

    @Test
    public void testMoveAppointmentToUncachedDayDuringCacheLoad() throws Exception {
        Date date1 = DateRules.getToday();
        Date date2 = DateRules.getNextDate((Date)date1);
        Act appointment = this.createAppointment(date1);
        final AtomicInteger addEventCount = new AtomicInteger();
        final AtomicInteger loadCount = new AtomicInteger();
        final Semaphore move = new Semaphore(1);
        final Semaphore load = new Semaphore(0);
        AppointmentService service = new AppointmentService(this.getArchetypeService(), this.getLookupService(), (EhcacheManager)new BasicEhcacheManager(30L)){

            protected void addEvent(Act event) {
                addEventCount.incrementAndGet();
                move.release();
                load.acquireUninterruptibly(2);
                super.addEvent(event);
            }

            ScheduleEventCache createScheduleEventCache(EhcacheManager cacheManager, String cacheName, ScheduleEventFactory factory) {
                return new ScheduleEventCache(cacheManager, cacheName, factory){

                    protected DayCache load(Reference reference, Entity entity, Date from, Date to) {
                        loadCount.incrementAndGet();
                        move.acquireUninterruptibly();
                        DayCache cache = super.load(reference, entity, from, to);
                        load.release();
                        return cache;
                    }
                };
            }
        };
        this.setScheduleService((ScheduleService)service);
        ScheduleEvents events1 = service.getScheduleEvents(this.schedule, date1);
        this.checkEvents(events1, appointment);
        appointment.setActivityStartTime(date2);
        appointment.setActivityEndTime(DateRules.getDate((Date)date2, (int)15, (DateUnits)DateUnits.MINUTES));
        Runnable moveAppointment = () -> this.save((IMObject)appointment);
        Runnable retrieve = () -> service.getScheduleEvents(this.schedule, date2);
        this.runConcurrent(moveAppointment, retrieve);
        ScheduleEvents events2 = service.getScheduleEvents(this.schedule, date2);
        this.checkEvents(events2, appointment);
        ScheduleEvents events3 = service.getScheduleEvents(this.schedule, date1);
        this.checkEvents(events3, new Act[0]);
        Assert.assertEquals((long)1L, (long)addEventCount.get());
        Assert.assertEquals((long)2L, (long)loadCount.get());
    }

    @Test
    public void testMoveAppointmentToUncachedScheduleDuringCacheLoad() throws Exception {
        Date date = DateRules.getToday();
        Act appointment = this.createAppointment(date);
        final AtomicInteger addEventCount = new AtomicInteger();
        final AtomicInteger loadCount = new AtomicInteger();
        final Semaphore move = new Semaphore(1);
        final Semaphore load = new Semaphore(0);
        AppointmentService service = new AppointmentService(this.getArchetypeService(), this.getLookupService(), (EhcacheManager)new BasicEhcacheManager(30L)){

            protected void addEvent(Act event) {
                addEventCount.incrementAndGet();
                move.release();
                load.acquireUninterruptibly(2);
                super.addEvent(event);
            }

            ScheduleEventCache createScheduleEventCache(EhcacheManager cacheManager, String cacheName, ScheduleEventFactory factory) {
                return new ScheduleEventCache(cacheManager, cacheName, factory){

                    protected DayCache load(Reference reference, Entity entity, Date from, Date to) {
                        loadCount.incrementAndGet();
                        move.acquireUninterruptibly();
                        DayCache cache = super.load(reference, entity, from, to);
                        load.release();
                        return cache;
                    }
                };
            }
        };
        this.setScheduleService((ScheduleService)service);
        ScheduleEvents events1 = service.getScheduleEvents(this.schedule, date);
        this.checkEvents(events1, appointment);
        Party schedule2 = ScheduleTestHelper.createSchedule(this.location);
        IMObjectBean bean = this.getBean((IMObject)appointment);
        bean.setTarget("schedule", (IMObject)schedule2);
        Runnable moveAppointment = () -> this.save((IMObject)appointment);
        Runnable retrieve = () -> AppointmentServiceTestCase.lambda$testMoveAppointmentToUncachedScheduleDuringCacheLoad$11(service, (Entity)schedule2, date);
        this.runConcurrent(moveAppointment, retrieve);
        ScheduleEvents events2 = service.getScheduleEvents((Entity)schedule2, date);
        this.checkEvents(events2, appointment);
        ScheduleEvents events3 = service.getScheduleEvents(this.schedule, date);
        this.checkEvents(events3, new Act[0]);
        Assert.assertEquals((long)1L, (long)addEventCount.get());
        Assert.assertEquals((long)2L, (long)loadCount.get());
    }

    @Test
    public void testGetAppointmentsForClinician() {
        User clinician1 = this.userFactory.createClinician();
        User clinician2 = this.userFactory.createClinician();
        Date yesterday = DateRules.getYesterday();
        Date today = DateRules.getToday();
        Date tomorrow = DateRules.getTomorrow();
        Act act1 = this.createAppointment(today, clinician1, "PENDING");
        Act act2 = this.createAppointment(today, clinician1, "CONFIRMED");
        Act act3 = this.createAppointment(today, clinician1, "CHECKED_IN");
        Act act4 = this.createAppointment(today, clinician1, "IN_PROGRESS");
        Act act5 = this.createAppointment(today, clinician1, "BILLED");
        Act act6 = this.createAppointment(today, clinician1, "ADMITTED");
        Act act7 = this.createAppointment(today, clinician1, "COMPLETED");
        this.createAppointment(today, clinician1, "CANCELLED");
        this.createAppointment(today, clinician1, "NO_SHOW");
        AppointmentService service = this.initScheduleService(30);
        Assert.assertEquals((long)0L, (long)service.getAppointmentsForClinician(clinician1, yesterday, today).size());
        List appointments1 = service.getAppointmentsForClinician(clinician1, today, tomorrow);
        Assert.assertEquals((long)7L, (long)appointments1.size());
        this.checkScheduleTimes((ScheduleTimes)appointments1.get(0), act1);
        this.checkScheduleTimes((ScheduleTimes)appointments1.get(1), act2);
        this.checkScheduleTimes((ScheduleTimes)appointments1.get(2), act3);
        this.checkScheduleTimes((ScheduleTimes)appointments1.get(3), act4);
        this.checkScheduleTimes((ScheduleTimes)appointments1.get(4), act5);
        this.checkScheduleTimes((ScheduleTimes)appointments1.get(5), act6);
        this.checkScheduleTimes((ScheduleTimes)appointments1.get(6), act7);
        Assert.assertEquals((long)0L, (long)service.getAppointmentsForClinician(clinician2, today, tomorrow).size());
        List appointments2 = service.getAppointmentsForClinician(clinician1, today, tomorrow, act1);
        Assert.assertEquals((long)6L, (long)appointments2.size());
        this.checkScheduleTimes((ScheduleTimes)appointments2.get(0), act2);
        this.checkScheduleTimes((ScheduleTimes)appointments2.get(1), act3);
        this.checkScheduleTimes((ScheduleTimes)appointments2.get(2), act4);
        this.checkScheduleTimes((ScheduleTimes)appointments2.get(3), act5);
        this.checkScheduleTimes((ScheduleTimes)appointments2.get(4), act6);
        this.checkScheduleTimes((ScheduleTimes)appointments2.get(5), act7);
    }

    protected AppointmentService createScheduleService(int scheduleCacheSize) {
        return new AppointmentService(this.getArchetypeService(), this.getLookupService(), (EhcacheManager)new BasicEhcacheManager((long)scheduleCacheSize));
    }

    @Override
    protected Entity createSchedule() {
        return ScheduleTestHelper.createSchedule(this.location);
    }

    @Override
    protected Act createEvent(Entity schedule, Date date, Party patient) {
        return this.createAppointment(date, schedule, patient, true);
    }

    protected AppointmentService initScheduleService(int scheduleCacheSize) {
        return (AppointmentService)super.initScheduleService(scheduleCacheSize);
    }

    private void checkScheduleTimes(ScheduleTimes times, Act expected) {
        Assert.assertEquals((Object)expected.getObjectReference(), (Object)times.getReference());
        Assert.assertEquals((Object)expected.getActivityStartTime(), (Object)times.getStartTime());
        Assert.assertEquals((Object)expected.getActivityEndTime(), (Object)times.getEndTime());
        Assert.assertEquals((Object)this.schedule.getObjectReference(), (Object)times.getSchedule());
    }

    private void checkEvents(ScheduleEvents events, Act ... appointments) {
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)events.size(), (long)appointments.length);
        for (Act appointment : appointments) {
            Assert.assertNotNull((Object)appointment);
            Reference reference = appointment.getObjectReference();
            boolean found = false;
            for (PropertySet event : events.getEvents()) {
                if (!reference.equals((Object)event.getReference("act.objectReference"))) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
        }
    }

    private void checkOverlappingEvents(List<Times> events, Times ... times) {
        Assert.assertEquals((long)times.length, (long)events.size());
        for (int i = 0; i < times.length; ++i) {
            Times expected = times[i];
            Times actual = events.get(i);
            Assert.assertEquals((Object)expected.getStartTime(), (Object)actual.getStartTime());
            Assert.assertEquals((Object)expected.getEndTime(), (Object)actual.getEndTime());
        }
    }

    private void checkAppointment(Act act, int expectedDays) {
        Date start = DateRules.getDate((Date)act.getActivityStartTime());
        Date end = DateRules.getDate((Date)act.getActivityEndTime());
        Date date = start;
        int count = 0;
        while (date.compareTo(end) <= 0) {
            List results = this.getScheduleService().getEvents(this.schedule, date);
            Assert.assertEquals((long)1L, (long)results.size());
            PropertySet set = (PropertySet)results.get(0);
            this.checkAppointment(act, set);
            ++count;
            date = DateRules.getDate((Date)date, (int)1, (DateUnits)DateUnits.DAYS);
        }
        Assert.assertEquals((long)expectedDays, (long)count);
    }

    private void checkAppointment(Act act, PropertySet set) {
        IMObjectBean bean = this.getBean((IMObject)act);
        Assert.assertEquals((Object)act.getObjectReference(), (Object)set.get("act.objectReference"));
        Assert.assertEquals((Object)act.getActivityStartTime(), (Object)set.get("act.startTime"));
        Assert.assertEquals((Object)act.getActivityEndTime(), (Object)set.get("act.endTime"));
        Assert.assertEquals((Object)act.getStatus(), (Object)set.get("act.status"));
        Assert.assertEquals((Object)TestHelper.getLookupName((IMObject)act, "status"), (Object)set.get("act.statusName"));
        Assert.assertEquals((Object)act.getReason(), (Object)set.get("act.reason"));
        Assert.assertEquals((Object)TestHelper.getLookupName((IMObject)act, "reason"), (Object)set.get("act.reasonName"));
        Assert.assertEquals((Object)bean.getString("notes"), (Object)set.get("notes"));
        Assert.assertEquals((Object)bean.getTargetRef("customer"), (Object)set.get("customer.objectReference"));
        Assert.assertEquals((Object)bean.getTarget("customer").getName(), (Object)set.get("customer.name"));
        Assert.assertEquals((Object)bean.getTargetRef("patient"), (Object)set.get("patient.objectReference"));
        Assert.assertEquals((Object)bean.getTarget("patient").getName(), (Object)set.get("patient.name"));
        Assert.assertEquals((Object)bean.getTargetRef("clinician"), (Object)set.get("clinician.objectReference"));
        Assert.assertEquals((Object)bean.getTarget("clinician").getName(), (Object)set.get("clinician.name"));
        Assert.assertEquals((Object)bean.getTargetRef("appointmentType"), (Object)set.get("scheduleType.objectReference"));
        Assert.assertEquals((Object)bean.getTargetRef("schedule"), (Object)set.get("schedule.objectReference"));
        Assert.assertEquals((Object)bean.getTarget("schedule").getName(), (Object)set.get("schedule.name"));
        Assert.assertEquals((Object)bean.getTarget("appointmentType").getName(), (Object)set.get("scheduleType.name"));
        Assert.assertEquals((Object)bean.getDate("confirmedTime"), (Object)set.get("confirmedTime"));
        Assert.assertEquals((Object)bean.getDate("arrivalTime"), (Object)set.get("arrivalTime"));
    }

    private Act createAppointment(Date date) {
        Party patient = TestHelper.createPatient();
        return this.createAppointment(date, this.schedule, patient, true);
    }

    private Act createAppointment(Date date, User clinician, String status) {
        Party patient = TestHelper.createPatient();
        return (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)this.newAppointment(date, this.schedule, patient).clinician(clinician)).status(status)).build();
    }

    private Act createAppointment(Date date, Entity schedule, Party patient, boolean save) {
        return (Act)((TestAppointmentBuilder)this.newAppointment(date, schedule, patient).clinician(this.userFactory.createClinician())).build(save);
    }

    private TestAppointmentBuilder newAppointment(Date date, Entity schedule, Party patient) {
        Date startTime = DateRules.getDate((Date)date, (int)15, (DateUnits)DateUnits.MINUTES);
        Date endTime = DateRules.getDate((Date)startTime, (int)15, (DateUnits)DateUnits.MINUTES);
        return this.newAppointment(startTime, endTime, schedule, patient);
    }

    private Act createAppointment(Date startTime, Date endTime, Entity schedule, boolean save) {
        return this.createAppointment(startTime, endTime, schedule, null, save);
    }

    private Act createAppointment(Date startTime, Date endTime, Entity schedule, Party patient, boolean save) {
        return (Act)((TestAppointmentBuilder)this.newAppointment(startTime, endTime, schedule, patient).clinician(this.userFactory.createClinician())).build(save);
    }

    private TestAppointmentBuilder newAppointment(Date startTime, Date endTime, Entity schedule, Party patient) {
        Party customer = this.customerFactory.createCustomer();
        Entity appointmentType = this.schedulingFactory.createAppointmentType();
        return this.newAppointment(startTime, endTime, schedule, patient, customer, appointmentType);
    }

    private TestAppointmentBuilder newAppointment(Date startTime, Date endTime, Entity schedule, Party patient, Party customer, Entity appointmentType) {
        return (TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(startTime)).endTime(endTime)).schedule(schedule).appointmentType(appointmentType).customer(customer)).patient(patient)).notes("some notes");
    }

    private void checkCalendarBlock(Act act, PropertySet set) {
        IMObjectBean bean = this.getBean((IMObject)act);
        Assert.assertEquals((Object)act.getObjectReference(), (Object)set.get("act.objectReference"));
        Assert.assertEquals((Object)act.getActivityStartTime(), (Object)set.get("act.startTime"));
        Assert.assertEquals((Object)act.getActivityEndTime(), (Object)set.get("act.endTime"));
        Assert.assertEquals((Object)act.getStatus(), (Object)set.get("act.status"));
        Assert.assertEquals((Object)bean.getString("notes"), (Object)set.get("notes"));
        Assert.assertEquals((Object)bean.getTargetRef("schedule"), (Object)set.get("schedule.objectReference"));
        Assert.assertEquals((Object)bean.getTarget("schedule").getName(), (Object)set.get("schedule.name"));
        Assert.assertEquals((Object)bean.getTargetRef("type"), (Object)set.get("scheduleType.objectReference"));
        Assert.assertEquals((Object)bean.getTarget("type").getName(), (Object)set.get("scheduleType.name"));
    }

    private Act createCalendarBlock(Date date) {
        Date startTime = DateRules.getDate((Date)date, (int)15, (DateUnits)DateUnits.MINUTES);
        Date endTime = DateRules.getDate((Date)startTime, (int)15, (DateUnits)DateUnits.MINUTES);
        Act block = ScheduleTestHelper.createCalendarBlock(startTime, endTime, this.schedule, ScheduleTestHelper.createCalendarBlockType());
        IMObjectBean bean = this.getBean((IMObject)block);
        bean.setValue("notes", (Object)"block notes");
        this.save((IMObject)block);
        return block;
    }

    private static /* synthetic */ void lambda$testMoveAppointmentToUncachedScheduleDuringCacheLoad$11(AppointmentService service, Entity schedule2, Date date) {
        service.getScheduleEvents(schedule2, date);
    }
}

