/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.supplier;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;

public class SupplierTestHelper {
    protected static final String PACKAGE_UNITS = "BOX";

    public static Party createStockLocation() {
        Party stockLocation = TestHelper.create("party.organisationStockLocation", Party.class);
        stockLocation.setName("STOCK-LOCATION-" + stockLocation.hashCode());
        TestHelper.save((IMObject)stockLocation);
        return stockLocation;
    }

    public static List<FinancialAct> createOrder(BigDecimal amount, Party supplier, Party stockLocation, Product product) {
        FinancialAct item = SupplierTestHelper.createOrderItem(product, BigDecimal.ONE, 1, PACKAGE_UNITS, amount, amount);
        return SupplierTestHelper.createOrder(supplier, stockLocation, item);
    }

    public static List<FinancialAct> createOrder(Party supplier, Party stockLocation, FinancialAct ... items) {
        ArrayList<FinancialAct> result = new ArrayList<FinancialAct>();
        FinancialAct act = TestHelper.create("act.supplierOrder", FinancialAct.class);
        act.setStatus("POSTED");
        result.add(act);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        bean.setTarget("supplier", (IMObject)supplier);
        bean.setTarget("stockLocation", (IMObject)stockLocation);
        BigDecimal total = BigDecimal.ZERO;
        for (FinancialAct item : items) {
            ActRelationship relationship = (ActRelationship)bean.addTarget("items", (IMObject)item);
            item.addActRelationship(relationship);
            total = total.add(item.getTotal());
            result.add(item);
        }
        bean.setValue("amount", (Object)total);
        return result;
    }

    public static FinancialAct createOrderItem(Product product, BigDecimal quantity, int packageSize, String packageUnits, BigDecimal unitPrice, BigDecimal listPrice) {
        FinancialAct item = TestHelper.create("act.supplierOrderItem", FinancialAct.class);
        IMObjectBean bean = new IMObjectBean((IMObject)item);
        bean.setTarget("product", (IMObject)product);
        item.setQuantity(quantity);
        bean.setValue("packageSize", (Object)packageSize);
        bean.setValue("packageUnits", (Object)packageUnits);
        bean.setValue("unitPrice", (Object)unitPrice);
        bean.setValue("listPrice", (Object)listPrice);
        ArchetypeServiceHelper.getArchetypeService().deriveValues((IMObject)item);
        return item;
    }
}

