/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.supplier;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.tax.TaxRules;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.supplier.AbstractSupplierTest;
import org.openvpms.archetype.rules.supplier.DeliveryStatus;
import org.openvpms.archetype.rules.supplier.OrderRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class OrderRulesTestCase
extends AbstractSupplierTest {
    private OrderRules rules;

    @Test
    public void testGetDeliveryStatus() {
        BigDecimal two = new BigDecimal("2.0");
        BigDecimal three = new BigDecimal("3.0");
        FinancialAct act = this.create("act.supplierOrderItem", FinancialAct.class);
        Assert.assertEquals((Object)DeliveryStatus.PENDING, (Object)this.rules.getDeliveryStatus(act));
        this.checkDeliveryStatus(act, three, BigDecimal.ZERO, BigDecimal.ZERO, DeliveryStatus.PENDING);
        this.checkDeliveryStatus(act, three, three, BigDecimal.ZERO, DeliveryStatus.FULL);
        this.checkDeliveryStatus(act, three, two, BigDecimal.ZERO, DeliveryStatus.PART);
        this.checkDeliveryStatus(act, three, two, BigDecimal.ONE, DeliveryStatus.FULL);
        this.checkDeliveryStatus(act, three, BigDecimal.ZERO, three, DeliveryStatus.FULL);
    }

    @Test
    public void testCopyOrder() {
        BigDecimal quantity = new BigDecimal(50);
        int packageSize = 10;
        FinancialAct orderItem = (FinancialAct)this.newOrderItem(this.getProduct(), quantity, packageSize, BigDecimal.ONE).receivedQuantity(25).cancelledQuantity(10).build();
        FinancialAct order = this.createOrder(this.getSupplier(), orderItem);
        order.setStatus("POSTED");
        order.setStatus2(DeliveryStatus.PART.toString());
        this.save((IMObject)order);
        FinancialAct copy = this.rules.copyOrder(order, "Copy");
        Assert.assertTrue((boolean)copy.isA("act.supplierOrder"));
        Assert.assertFalse((boolean)copy.isCredit());
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)copy.getStatus());
        Assert.assertNotEquals((Object)copy, (Object)order);
        IMObjectBean bean = this.getBean((IMObject)copy);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)1L, (long)items.size());
        FinancialAct copyItem = (FinancialAct)items.get(0);
        Assert.assertTrue((boolean)copyItem.isA("act.supplierOrderItem"));
        Assert.assertFalse((boolean)copyItem.isCredit());
        Assert.assertNotEquals((Object)copyItem, (Object)orderItem);
        this.checkEquals(quantity, copyItem.getQuantity());
        IMObjectBean copyBean = this.getBean((IMObject)copyItem);
        Assert.assertEquals((long)0L, (long)copyBean.getInt("receivedQuantity"));
        Assert.assertEquals((long)0L, (long)copyBean.getInt("cancelledQuantity"));
        Assert.assertEquals((Object)DeliveryStatus.PENDING.toString(), (Object)copy.getStatus2());
        Assert.assertEquals((Object)"Copy", (Object)copy.getTitle());
    }

    @Test
    public void testCreateDeliveryItem() {
        BigDecimal quantity = new BigDecimal(50);
        BigDecimal received = new BigDecimal(40);
        BigDecimal cancelled = new BigDecimal(4);
        BigDecimal expectedQuantity = new BigDecimal(6);
        int packageSize = 10;
        FinancialAct orderItem = (FinancialAct)this.newOrderItem(this.getProduct(), quantity, packageSize, BigDecimal.ONE).receivedQuantity(received).cancelledQuantity(cancelled).build();
        FinancialAct order = this.createOrder(this.getSupplier(), orderItem);
        order.setStatus("POSTED");
        this.save((IMObject)order);
        FinancialAct item = this.rules.createDeliveryItem(orderItem);
        Assert.assertTrue((boolean)item.isA("act.supplierDeliveryItem"));
        Assert.assertFalse((boolean)item.isCredit());
        this.checkEquals(expectedQuantity, item.getQuantity());
        Assert.assertTrue((boolean)item.getSourceActRelationships().isEmpty());
    }

    @Test
    public void testCreateReturnItem() {
        BigDecimal quantity = new BigDecimal(50);
        BigDecimal received = new BigDecimal(40);
        BigDecimal cancelled = new BigDecimal(4);
        int packageSize = 10;
        FinancialAct orderItem = (FinancialAct)this.newOrderItem(this.getProduct(), quantity, packageSize, BigDecimal.ONE).receivedQuantity(received).cancelledQuantity(cancelled).build();
        Assert.assertFalse((boolean)orderItem.isCredit());
        FinancialAct order = this.createOrder(this.getSupplier(), orderItem);
        order.setStatus("POSTED");
        this.save((IMObject)order);
        FinancialAct item = this.rules.createReturnItem(orderItem);
        Assert.assertTrue((boolean)item.isA("act.supplierReturnItem"));
        Assert.assertTrue((boolean)item.isCredit());
        this.checkEquals(received, item.getQuantity());
        Assert.assertTrue((boolean)item.getSourceActRelationships().isEmpty());
    }

    @Test
    public void testInvoiceSupplier() {
        BigDecimal quantity = new BigDecimal(50);
        int packageSize = 10;
        BigDecimal unitPrice = BigDecimal.ONE;
        BigDecimal total = quantity.multiply(unitPrice);
        Product product = this.getProduct();
        FinancialAct orderItem = this.createOrderItem(product, quantity, packageSize, unitPrice);
        FinancialAct delivery = this.createDelivery(this.getSupplier(), product, quantity, packageSize, unitPrice, orderItem);
        delivery.setStatus("POSTED");
        this.save((IMObject)delivery);
        FinancialAct invoice = this.rules.invoiceSupplier((Act)delivery);
        Assert.assertTrue((boolean)invoice.isA("act.supplierAccountChargesInvoice"));
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)invoice.getStatus());
        Assert.assertFalse((boolean)invoice.isCredit());
        IMObjectBean bean = this.getBean((IMObject)invoice);
        Assert.assertEquals((long)1L, (long)invoice.getSourceActRelationships().size());
        FinancialAct item = (FinancialAct)bean.getTarget("items", FinancialAct.class);
        Assert.assertTrue((boolean)item.isA("act.supplierAccountInvoiceItem"));
        this.checkEquals(total, item.getTotal());
        IMObjectBean deliveryBean = this.getBean((IMObject)delivery);
        List invoices = deliveryBean.getTargets("invoice", Act.class);
        Assert.assertEquals((long)1L, (long)invoices.size());
        Assert.assertEquals((Object)invoice, invoices.get(0));
        try {
            this.rules.invoiceSupplier((Act)delivery);
            Assert.fail((String)"Expected invoicing to fail");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testCreditSupplier() {
        BigDecimal quantity = new BigDecimal(50);
        int packageSize = 10;
        BigDecimal unitPrice = BigDecimal.ONE;
        Product product = this.getProduct();
        FinancialAct orderItem = this.createOrderItem(product, quantity, packageSize, unitPrice);
        FinancialAct orderReturn = this.createReturn(this.getSupplier(), product, quantity, packageSize, unitPrice, orderItem);
        orderReturn.setStatus("POSTED");
        this.save((IMObject)orderReturn);
        FinancialAct credit = this.rules.creditSupplier((Act)orderReturn);
        Assert.assertTrue((boolean)credit.isA("act.supplierAccountChargesCredit"));
        Assert.assertTrue((boolean)credit.isCredit());
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)credit.getStatus());
        Assert.assertEquals((long)1L, (long)credit.getSourceActRelationships().size());
        IMObjectBean bean = this.getBean((IMObject)credit);
        List acts = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)1L, (long)acts.size());
        FinancialAct item = (FinancialAct)acts.get(0);
        Assert.assertTrue((boolean)item.isA("act.supplierAccountCreditItem"));
        Assert.assertTrue((boolean)item.isCredit());
        IMObjectBean returnBean = this.getBean((IMObject)orderReturn);
        List credits = returnBean.getTargets("returnCredit", Act.class);
        Assert.assertEquals((long)1L, (long)credits.size());
        Assert.assertEquals((Object)credit, credits.get(0));
        try {
            this.rules.creditSupplier((Act)orderReturn);
            Assert.fail((String)"Expected crediting to fail");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testReverseDelivery() {
        BigDecimal quantity = new BigDecimal(50);
        BigDecimal unitPrice = BigDecimal.ONE;
        int packageSize = 10;
        Product product = this.getProduct();
        FinancialAct orderItem = this.createOrderItem(product, quantity, packageSize, unitPrice);
        FinancialAct delivery = this.createDelivery(this.getSupplier(), product, quantity, packageSize, unitPrice, orderItem);
        delivery.setStatus("POSTED");
        this.save((IMObject)delivery);
        this.rules.invoiceSupplier((Act)delivery);
        FinancialAct reversal = this.rules.reverseDelivery((Act)delivery);
        this.checkReversal(reversal, "act.supplierReturn", "act.supplierReturnItem", orderItem, true);
        IMObjectBean bean = this.getBean((IMObject)reversal);
        Assert.assertTrue((boolean)bean.getTargets("returnCredit").isEmpty());
    }

    @Test
    public void testReverseReturn() {
        BigDecimal quantity = new BigDecimal(50);
        int packageSize = 10;
        BigDecimal unitPrice = BigDecimal.ONE;
        Product product = this.getProduct();
        Party supplier = this.getSupplier();
        FinancialAct orderItem = this.createOrderItem(product, quantity, packageSize, unitPrice);
        FinancialAct orderReturn = this.createReturn(supplier, product, quantity, packageSize, unitPrice, orderItem);
        orderReturn.setStatus("POSTED");
        this.save((IMObject)orderReturn);
        this.rules.creditSupplier((Act)orderReturn);
        IMObjectBean returnBean = this.getBean((IMObject)orderReturn);
        Assert.assertEquals((long)1L, (long)returnBean.getTargets("returnCredit").size());
        FinancialAct reversal = this.rules.reverseReturn(orderReturn);
        this.checkReversal(reversal, "act.supplierDelivery", "act.supplierDeliveryItem", orderItem, false);
        IMObjectBean bean = this.getBean((IMObject)reversal);
        Assert.assertTrue((boolean)bean.getTargets("invoice").isEmpty());
    }

    @Test
    public void testHasRestrictedProducts() {
        Product medication1 = (Product)this.productFactory.newMedication().drugSchedule(false).build();
        Product medication2 = (Product)this.productFactory.newMedication().drugSchedule(true).build();
        Product medication3 = this.productFactory.createMedication();
        Product merchandise = this.productFactory.createMerchandise();
        FinancialAct item1 = this.createOrderItem(medication1, BigDecimal.TEN, 1, BigDecimal.ONE);
        FinancialAct item2 = this.createOrderItem(medication2, BigDecimal.TEN, 1, BigDecimal.ONE);
        FinancialAct item3 = this.createOrderItem(medication3, BigDecimal.TEN, 1, BigDecimal.ONE);
        FinancialAct item4 = this.createOrderItem(merchandise, BigDecimal.TEN, 1, BigDecimal.ONE);
        FinancialAct order = this.createOrder(this.getSupplier(), item1, item2, item3, item4);
        Assert.assertTrue((boolean)this.rules.hasRestrictedProducts((Act)order));
        IMObjectBean bean = this.getBean((IMObject)order);
        bean.removeTarget("items", (IMObject)item2);
        Assert.assertFalse((boolean)this.rules.hasRestrictedProducts((Act)order));
    }

    @Override
    public void setUp() {
        super.setUp();
        TaxRules taxRules = new TaxRules(this.getPractice(), (ArchetypeService)this.getArchetypeService());
        ProductRules productRules = new ProductRules(this.getArchetypeService(), this.getLookupService());
        this.rules = new OrderRules(taxRules, this.getArchetypeService(), productRules);
    }

    private void checkDeliveryStatus(FinancialAct act, BigDecimal quantity, BigDecimal received, BigDecimal cancelled, DeliveryStatus expected) {
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("quantity", (Object)quantity);
        bean.setValue("receivedQuantity", (Object)received);
        bean.setValue("cancelledQuantity", (Object)cancelled);
        Assert.assertEquals((Object)expected, (Object)this.rules.getDeliveryStatus(act));
    }

    private void checkReversal(FinancialAct reversal, String archetype, String itemArchetype, FinancialAct orderItem, boolean credit) {
        Assert.assertTrue((boolean)reversal.isA(archetype));
        Assert.assertEquals((Object)credit, (Object)reversal.isCredit());
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)reversal.getStatus());
        IMObjectBean bean = this.getBean((IMObject)reversal);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)1L, (long)items.size());
        FinancialAct item = (FinancialAct)items.get(0);
        Assert.assertTrue((boolean)item.isA(itemArchetype));
        Assert.assertEquals((Object)credit, (Object)item.isCredit());
        IMObjectBean itemBean = this.getBean((IMObject)item);
        List orders = itemBean.getTargets("order", Act.class);
        Assert.assertEquals((long)1L, (long)orders.size());
        Assert.assertEquals((Object)orderItem, orders.get(0));
    }
}

