/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.stock;

import java.math.BigDecimal;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.stock.AbstractStockTest;
import org.openvpms.archetype.rules.stock.StockUpdater;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;

public class StockUpdaterTestCase
extends AbstractStockTest {
    private StockUpdater updater;
    private Product product;
    private Party stockLocation;

    @Test
    public void testTransfer() {
        BigDecimal quantity = new BigDecimal(100);
        Party xferLocation = this.createStockLocation();
        Act act = this.create("act.stockTransfer", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("stockLocation", (IMObject)this.stockLocation);
        bean.setTarget("to", (IMObject)xferLocation);
        Act item = this.create("act.stockTransferItem", Act.class);
        IMObjectBean itemBean = this.getBean((IMObject)item);
        ActRelationship relationship = (ActRelationship)bean.addTarget("items", (IMObject)item);
        item.addActRelationship(relationship);
        itemBean.setTarget("product", (IMObject)this.product);
        itemBean.setValue("quantity", (Object)quantity);
        this.save((IMObject[])new Act[]{act, item});
        this.updater.update(act);
        this.checkEquals(BigDecimal.ZERO, this.getStock(this.stockLocation));
        this.checkEquals(BigDecimal.ZERO, this.getStock(xferLocation));
        bean.setValue("status", (Object)"POSTED");
        bean.save();
        this.updater.update(act);
        this.checkEquals(quantity.negate(), this.getStock(this.stockLocation));
        this.checkEquals(quantity, this.getStock(xferLocation));
        bean.save();
        this.checkEquals(quantity.negate(), this.getStock(this.stockLocation));
        this.checkEquals(quantity, this.getStock(xferLocation));
    }

    @Test
    public void testAdjust() {
        BigDecimal quantity = new BigDecimal(100);
        Act act = this.create("act.stockAdjust", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("stockLocation", (IMObject)this.stockLocation);
        Act item = this.create("act.stockAdjustItem", Act.class);
        IMObjectBean itemBean = this.getBean((IMObject)item);
        bean.addTarget("items", (IMObject)item, "stockAdjust");
        itemBean.setTarget("product", (IMObject)this.product);
        itemBean.setValue("quantity", (Object)quantity);
        this.save((IMObject[])new Act[]{act, item});
        this.updater.update(act);
        this.checkEquals(BigDecimal.ZERO, this.getStock(this.stockLocation));
        bean.setValue("status", (Object)"POSTED");
        bean.save();
        this.updater.update(act);
        this.checkEquals(quantity, this.getStock(this.stockLocation));
    }

    @Before
    public void setUp() {
        this.updater = new StockUpdater(this.getArchetypeService());
        this.product = TestHelper.createProduct();
        this.stockLocation = this.createStockLocation();
    }

    private BigDecimal getStock(Party location) {
        return this.getStock(location, this.product);
    }
}

