/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.stock;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.stock.AbstractStockTest;
import org.openvpms.archetype.rules.stock.StockRules;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.springframework.beans.factory.annotation.Autowired;

public class StockRulesTestCase
extends AbstractStockTest {
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    private StockRules rules;

    @Before
    public void setUp() {
        this.rules = new StockRules(this.getArchetypeService());
    }

    @Test
    public void testGetStockLocation() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party location = (Party)this.practiceFactory.newLocation().stockLocation(stockLocation).build();
        Product product = this.productFactory.createMerchandise();
        IMObjectBean locationBean = this.getBean((IMObject)location);
        Assert.assertFalse((boolean)locationBean.getBoolean("stockControl"));
        Assert.assertNull((Object)this.rules.getStockLocation(product, location));
        locationBean.setValue("stockControl", (Object)true);
        Assert.assertNotNull((Object)this.rules.getStockLocation(product, location));
        this.rules.updateStock(product, stockLocation, BigDecimal.ONE);
        Assert.assertEquals((Object)stockLocation, (Object)this.rules.getStockLocation(product, location));
    }

    @Test
    public void testGetAndUpdateStock() {
        BigDecimal quantity = new BigDecimal("10.00");
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Product product = this.productFactory.createMedication();
        this.checkEquals(BigDecimal.ZERO, this.rules.getStock(product, stockLocation));
        this.rules.updateStock(product, stockLocation, quantity);
        this.checkEquals(quantity, this.rules.getStock(product, stockLocation));
        this.rules.updateStock(product, stockLocation, quantity.negate());
        this.checkEquals(BigDecimal.ZERO, this.rules.getStock(product, stockLocation));
    }

    @Test
    public void testQueryStock() {
        BigDecimal quantity = new BigDecimal("10.00");
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Product product = this.productFactory.createMedication();
        Reference productRef = product.getObjectReference();
        Reference stockRef = stockLocation.getObjectReference();
        this.checkEquals(BigDecimal.ZERO, this.rules.getStock(productRef, stockRef));
        this.rules.updateStock(product, stockLocation, quantity);
        this.checkEquals(quantity, this.rules.getStock(productRef, stockRef));
        this.rules.updateStock(product, stockLocation, quantity.negate());
        this.checkEquals(BigDecimal.ZERO, this.rules.getStock(productRef, stockRef));
    }

    @Test
    public void testTransferStock() {
        BigDecimal quantity = new BigDecimal("10.00");
        Party from = this.practiceFactory.createStockLocation(new Party[0]);
        Party to = this.practiceFactory.createStockLocation(new Party[0]);
        Product product = this.productFactory.createMerchandise();
        this.rules.transfer(product, from, to, quantity);
        this.checkEquals(quantity.negate(), this.rules.getStock(product, from));
        this.checkEquals(quantity, this.rules.getStock(product, to));
    }

    @Test
    public void testStockRelationships() {
        Product product = this.productFactory.createMerchandise();
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Assert.assertFalse((boolean)this.rules.hasStockRelationship(product, stockLocation));
        Assert.assertNull((Object)this.rules.getStockRelationship(product, stockLocation));
        this.rules.updateStock(product, stockLocation, BigDecimal.ONE);
        Assert.assertTrue((boolean)this.rules.hasStockRelationship(product, stockLocation));
        Assert.assertNotNull((Object)this.rules.getStockRelationship(product, stockLocation));
        this.rules.updateStock(product, stockLocation, BigDecimal.ZERO);
        Assert.assertTrue((boolean)this.rules.hasStockRelationship(product, stockLocation));
        Assert.assertNotNull((Object)this.rules.getStockRelationship(product, stockLocation));
    }
}

