/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.stock;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.stock.AbstractStockTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;

public class StockActTestCase
extends AbstractStockTest {
    @Test
    public void testDeleteStockAdjust() {
        this.checkDeleteActs("act.stockAdjust", "act.stockAdjustItem");
    }

    @Test
    public void testDeleteStockTransfer() {
        List<Act> acts = this.createActs("act.stockTransfer", "act.stockTransferItem");
        IMObjectBean bean = this.getBean((IMObject)acts.get(0));
        bean.setTarget("to", (IMObject)this.createStockLocation());
        this.checkDeleteActs(acts);
    }

    private void checkDeleteActs(String shortName, String itemShortName) {
        List<Act> acts = this.createActs(shortName, itemShortName);
        this.checkDeleteActs(acts);
    }

    private void checkDeleteActs(List<Act> acts) {
        this.save(acts);
        Act parent = acts.get(0);
        Act child = acts.get(1);
        Assert.assertNotNull((Object)this.get(parent));
        Assert.assertNotNull((Object)this.get(child));
        this.remove((IMObject)parent);
        Assert.assertNull((Object)this.get(parent));
        Assert.assertNull((Object)this.get(child));
    }

    private List<Act> createActs(String shortName, String itemShortName) {
        Act act = this.create(shortName, Act.class);
        Act item = this.create(itemShortName, Act.class);
        IMObjectBean itemBean = this.getBean((IMObject)item);
        itemBean.setTarget("product", (IMObject)TestHelper.createProduct());
        this.getArchetypeService().deriveValues((IMObject)item);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("stockLocation", (IMObject)this.createStockLocation());
        bean.addTarget("items", (IMObject)item);
        ArrayList<Act> acts = new ArrayList<Act>();
        acts.add(act);
        acts.add(item);
        return acts;
    }
}

