/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.settings;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.settings.AbstractSettingsTest;
import org.openvpms.archetype.rules.settings.Settings;
import org.openvpms.component.business.service.security.AuthenticationContext;
import org.openvpms.component.business.service.singleton.SingletonService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;

public class SettingsImplTestCase
extends AbstractSettingsTest {
    @Test
    public void testDefaults() {
        Settings settings = this.getSettings();
        Assert.assertEquals((long)8L, (long)settings.getInt("entity.globalSettingsPassword", "minLength", 10));
        Assert.assertTrue((boolean)settings.getBoolean("entity.globalSettingsPassword", "lowercase", false));
        Assert.assertTrue((boolean)settings.getBoolean("entity.globalSettingsPassword", "uppercase", false));
        Assert.assertTrue((boolean)settings.getBoolean("entity.globalSettingsPassword", "number", false));
        Assert.assertTrue((boolean)settings.getBoolean("entity.globalSettingsPassword", "special", false));
    }

    @Test
    public void testUpdate() {
        Settings settings = this.getSettings();
        Assert.assertEquals((long)8L, (long)settings.getInt("entity.globalSettingsPassword", "minLength", 10));
        Assert.assertTrue((boolean)settings.getBoolean("entity.globalSettingsPassword", "lowercase", false));
        Entity entity = this.getSingleton("entity.globalSettingsPassword");
        IMObjectBean bean = this.getBean((IMObject)entity);
        bean.setValue("minLength", (Object)6);
        bean.setValue("lowercase", (Object)false);
        bean.save();
        Assert.assertEquals((long)6L, (long)settings.getInt("entity.globalSettingsPassword", "minLength", 10));
        Assert.assertFalse((boolean)settings.getBoolean("entity.globalSettingsPassword", "lowercase", true));
    }

    @Test
    public void testUnauthenticatedUser() {
        Settings settings = this.getSettings();
        SingletonService service = this.getSingletonService();
        AuthenticationContext context = this.getContext();
        context.setUser(null);
        Assert.assertNull((Object)service.get("entity.globalSettingsPassword", Entity.class));
        Assert.assertEquals((long)8L, (long)settings.getInt("entity.globalSettingsPassword", "minLength", 10));
        Assert.assertNull((Object)service.get("entity.globalSettingsPassword", Entity.class));
        Entity entity = (Entity)service.get("entity.globalSettingsPassword", Entity.class, true);
        IMObjectBean bean = this.getBean((IMObject)entity);
        bean.setValue("minLength", (Object)6);
        bean.save();
        Assert.assertEquals((long)6L, (long)settings.getInt("entity.globalSettingsPassword", "minLength", 10));
    }
}

