/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.settings;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.openvpms.archetype.rules.settings.Settings;
import org.openvpms.archetype.rules.settings.SettingsCache;
import org.openvpms.archetype.rules.settings.SettingsImpl;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.security.AuthenticationContext;
import org.openvpms.component.business.service.security.AuthenticationContextImpl;
import org.openvpms.component.business.service.singleton.SingletonService;
import org.openvpms.component.business.service.singleton.SingletonServiceImpl;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class AbstractSettingsTest
extends ArchetypeServiceTest {
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private UserRules userRules;
    private SettingsImpl settings;
    private SingletonService singletonService;
    private AuthenticationContext context;
    private SettingsCache cache;

    @Before
    public void setUp() {
        Entity policy;
        IArchetypeService service = this.getArchetypeService();
        this.singletonService = new SingletonServiceImpl((ArchetypeService)service, this.transactionManager);
        while ((policy = (Entity)this.singletonService.get("entity.globalSettingsPassword", Entity.class)) != null) {
            service.remove((IMObject)policy);
        }
        this.context = new AuthenticationContextImpl();
        this.context.setUser(TestHelper.createUser());
        this.cache = new SettingsCache(service, this.transactionManager, (SingletonService)new SingletonServiceImpl((ArchetypeService)service, this.transactionManager), this.context, this.userRules);
        this.settings = new SettingsImpl(this.cache);
    }

    @After
    public void tearDown() {
        this.cache.destroy();
    }

    protected Settings getSettings() {
        return this.settings;
    }

    protected Entity getSingleton(String archetype) {
        Entity entity = (Entity)this.singletonService.get(archetype, Entity.class, true);
        Assert.assertNotNull((Object)entity);
        return entity;
    }

    protected SingletonService getSingletonService() {
        return this.singletonService;
    }

    protected AuthenticationContext getContext() {
        return this.context;
    }
}

