/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.security.FirewallEntry;
import org.openvpms.archetype.rules.security.FirewallSettings;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class FirewallSettingsTestCase
extends ArchetypeServiceTest {
    @Test
    public void testDefaults() {
        FirewallSettings settings = this.createSettings();
        Assert.assertEquals((Object)FirewallSettings.AccessType.UNRESTRICTED, (Object)settings.getAccessType());
        Assert.assertTrue((boolean)settings.getAllowedAddresses().isEmpty());
    }

    @Test
    public void testAllowedAddresses() {
        FirewallSettings settings1 = this.createSettings();
        ArrayList<FirewallEntry> allowed = new ArrayList<FirewallEntry>();
        for (int i = 0; i < 300; ++i) {
            allowed.add(new FirewallEntry("192.168.1.1", i % 2 == 0, "An entry"));
        }
        IMObjectBean bean = this.getBean((IMObject)settings1.getSettings());
        Assert.assertNull((Object)bean.getString("allowed0"));
        Assert.assertNull((Object)bean.getString("allowed1"));
        settings1.setAllowedAddresses(allowed);
        this.checkEntries(allowed, settings1.getAllowedAddresses());
        Assert.assertNotNull((Object)bean.getString("allowed0"));
        Assert.assertNotNull((Object)bean.getString("allowed1"));
        this.save((IMObject)settings1.getSettings());
        Entity reloaded = this.get(settings1.getSettings());
        FirewallSettings settings2 = new FirewallSettings(reloaded, (ArchetypeService)this.getArchetypeService());
        this.checkEntries(allowed, settings2.getAllowedAddresses());
    }

    @Test
    public void testClearAllowed() {
        FirewallSettings settings1 = this.createSettings();
        IMObjectBean bean = this.getBean((IMObject)settings1.getSettings());
        bean.setValue("allowed0", (Object)"127.0.0.1 1");
        bean.setValue("allowed1", (Object)"192.168.1.1 0");
        settings1.setAllowedAddresses(new ArrayList());
        this.save((IMObject)settings1.getSettings());
        Entity reloaded = this.get(settings1.getSettings());
        FirewallSettings settings2 = new FirewallSettings(reloaded, (ArchetypeService)this.getArchetypeService());
        this.checkEntries(Collections.emptyList(), settings2.getAllowedAddresses());
    }

    private void checkEntries(List<FirewallEntry> expectedList, List<FirewallEntry> actualList) {
        Assert.assertNotSame(expectedList, actualList);
        Assert.assertEquals((long)expectedList.size(), (long)actualList.size());
        for (int i = 0; i < expectedList.size(); ++i) {
            FirewallEntry expected = expectedList.get(i);
            FirewallEntry actual = actualList.get(i);
            Assert.assertEquals((Object)expected.getAddress(), (Object)actual.getAddress());
            Assert.assertEquals((Object)expected.isActive(), (Object)actual.isActive());
            Assert.assertEquals((Object)expected.getDescription(), (Object)actual.getDescription());
        }
    }

    private FirewallSettings createSettings() {
        return new FirewallSettings(this.create("entity.globalSettingsFirewall", Entity.class), (ArchetypeService)this.getArchetypeService());
    }
}

