/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product.io;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.function.date.DateFunctions;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.finance.tax.TaxRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.io.AbstractProductIOTest;
import org.openvpms.archetype.rules.product.io.PriceData;
import org.openvpms.archetype.rules.product.io.ProductCSVReader;
import org.openvpms.archetype.rules.product.io.ProductCSVWriter;
import org.openvpms.archetype.rules.product.io.ProductData;
import org.openvpms.archetype.rules.product.io.ProductDataSet;
import org.openvpms.archetype.rules.product.io.ProductIOHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestFixedPriceBuilder;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestUnitPriceBuilder;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class ProductCSVWriterReaderTestCase
extends AbstractProductIOTest {
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    private ProductPriceRules rules;
    private TaxRules taxRules;
    private DocumentHandlers handlers;
    private ProductPrice fixed1A;
    private ProductPrice fixed1B;
    private ProductPrice fixed1C;
    private ProductPrice fixed2A;
    private ProductPrice fixed2B;
    private ProductPrice fixed2C;
    private ProductPrice unit1A;
    private ProductPrice unit1B;
    private ProductPrice unit1C;
    private ProductPrice unit2A;
    private ProductPrice unit2B;
    private ProductPrice unit2C;
    private Product product;
    private Lookup groupA;
    private Lookup groupB;
    private Date monthsMinus21;

    @Before
    public void setUp() {
        this.rules = new ProductPriceRules((ArchetypeService)this.getArchetypeService());
        Party practice = this.practiceFactory.getPractice();
        this.taxRules = new TaxRules(practice, (ArchetypeService)this.getArchetypeService());
        this.handlers = new DocumentHandlers((ArchetypeService)this.getArchetypeService());
        Date today = DateRules.getToday();
        Date tomorrow = DateRules.getTomorrow();
        Date yesterday = DateRules.getYesterday();
        Date months2 = DateRules.getDate((Date)today, (int)2, (DateUnits)DateUnits.MONTHS);
        Date months21 = DateRules.getDate((Date)months2, (int)1, (DateUnits)DateUnits.DAYS);
        Date monthsMinus2 = DateRules.getDate((Date)today, (int)-2, (DateUnits)DateUnits.MONTHS);
        this.monthsMinus21 = DateRules.getDate((Date)monthsMinus2, (int)-1, (DateUnits)DateUnits.DAYS);
        this.groupA = this.productFactory.createPricingGroup("A");
        this.groupB = this.productFactory.createPricingGroup("B");
        this.fixed1A = ((TestFixedPriceBuilder)this.newFixedPrice("1.0", "0.5", "100", "10", this.monthsMinus21, yesterday, false).pricingGroups(this.groupA)).build();
        this.fixed1B = ((TestFixedPriceBuilder)this.newFixedPrice("1.0", "0.5", "100", "10", this.monthsMinus21, yesterday, false).pricingGroups(this.groupB)).build();
        this.fixed1C = this.createFixedPrice("1.0", "0.5", "100", "10", this.monthsMinus21, yesterday, false);
        this.fixed2A = ((TestFixedPriceBuilder)this.newFixedPrice("1.08", "0.6", "80", "10", today, months2, true).pricingGroups(this.groupA)).build();
        this.fixed2B = ((TestFixedPriceBuilder)this.newFixedPrice("1.08", "0.6", "80", "10", today, months2, true).pricingGroups(this.groupB)).build();
        this.fixed2C = this.createFixedPrice("1.08", "0.6", "80", "10", today, months2, true);
        this.unit1A = ((TestUnitPriceBuilder)this.newUnitPrice("1.92", "1.2", "60", "10", monthsMinus2, today).pricingGroups(this.groupA)).build();
        this.unit1B = ((TestUnitPriceBuilder)this.newUnitPrice("1.92", "1.2", "60", "10", monthsMinus2, today).pricingGroups(this.groupB)).build();
        this.unit1C = this.createUnitPrice("1.92", "1.2", "60", "10", monthsMinus2, today);
        this.unit2A = ((TestUnitPriceBuilder)this.newUnitPrice("2.55", "1.5", "70", "10", tomorrow, months21).pricingGroups(this.groupA)).build();
        this.unit2B = ((TestUnitPriceBuilder)this.newUnitPrice("2.55", "1.5", "70", "10", tomorrow, months21).pricingGroups(this.groupB)).build();
        this.unit2C = this.createUnitPrice("2.55", "1.5", "70", "10", tomorrow, months21);
        this.product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.newProduct("Product A", "A", new ProductPrice[0]).addTaxTypes(this.lookupFactory.createTaxType(5))).addPrices(this.fixed1A, this.fixed1B, this.fixed1C, this.fixed2A, this.fixed2B, this.fixed2C, this.unit1A, this.unit1B, this.unit1C, this.unit2A, this.unit2B, this.unit2C)).build();
    }

    @Test
    public void testWriteReadLatestPrices() {
        ProductCSVWriter writer = new ProductCSVWriter(this.getArchetypeService(), this.rules, this.taxRules, this.handlers);
        Document document = writer.write(Collections.singletonList(this.product).iterator(), true, true, new PricingGroup(this.groupA, false));
        ProductCSVReader reader = new ProductCSVReader(this.handlers, this.getLookupService());
        List dateFormats = reader.getDateFormats((org.openvpms.component.model.document.Document)document);
        Assert.assertEquals((long)1L, (long)dateFormats.size());
        Assert.assertEquals((Object)"yy-MM-dd", (Object)((SimpleDateFormat)dateFormats.get(0)).toPattern());
        reader.setDateFormats(dateFormats);
        ProductDataSet products = reader.read((org.openvpms.component.model.document.Document)document);
        Assert.assertEquals((long)1L, (long)products.getData().size());
        Assert.assertEquals((long)0L, (long)products.getErrors().size());
        ProductData data = (ProductData)products.getData().get(0);
        this.checkProduct(data, this.product);
        Assert.assertEquals((long)1L, (long)data.getFixedPrices().size());
        this.checkPrice((PriceData)data.getFixedPrices().get(0), this.fixed2A);
        Assert.assertEquals((long)1L, (long)data.getUnitPrices().size());
        this.checkPrice((PriceData)data.getUnitPrices().get(0), this.unit2A);
    }

    @Test
    public void testWriteReadAllPricesForGroup() {
        ProductCSVWriter writer = new ProductCSVWriter(this.getArchetypeService(), this.rules, this.taxRules, this.handlers);
        Document document = writer.write(Collections.singletonList(this.product).iterator(), false, true, new PricingGroup(this.groupA, false));
        ProductCSVReader reader = new ProductCSVReader(this.handlers, this.getLookupService());
        reader.setDateFormats(ProductCSVReader.getYearMonthDayFormats());
        ProductDataSet products = reader.read((org.openvpms.component.model.document.Document)document);
        Assert.assertEquals((long)1L, (long)products.getData().size());
        Assert.assertEquals((long)0L, (long)products.getErrors().size());
        ProductData data = (ProductData)products.getData().get(0);
        this.checkProduct(data, this.product);
        Assert.assertEquals((long)2L, (long)data.getFixedPrices().size());
        this.checkPrice((PriceData)data.getFixedPrices().get(0), this.fixed2A);
        this.checkPrice((PriceData)data.getFixedPrices().get(1), this.fixed1A);
        Assert.assertEquals((long)2L, (long)data.getUnitPrices().size());
        this.checkPrice((PriceData)data.getUnitPrices().get(0), this.unit2A);
        this.checkPrice((PriceData)data.getUnitPrices().get(1), this.unit1A);
    }

    @Test
    public void testWriteReadAllPrices() {
        ProductCSVWriter writer = new ProductCSVWriter(this.getArchetypeService(), this.rules, this.taxRules, this.handlers);
        Document document = writer.write(Collections.singletonList(this.product).iterator(), false, true, PricingGroup.ALL);
        ProductCSVReader reader = new ProductCSVReader(this.handlers, this.getLookupService());
        reader.setDateFormats(ProductCSVReader.getYearMonthDayFormats());
        ProductDataSet products = reader.read((org.openvpms.component.model.document.Document)document);
        Assert.assertEquals((long)1L, (long)products.getData().size());
        Assert.assertEquals((long)0L, (long)products.getErrors().size());
        ProductData data = (ProductData)products.getData().get(0);
        this.checkProduct(data, this.product);
        this.checkPrices(data.getFixedPrices(), this.fixed1A, this.fixed1B, this.fixed1C, this.fixed2A, this.fixed2B, this.fixed2C);
        this.checkPrices(data.getUnitPrices(), this.unit1A, this.unit1B, this.unit1C, this.unit2A, this.unit2B, this.unit2C);
    }

    @Test
    public void testWriteReadRangePrices() {
        ProductCSVWriter writer = new ProductCSVWriter(this.getArchetypeService(), this.rules, this.taxRules, this.handlers);
        Date from = this.monthsMinus21;
        Date to = DateRules.getDate((Date)from, (int)1, (DateUnits)DateUnits.MONTHS);
        Document document = writer.write(Collections.singletonList(this.product).iterator(), from, to, true, new PricingGroup(this.groupB, false));
        ProductCSVReader reader = new ProductCSVReader(this.handlers, this.getLookupService());
        reader.setDateFormats(ProductCSVReader.getYearMonthDayFormats());
        ProductDataSet products = reader.read((org.openvpms.component.model.document.Document)document);
        Assert.assertEquals((long)1L, (long)products.getData().size());
        Assert.assertEquals((long)0L, (long)products.getErrors().size());
        ProductData data = (ProductData)products.getData().get(0);
        this.checkProduct(data, this.product);
        Assert.assertEquals((long)1L, (long)data.getFixedPrices().size());
        this.checkPrice((PriceData)data.getFixedPrices().get(0), this.fixed1B);
        Assert.assertEquals((long)1L, (long)data.getUnitPrices().size());
        this.checkPrice((PriceData)data.getUnitPrices().get(0), this.unit1B);
    }

    @Test
    public void testWriteUnitPrices() {
        this.product.removeProductPrice(this.fixed1A);
        this.product.removeProductPrice(this.fixed1B);
        this.product.removeProductPrice(this.fixed1C);
        this.product.removeProductPrice(this.fixed2A);
        this.product.removeProductPrice(this.fixed2B);
        this.product.removeProductPrice(this.fixed2C);
        this.save((IMObject)this.product);
        ProductCSVWriter writer = new ProductCSVWriter(this.getArchetypeService(), this.rules, this.taxRules, this.handlers);
        Document document = writer.write(Collections.singletonList(this.product).iterator(), false, true, new PricingGroup(this.groupA, false));
        ProductCSVReader reader = new ProductCSVReader(this.handlers, this.getLookupService());
        reader.setDateFormats(ProductCSVReader.getYearMonthDayFormats());
        ProductDataSet products = reader.read((org.openvpms.component.model.document.Document)document);
        Assert.assertEquals((long)1L, (long)products.getData().size());
        Assert.assertEquals((long)0L, (long)products.getErrors().size());
        ProductData data = (ProductData)products.getData().get(0);
        this.checkProduct(data, this.product);
        Assert.assertEquals((long)0L, (long)data.getFixedPrices().size());
        Assert.assertEquals((long)2L, (long)data.getUnitPrices().size());
        this.checkPrice((PriceData)data.getUnitPrices().get(0), this.unit2A);
        this.checkPrice((PriceData)data.getUnitPrices().get(1), this.unit1A);
    }

    @Test
    public void testWriteFixedPrices() {
        this.product.removeProductPrice(this.unit1A);
        this.product.removeProductPrice(this.unit1B);
        this.product.removeProductPrice(this.unit1C);
        this.product.removeProductPrice(this.unit2A);
        this.product.removeProductPrice(this.unit2B);
        this.product.removeProductPrice(this.unit2C);
        this.save((IMObject)this.product);
        ProductCSVWriter writer = new ProductCSVWriter(this.getArchetypeService(), this.rules, this.taxRules, this.handlers);
        Document document = writer.write(Collections.singletonList(this.product).iterator(), false, true, new PricingGroup(this.groupA, false));
        ProductCSVReader reader = new ProductCSVReader(this.handlers, this.getLookupService());
        reader.setDateFormats(ProductCSVReader.getYearMonthDayFormats());
        ProductDataSet products = reader.read((org.openvpms.component.model.document.Document)document);
        Assert.assertEquals((long)1L, (long)products.getData().size());
        Assert.assertEquals((long)0L, (long)products.getErrors().size());
        ProductData data = (ProductData)products.getData().get(0);
        this.checkProduct(data, this.product);
        Assert.assertEquals((long)2L, (long)data.getFixedPrices().size());
        Assert.assertEquals((long)0L, (long)data.getUnitPrices().size());
        this.checkPrice((PriceData)data.getFixedPrices().get(0), this.fixed2A);
        this.checkPrice((PriceData)data.getFixedPrices().get(1), this.fixed1A);
    }

    @Test
    public void testDateParsing() {
        ProductPrice fixed1 = this.createFixedPrice("1.0", "0.5", "100", "10", "2012-02-01", "2012-04-01", false);
        ProductPrice fixed2 = this.createFixedPrice("1.08", "0.6", "80", "10", "2012-04-02", "2012-06-01", true);
        ProductPrice unit1 = this.createUnitPrice("1.92", "1.2", "60", "10", "2012-02-02", "2012-04-02");
        ProductPrice unit2 = this.createUnitPrice("2.55", "1.5", "70", "10", "2012-04-03", "2012-06-02");
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.newProduct("Product A", "A", new ProductPrice[0]).addPrices(fixed1, fixed2, unit1, unit2)).addTaxTypes(this.lookupFactory.createTaxType(5))).build();
        ProductCSVWriter writer = new ProductCSVWriter(this.getArchetypeService(), this.rules, this.taxRules, this.handlers){

            protected String getDate(Date date) {
                return new DateFunctions().format(date, "dd/MM/yy");
            }
        };
        Document document = writer.write(Collections.singletonList(product).iterator(), false, true, PricingGroup.ALL);
        ProductCSVReader reader = new ProductCSVReader(this.handlers, this.getLookupService());
        List dateFormats = reader.getDateFormats((org.openvpms.component.model.document.Document)document);
        Assert.assertEquals((long)3L, (long)dateFormats.size());
        Assert.assertEquals(ProductCSVReader.getDayMonthYearFormats().get(0), dateFormats.get(0));
        Assert.assertEquals(ProductCSVReader.getYearMonthDayFormats().get(0), dateFormats.get(1));
        Assert.assertEquals(ProductCSVReader.getMonthDayYearFormats().get(0), dateFormats.get(2));
        reader.setDateFormats(Collections.singletonList(dateFormats.get(0)));
        ProductDataSet products = reader.read((org.openvpms.component.model.document.Document)document);
        Assert.assertEquals((long)1L, (long)products.getData().size());
        Assert.assertEquals((long)0L, (long)products.getErrors().size());
        ProductData data = (ProductData)products.getData().get(0);
        this.checkProduct(data, product);
        this.checkPrices(data.getFixedPrices(), fixed1, fixed2);
        this.checkPrices(data.getUnitPrices(), unit1, unit2);
    }

    @Test
    public void testMissingFixedCost() throws IOException {
        String[][] data = new String[][]{{"1001", "Product A", "A", "-1", "1.08", "", "10", "02/04/12", "01/06/12", "true", "", "-1", "2.55", "1.5", "10", "03/04/12", "02/06/12", "", "5.0"}};
        ProductDataSet products = this.createProductDataSet(data);
        Assert.assertEquals((long)1L, (long)products.getErrors().size());
        Assert.assertEquals((Object)"A value for Fixed Cost is required", (Object)((ProductData)products.getErrors().get(0)).getError());
    }

    @Test
    public void testMissingFixedMaxDiscount() throws IOException {
        String[][] data = new String[][]{{"1001", "Product A", "A", "-1", "1.08", "0.6", "", "02/04/12", "01/06/12", "true", "", "-1", "2.55", "1.5", "10", "03/04/12", "02/06/12", "", "5.0"}};
        ProductDataSet products = this.createProductDataSet(data);
        Assert.assertEquals((long)1L, (long)products.getErrors().size());
        Assert.assertEquals((Object)"A value for Fixed Price Max Discount is required", (Object)((ProductData)products.getErrors().get(0)).getError());
    }

    @Test
    public void testMissingUnitCost() throws IOException {
        String[][] data = new String[][]{{"1001", "Product A", "A", "-1", "1.08", "0.6", "10", "02/04/12", "01/06/12", "true", "", "-1", "2.55", "", "10", "03/04/12", "02/06/12", "", "5.0"}};
        ProductDataSet products = this.createProductDataSet(data);
        Assert.assertEquals((long)1L, (long)products.getErrors().size());
        Assert.assertEquals((Object)"A value for Unit Cost is required", (Object)((ProductData)products.getErrors().get(0)).getError());
    }

    @Test
    public void testMissingUnitPriceMaxDiscount() throws IOException {
        String[][] data = new String[][]{{"1001", "Product A", "A", "-1", "1.08", "0.6", "10", "02/04/12", "01/06/12", "true", "", "-1", "2.55", "1.5", "", "03/04/12", "02/06/12", "", "5.0"}};
        ProductDataSet products = this.createProductDataSet(data);
        Assert.assertEquals((long)1L, (long)products.getErrors().size());
        Assert.assertEquals((Object)"A value for Unit Price Max Discount is required", (Object)((ProductData)products.getErrors().get(0)).getError());
    }

    @Test
    public void testInvalidLine() throws IOException {
        String[][] data = new String[][]{{"1001", "Product A", "A", "-1", "1.08", "0.6", "10", "02/04/12", "01/06/12", "true", "", "-1", "2.55", "1.5", "10", "03/04/12", "02/06/12", "", "5.0", ""}, {"1002", "Product B", "B", "-1", "1.08", "0.6", "10", "02/04/12", "01/06/12", "true", "", "-1", "2.55", "1.5", "10", "03/04/12", "02/06/12", "", "5.0"}, {"1003", "Product C", "C", "-1", "1.08", "0.6", "10", "02/04/12", "01/06/12", "true", "", "-1", "2.55", "1.5", "10", "03/04/12", "02/06/12", ""}};
        ProductDataSet products = this.createProductDataSet(data);
        Assert.assertEquals((Object)"Line 4 contains 18 fields, but 20 are required", (Object)((ProductData)products.getErrors().get(0)).getError());
    }

    @Test
    public void testWritePricesWithNullCostAndMaxDiscounts() {
        ProductPrice fixed1 = this.createFixedPrice("1.0", null, "100", null, "2012-02-01", "2012-04-01", false);
        ProductPrice unit1 = this.createUnitPrice("1.92", null, "60", null, "2012-02-02", "2012-04-02");
        Product product = (Product)((TestMedicationProductBuilder)this.newProduct("Product A", "A", fixed1, unit1).addClassifications(this.lookupFactory.createTaxType(5))).build();
        ProductCSVWriter writer = new ProductCSVWriter(this.getArchetypeService(), this.rules, this.taxRules, this.handlers);
        Document document = writer.write(Collections.singletonList(product).iterator(), false, true, PricingGroup.ALL);
        ProductCSVReader reader = new ProductCSVReader(this.handlers, this.getLookupService());
        reader.setDateFormats(ProductCSVReader.getYearMonthDayFormats());
        ProductDataSet products = reader.read((org.openvpms.component.model.document.Document)document);
        Assert.assertEquals((long)1L, (long)products.getData().size());
        Assert.assertEquals((long)0L, (long)products.getErrors().size());
        ProductData data = (ProductData)products.getData().get(0);
        this.checkProduct(data, product);
        Assert.assertEquals((long)1L, (long)data.getFixedPrices().size());
        this.checkEquals(BigDecimal.ZERO, ((PriceData)data.getFixedPrices().get(0)).getCost());
        this.checkEquals(MathRules.ONE_HUNDRED, ((PriceData)data.getFixedPrices().get(0)).getMaxDiscount());
        Assert.assertEquals((long)1L, (long)data.getUnitPrices().size());
        this.checkEquals(BigDecimal.ZERO, ((PriceData)data.getUnitPrices().get(0)).getCost());
        this.checkEquals(MathRules.ONE_HUNDRED, ((PriceData)data.getUnitPrices().get(0)).getMaxDiscount());
    }

    private ProductDataSet createProductDataSet(String[][] data) throws IOException {
        StringWriter writer = new StringWriter();
        CSVWriter csv = new CSVWriter((Writer)writer, ',');
        csv.writeNext(ProductCSVWriter.HEADER);
        for (String[] line : data) {
            csv.writeNext(line);
        }
        csv.close();
        DocumentHandler handler = this.handlers.get("Dummy.csv", "text/csv");
        Document document = handler.create("Dummy.csv", (InputStream)new ByteArrayInputStream(writer.toString().getBytes(StandardCharsets.UTF_8)), "text/csv", -1);
        ProductCSVReader reader = new ProductCSVReader(this.handlers, this.getLookupService());
        return reader.read((org.openvpms.component.model.document.Document)document);
    }

    private void checkProduct(ProductData data, Product expected) {
        IMObjectBean bean = this.getBean((IMObject)expected);
        Assert.assertEquals((long)expected.getId(), (long)data.getId());
        Assert.assertEquals((Object)expected.getName(), (Object)data.getName());
        Assert.assertEquals((Object)bean.getString("printedName"), (Object)data.getPrintedName());
        this.checkEquals(this.taxRules.getTaxRate(expected), data.getTaxRate());
    }

    private void checkPrice(PriceData data, ProductPrice expected) {
        IMObjectBean bean = this.getBean((IMObject)expected);
        Assert.assertEquals((Object)expected.getPrice(), (Object)data.getPrice());
        Assert.assertEquals((Object)bean.getBigDecimal("cost"), (Object)data.getCost());
        Assert.assertEquals((Object)bean.getBigDecimal("maxDiscount"), (Object)data.getMaxDiscount());
        Assert.assertEquals((Object)expected.getFromDate(), (Object)data.getFrom());
        Assert.assertEquals((Object)expected.getToDate(), (Object)data.getTo());
        Set pricingGroups = ProductIOHelper.getPricingGroups((ProductPrice)expected, (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((Object)pricingGroups, (Object)data.getPricingGroups());
    }

    private void checkPrices(List<PriceData> actual, ProductPrice ... expected) {
        Assert.assertEquals((long)actual.size(), (long)expected.length);
        for (ProductPrice price : expected) {
            for (PriceData other : actual) {
                if (other.getId() != price.getId()) continue;
                this.checkPrice(other, price);
                return;
            }
            Assert.fail((String)("PriceData not found for id=" + price.getId()));
        }
    }
}

