/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.math.BigDecimal;
import java.util.Date;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.ServiceRatioService;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.CalendarService;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.component.business.service.cache.BasicEhcacheManager;
import org.openvpms.component.business.service.cache.EhcacheManager;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceRatioServiceTestCase
extends ArchetypeServiceTest {
    @Autowired
    private ProductPriceRules rules;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    private CalendarService calendarService;
    private ServiceRatioService service;

    @Before
    public void setUp() {
        this.calendarService = new CalendarService(this.getArchetypeService(), (EhcacheManager)new BasicEhcacheManager(30L));
        this.service = new ServiceRatioService(this.calendarService, this.rules);
    }

    @After
    public void tearDown() throws Exception {
        this.calendarService.destroy();
    }

    @Test
    public void testServiceRatioWithoutCalendar() {
        Entity productType = this.productFactory.createProductType();
        Party location1 = (Party)this.practiceFactory.newLocation().addServiceRatio(productType, BigDecimal.TEN).build();
        Party location2 = this.practiceFactory.createLocation();
        Entity department = null;
        Product product = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().type(productType)).build();
        Date now = new Date();
        Date lastYear = DateRules.getDate((Date)now, (int)-1, (DateUnits)DateUnits.YEARS);
        Date nextYear = DateRules.getDate((Date)now, (int)1, (DateUnits)DateUnits.YEARS);
        this.checkEquals(BigDecimal.TEN, this.service.getServiceRatio(product, department, location1, now));
        this.checkEquals(BigDecimal.TEN, this.service.getServiceRatio(product, department, location1, lastYear));
        this.checkEquals(BigDecimal.TEN, this.service.getServiceRatio(product, department, location1, nextYear));
        Assert.assertNull((Object)this.service.getServiceRatio(product, department, location2, now));
        Assert.assertNull((Object)this.service.getServiceRatio(product, department, location2, lastYear));
        Assert.assertNull((Object)this.service.getServiceRatio(product, department, location2, nextYear));
    }

    @Test
    public void testServiceRatioWithCalendar() {
        Entity calendar = this.productFactory.createServiceRatioCalendar();
        Entity productType = this.productFactory.createProductType();
        Party location = (Party)this.practiceFactory.newLocation().addServiceRatio(productType, BigDecimal.TEN, calendar).build();
        Entity department = null;
        Product product = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().type(productType)).build();
        BigDecimal ratio1 = this.service.getServiceRatio(product, department, location, new Date());
        Assert.assertNull((Object)ratio1);
        Date start1 = TestHelper.getDatetime("2018-07-29 22:00:00");
        Date end1 = TestHelper.getDatetime("2018-07-30 07:00:00");
        Date start2 = TestHelper.getDatetime("2018-07-30 22:00:00");
        Date end2 = TestHelper.getDatetime("2018-07-31 07:00:00");
        Date start3 = TestHelper.getDatetime("2018-07-31 07:00:00");
        Date end3 = TestHelper.getDatetime("2018-07-31 12:00:00");
        this.schedulingFactory.createCalendarEvent(calendar, start1, end1);
        this.schedulingFactory.createCalendarEvent(calendar, start2, end2);
        this.schedulingFactory.createCalendarEvent(calendar, start3, end3);
        Date beforeStart1 = DateRules.getDate((Date)start1, (int)-1, (DateUnits)DateUnits.MINUTES);
        Date afterStart1 = DateRules.getDate((Date)start1, (int)1, (DateUnits)DateUnits.MINUTES);
        Assert.assertNull((Object)this.service.getServiceRatio(product, department, location, beforeStart1));
        this.checkEquals(BigDecimal.TEN, this.service.getServiceRatio(product, department, location, start1));
        this.checkEquals(BigDecimal.TEN, this.service.getServiceRatio(product, department, location, afterStart1));
        Date beforeEnd1 = DateRules.getDate((Date)end1, (int)-1, (DateUnits)DateUnits.MINUTES);
        Date afterEnd1 = DateRules.getDate((Date)end1, (int)1, (DateUnits)DateUnits.MINUTES);
        this.checkEquals(BigDecimal.TEN, this.service.getServiceRatio(product, department, location, beforeEnd1));
        Assert.assertNull((Object)this.service.getServiceRatio(product, department, location, end1));
        Assert.assertNull((Object)this.service.getServiceRatio(product, department, location, afterEnd1));
        Date beforeStart2 = DateRules.getDate((Date)start2, (int)-1, (DateUnits)DateUnits.MINUTES);
        Date afterStart2 = DateRules.getDate((Date)start2, (int)1, (DateUnits)DateUnits.MINUTES);
        Assert.assertNull((Object)this.service.getServiceRatio(product, department, location, beforeStart2));
        this.checkEquals(BigDecimal.TEN, this.service.getServiceRatio(product, department, location, start2));
        this.checkEquals(BigDecimal.TEN, this.service.getServiceRatio(product, department, location, afterStart2));
        Date beforeEnd2 = DateRules.getDate((Date)end2, (int)-1, (DateUnits)DateUnits.MINUTES);
        Date afterEnd2 = DateRules.getDate((Date)end2, (int)1, (DateUnits)DateUnits.MINUTES);
        this.checkEquals(BigDecimal.TEN, this.service.getServiceRatio(product, department, location, beforeEnd2));
        this.checkEquals(BigDecimal.TEN, this.service.getServiceRatio(product, department, location, end2));
        this.checkEquals(BigDecimal.TEN, this.service.getServiceRatio(product, department, location, afterEnd2));
    }
}

