/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.math.BigDecimal;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;

public class ProductSupplierTestCase
extends ArchetypeServiceTest {
    @Test
    public void test() {
        ProductRules rules = new ProductRules(this.getArchetypeService(), this.getLookupService());
        Party supplier = TestHelper.createSupplier();
        Product product = TestHelper.createProduct();
        ProductSupplier ps = rules.createProductSupplier(product, supplier);
        Assert.assertEquals((Object)product, (Object)ps.getProduct());
        Assert.assertEquals((Object)product.getObjectReference(), (Object)ps.getProductRef());
        Assert.assertEquals((Object)supplier, (Object)ps.getSupplier());
        Assert.assertEquals((Object)supplier.getObjectReference(), (Object)ps.getSupplierRef());
        Date startTime = new Date();
        ps.setActiveStartTime(startTime);
        Assert.assertEquals((Object)startTime, (Object)ps.getActiveStartTime());
        Date endTime = new Date();
        ps.setActiveEndTime(endTime);
        Assert.assertEquals((Object)endTime, (Object)ps.getActiveEndTime());
        String reorderCode = "REORDERCODE";
        ps.setReorderCode(reorderCode);
        Assert.assertEquals((Object)reorderCode, (Object)ps.getReorderCode());
        String reorderDesc = "REORDERDESC";
        ps.setReorderDescription(reorderDesc);
        Assert.assertEquals((Object)reorderDesc, (Object)ps.getReorderDescription());
        String barCode = "BARCODE";
        ps.setBarCode(barCode);
        Assert.assertEquals((Object)barCode, (Object)ps.getBarCode());
        int packageSize = 9;
        ps.setPackageSize(packageSize);
        Assert.assertEquals((long)packageSize, (long)ps.getPackageSize());
        String packageUnits = "BOX";
        ps.setPackageUnits(packageUnits);
        Assert.assertEquals((Object)packageUnits, (Object)ps.getPackageUnits());
        int minQuantity = 10;
        ps.setMinimumOrderQuantity(minQuantity);
        Assert.assertEquals((long)minQuantity, (long)ps.getMinimumOrderQuantity());
        int increment = 11;
        ps.setOrderQuantityIncrement(increment);
        Assert.assertEquals((long)increment, (long)ps.getOrderQuantityIncrement());
        int leadTime = 12;
        ps.setLeadTime(leadTime);
        Assert.assertEquals((long)leadTime, (long)ps.getLeadTime());
        String leadTimeUnits = "MONTHS";
        ps.setLeadTimeUnits(leadTimeUnits);
        Assert.assertEquals((Object)leadTimeUnits, (Object)ps.getLeadTimeUnits());
        BigDecimal listPrice = new BigDecimal("1");
        ps.setListPrice(listPrice);
        this.checkEquals(listPrice, ps.getListPrice());
        BigDecimal nettPrice = new BigDecimal("2");
        ps.setNettPrice(nettPrice);
        this.checkEquals(nettPrice, ps.getNettPrice());
        ps.setPreferred(false);
        Assert.assertFalse((boolean)ps.isPreferred());
    }
}

