/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.product.AbstractProductTest;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.rules.stock.StockRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestMerchandiseProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.product.TestServiceProductBuilder;
import org.openvpms.archetype.test.builder.product.TestUnitPriceBuilder;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.component.business.domain.im.common.IMObjectRelationship;
import org.openvpms.component.math.Weight;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.springframework.beans.factory.annotation.Autowired;

public class ProductRulesTestCase
extends AbstractProductTest {
    @Autowired
    private StockRules stockRules;
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;
    private ProductRules rules;

    @Test
    public void testCopy() {
        BigDecimal cost = new BigDecimal("14.5");
        BigDecimal price = new BigDecimal("31.90");
        BigDecimal listPrice = new BigDecimal("69.04");
        Party supplier = this.supplierFactory.createSupplier();
        Product linked = (Product)this.productFactory.newPriceTemplate().build();
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().addSpecies("CANINE")).newUnitPrice().cost(cost)).price(price)).add()).newDose().species("CANINE").weightRange(0, 10).rate(1).quantity(1).add().addPriceTemplate(linked)).build();
        Entity dose = (Entity)this.getBean((IMObject)product).getTarget("doses", Entity.class);
        ProductPrice unitPrice = (ProductPrice)product.getProductPrices().iterator().next();
        ProductSupplier ps = this.rules.createProductSupplier(product, supplier);
        ps.setPackageSize(500);
        ps.setListPrice(listPrice);
        ps.setAutoPriceUpdate(true);
        this.save((IMObject)product);
        Lookup species = this.lookupFactory.getSpecies("CANINE");
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        this.stockRules.updateStock(product, stockLocation, BigDecimal.TEN);
        String name = "Copy";
        Product copy = this.rules.copy(product, name);
        Assert.assertFalse((boolean)copy.isNew());
        Assert.assertNotEquals((long)product.getId(), (long)copy.getId());
        Assert.assertEquals((Object)product.getArchetype(), (Object)copy.getArchetype());
        Assert.assertEquals((Object)name, (Object)copy.getName());
        IMObjectBean copyBean = this.getBean((IMObject)copy);
        List doses = copyBean.getTargets("doses", Entity.class);
        Assert.assertEquals((long)1L, (long)doses.size());
        Assert.assertNotEquals(doses.get(0), (Object)dose);
        Lookup species2 = (Lookup)((Entity)doses.get(0)).getClassifications().iterator().next();
        Assert.assertEquals((long)species.getId(), (long)species2.getId());
        Assert.assertEquals((Object)copyBean.getTarget("stockLocations"), (Object)stockLocation);
        Set productPrices = copy.getProductPrices();
        Assert.assertEquals((long)1L, (long)productPrices.size());
        ProductPrice priceCopy = productPrices.toArray(new ProductPrice[0])[0];
        Assert.assertNotEquals((long)unitPrice.getId(), (long)priceCopy.getId());
        this.checkEquals(unitPrice.getPrice(), priceCopy.getPrice());
        this.checkEquals(cost, this.getBean((IMObject)priceCopy).getBigDecimal("cost"));
        ProductSupplier psCopy = this.rules.getProductSupplier(copy, supplier, null, ps.getPackageSize(), ps.getPackageUnits());
        Assert.assertNotNull((Object)psCopy);
        Assert.assertNotEquals((long)psCopy.getRelationship().getId(), (long)ps.getRelationship().getId());
        Assert.assertEquals((long)500L, (long)ps.getPackageSize());
        this.checkEquals(new BigDecimal("0.138"), ps.getCostPrice());
        Assert.assertTrue((boolean)ps.isAutoPriceUpdate());
        this.checkEquals(listPrice, ps.getListPrice());
        Assert.assertEquals((Object)supplier.getObjectReference(), (Object)psCopy.getSupplierRef());
        List linkedRefs = copyBean.getTargetRefs("linked");
        Assert.assertEquals((long)1L, (long)linkedRefs.size());
        Assert.assertEquals((Object)linked.getObjectReference(), linkedRefs.get(0));
        this.checkEquals(BigDecimal.ZERO, this.stockRules.getStock(copy, stockLocation));
    }

    @Test
    public void testCopyProductWithLocation() {
        Party location = this.practiceFactory.createLocation();
        Product product = (Product)((TestServiceProductBuilder)this.productFactory.newService().addLocations(location)).build();
        String name = "Copy";
        Product copy = this.rules.copy(product, name);
        Assert.assertNotEquals((long)product.getId(), (long)copy.getId());
        Assert.assertEquals((Object)product.getArchetype(), (Object)copy.getArchetype());
        Assert.assertEquals((Object)name, (Object)copy.getName());
        IMObjectBean copyBean = this.getBean((IMObject)copy);
        Assert.assertEquals((Object)copyBean.getTarget("locations"), (Object)location);
    }

    @Test
    public void testCopyProductWithMissingSupplierOnStockLocation() {
        Party supplier1 = this.supplierFactory.createSupplier();
        Party supplier2 = this.supplierFactory.createSupplier();
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Product product = (Product)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().newProductStockLocation().supplier(supplier1).stockLocation(stockLocation).add()).newProductSupplier().supplier(supplier1).add()).newProductSupplier().supplier(supplier2).preferred(true).add()).build();
        ProductSupplier ps1 = this.rules.getPreferredSupplier(product, stockLocation);
        Assert.assertNotNull((Object)ps1);
        Assert.assertEquals((Object)supplier1, (Object)ps1.getSupplier());
        this.remove((IMObject)ps1.getRelationship());
        this.remove((IMObject)supplier1);
        product = this.get(product);
        IMObjectRelationship relationship1 = this.stockRules.getStockRelationship(product, stockLocation);
        Assert.assertEquals((Object)supplier1.getObjectReference(), (Object)this.getBean((IMObject)relationship1).getReference("supplier"));
        Product copy = this.rules.copy(product);
        ProductSupplier ps2 = this.rules.getPreferredSupplier(copy, stockLocation);
        Assert.assertNotNull((Object)ps2);
        Assert.assertEquals((Object)supplier2, (Object)ps2.getSupplier());
        IMObjectRelationship relationship2 = this.stockRules.getStockRelationship(copy, stockLocation);
        Assert.assertNull((Object)this.getBean((IMObject)relationship2).getReference("supplier"));
    }

    @Test
    public void testGetDose() {
        Product product = (Product)this.productFactory.newMedication().concentration(2).newDose().species("CANINE").weightRange(0, 10).rate(1).quantity(1).add().newDose().species("FELINE").weightRange(0, 10).rate(2).quantity(2).add().newDose().weightRange(10, 20).rate(4).quantity(1).add().build();
        this.checkEquals(new BigDecimal("0.5"), this.rules.getDose(product, new Weight(1), "CANINE"));
        this.checkEquals(2, this.rules.getDose(product, new Weight(1), "FELINE"));
        this.checkEquals(new BigDecimal(20), this.rules.getDose(product, new Weight(10), "CANINE"));
        this.checkEquals(BigDecimal.ZERO, this.rules.getDose(product, new Weight(20), "FELINE"));
        this.checkEquals(BigDecimal.ZERO, this.rules.getDose(product, new Weight(1), null));
        this.checkEquals(new BigDecimal(20), this.rules.getDose(product, new Weight(10), null));
        this.checkEquals(BigDecimal.ZERO, this.rules.getDose(product, new Weight(20), null));
    }

    @Test
    public void testGetDoseRounding() {
        BigDecimal concentration = BigDecimal.valueOf(50L);
        Product product1 = (Product)this.productFactory.newMedication().concentration(concentration).newDose().weightRange(0, 100).rate(4).quantity(1).roundTo(0).add().build();
        Product product2 = (Product)this.productFactory.newMedication().concentration(concentration).newDose().weightRange(0, 100).rate(4).quantity(1).roundTo(1).add().build();
        Product product3 = (Product)this.productFactory.newMedication().concentration(concentration).newDose().weightRange(0, 100).rate(4).quantity(1).roundTo(2).add().build();
        Weight weight = new Weight(new BigDecimal("15.5"));
        this.checkEquals(1, this.rules.getDose(product1, weight, "CANINE"));
        this.checkEquals(new BigDecimal("1.2"), this.rules.getDose(product2, weight, "CANINE"));
        this.checkEquals(new BigDecimal("1.24"), this.rules.getDose(product3, weight, "CANINE"));
    }

    @Test
    public void testGetProductSuppliersForSupplierAndProduct() {
        Party supplier = this.supplierFactory.createSupplier();
        Product product1 = this.productFactory.createMedication();
        Product product2 = this.productFactory.createMedication();
        ProductSupplier p1rel1 = this.rules.createProductSupplier(product1, supplier);
        ProductSupplier p1rel2 = this.rules.createProductSupplier(product1, supplier);
        ProductSupplier p2rel1 = this.rules.createProductSupplier(product2, supplier);
        p1rel1.save();
        p1rel2.save();
        p2rel1.save();
        List relationships = this.rules.getProductSuppliers(product1, supplier);
        Assert.assertEquals((long)2L, (long)relationships.size());
        Assert.assertEquals((Object)p1rel1, relationships.get(0));
        Assert.assertEquals((Object)p1rel2, relationships.get(1));
        Assert.assertFalse((boolean)relationships.contains(p2rel1));
        this.deactivateRelationship(p1rel1);
        relationships = this.rules.getProductSuppliers(product1, supplier);
        Assert.assertEquals((long)1L, (long)relationships.size());
        Assert.assertFalse((boolean)relationships.contains(p1rel1));
        Assert.assertEquals((Object)p1rel2, relationships.get(0));
    }

    @Test
    public void testGetProductSupplier() {
        Party supplier = this.supplierFactory.createSupplier();
        Product product1 = this.productFactory.createMedication();
        Product product2 = this.productFactory.createMedication();
        Product product3 = this.productFactory.createMedication();
        ProductSupplier p1rel1 = this.rules.createProductSupplier(product1, supplier);
        ProductSupplier p1rel2 = this.rules.createProductSupplier(product1, supplier);
        ProductSupplier p2rel = this.rules.createProductSupplier(product2, supplier);
        ProductSupplier p3rel = this.rules.createProductSupplier(product3, supplier);
        Assert.assertEquals((long)0L, (long)p1rel1.getPackageSize());
        p1rel2.setPackageSize(3);
        p1rel2.setPackageUnits("AMPOULE");
        p2rel.setPackageSize(4);
        p2rel.setPackageUnits("PACKET");
        p3rel.setReorderCode("p3");
        p3rel.setPackageSize(4);
        p3rel.setPackageUnits("PACKET");
        ProductSupplier test1 = this.rules.getProductSupplier(product1, supplier, null, 4, "BOX");
        Assert.assertEquals((Object)p1rel1, (Object)test1);
        p1rel1.setPackageSize(4);
        p1rel1.setPackageUnits("BOX");
        Assert.assertEquals((Object)p1rel1, (Object)this.rules.getProductSupplier(product1, supplier, null, 4, "BOX"));
        Assert.assertEquals((Object)p1rel2, (Object)this.rules.getProductSupplier(product1, supplier, null, 3, "AMPOULE"));
        Assert.assertEquals((Object)p2rel, (Object)this.rules.getProductSupplier(product2, supplier, null, 4, "PACKET"));
        Assert.assertEquals((Object)p3rel, (Object)this.rules.getProductSupplier(product3, supplier, "p3", 4, "PACKET"));
        Assert.assertEquals((Object)p3rel, (Object)this.rules.getProductSupplier(product3, supplier, "p3", -1, null));
        Assert.assertEquals((Object)p1rel1, (Object)this.rules.getProductSupplier(product1, supplier, "foo", 4, "BOX"));
        Assert.assertEquals((Object)p1rel2, (Object)this.rules.getProductSupplier(product1, supplier, "bar", 3, "AMPOULE"));
        Assert.assertEquals((Object)p2rel, (Object)this.rules.getProductSupplier(product2, supplier, "zoo", 4, "PACKET"));
        Assert.assertEquals((Object)p3rel, (Object)this.rules.getProductSupplier(product3, supplier, "p?", 4, "PACKET"));
        Assert.assertEquals((Object)p1rel1, (Object)this.rules.getProductSupplier(product1, supplier, "foo", 4, null));
        Assert.assertEquals((Object)p1rel2, (Object)this.rules.getProductSupplier(product1, supplier, "bar", 3, null));
        Assert.assertEquals((Object)p2rel, (Object)this.rules.getProductSupplier(product2, supplier, "zoo", 4, null));
        Assert.assertEquals((Object)p3rel, (Object)this.rules.getProductSupplier(product3, supplier, "p?", 4, null));
        Assert.assertNull((Object)this.rules.getProductSupplier(product1, supplier, "foo", 5, "BOX"));
        Assert.assertNull((Object)this.rules.getProductSupplier(product1, supplier, "bar", 5, "PACKET"));
        Assert.assertNull((Object)this.rules.getProductSupplier(product2, supplier, "zoo", 5, "PACKET"));
        Assert.assertNull((Object)this.rules.getProductSupplier(product2, supplier, null, 5, null));
    }

    @Test
    public void testGetProductSuppliersForProduct() {
        Party supplier1 = this.supplierFactory.createSupplier();
        Party supplier2 = this.supplierFactory.createSupplier();
        Product product = this.productFactory.createMedication();
        ProductSupplier rel1 = this.rules.createProductSupplier(product, supplier1);
        ProductSupplier rel2 = this.rules.createProductSupplier(product, supplier2);
        rel1.save();
        rel2.save();
        List relationships = this.rules.getProductSuppliers(product);
        Assert.assertEquals((long)2L, (long)relationships.size());
        Assert.assertEquals((Object)rel1, relationships.get(0));
        Assert.assertEquals((Object)rel2, relationships.get(1));
        this.deactivateRelationship(rel1);
        relationships = this.rules.getProductSuppliers(product);
        Assert.assertEquals((long)1L, (long)relationships.size());
        Assert.assertEquals((Object)rel2, relationships.get(0));
    }

    @Test
    public void testGetBatches() {
        Product product = this.productFactory.createMedication();
        Party manufacturer1 = this.supplierFactory.createManufacturer();
        Party manufacturer2 = this.supplierFactory.createManufacturer();
        Party manufacturer3 = this.supplierFactory.createManufacturer();
        List batches = this.rules.getBatches(product, null, null, null);
        Assert.assertEquals((long)0L, (long)batches.size());
        Entity batch1 = this.rules.createBatch(product, "aa", TestHelper.getDatetime("2014-06-01 10:00:00"), manufacturer1);
        Entity batch2 = this.rules.createBatch(product, "ab", TestHelper.getDatetime("2014-07-01 07:00:00"), manufacturer2);
        Entity batch3 = this.rules.createBatch(product, "ac", TestHelper.getDatetime("2014-08-01 15:00:00"), manufacturer3);
        this.save((IMObject[])new Entity[]{batch1, batch2, batch3});
        this.checkBatches(this.rules.getBatches(product, "a*", null, null), batch1, batch2, batch3);
        this.checkBatches(this.rules.getBatches(product, "a*", TestHelper.getDate("2014-06-01"), null), batch1);
        this.checkBatches(this.rules.getBatches(product, "a*", null, manufacturer1), batch1);
        this.checkBatches(this.rules.getBatches(product, null, null, manufacturer2), batch2);
        this.checkBatches(this.rules.getBatches(product, "ac", null, manufacturer3), batch3);
    }

    @Test
    public void testCreateBatch() {
        Product product = this.productFactory.createMedication();
        Date expiry = TestHelper.getDate("2014-06-14");
        Party manufacturer = this.supplierFactory.createManufacturer();
        String batchNumber = "12345";
        Entity batch = this.rules.createBatch(product, batchNumber, expiry, manufacturer);
        Assert.assertTrue((boolean)batch.isNew());
        this.save((IMObject)batch);
        batch = this.get(batch);
        IMObjectBean bean = this.getBean((IMObject)batch);
        Assert.assertEquals((Object)batchNumber, (Object)batch.getName());
        Assert.assertEquals((Object)product.getObjectReference(), (Object)bean.getTargetRef("product"));
        Assert.assertEquals((Object)expiry, (Object)this.rules.getBatchExpiry(batch));
        Assert.assertEquals((Object)manufacturer.getObjectReference(), (Object)bean.getTargetRef("manufacturer"));
    }

    @Test
    public void testCanUseProductAtLocation() {
        Product medication = this.productFactory.createMedication();
        Product merchandise = this.productFactory.createMerchandise();
        Product service = this.productFactory.createService();
        Product template = this.productFactory.createTemplate();
        Party location = this.practiceFactory.createLocation();
        Assert.assertTrue((boolean)this.rules.canUseProductAtLocation(medication, location));
        Assert.assertTrue((boolean)this.rules.canUseProductAtLocation(merchandise, location));
        Assert.assertTrue((boolean)this.rules.canUseProductAtLocation(service, location));
        Assert.assertTrue((boolean)this.rules.canUseProductAtLocation(template, location));
        ProductTestHelper.addLocationExclusion(service, location);
        ProductTestHelper.addLocationExclusion(template, location);
        Assert.assertFalse((boolean)this.rules.canUseProductAtLocation(service, location));
        Assert.assertFalse((boolean)this.rules.canUseProductAtLocation(template, location));
    }

    @Test
    public void testIsRestricted() {
        Product medication1 = (Product)this.productFactory.newMedication().drugSchedule(false).build();
        Product medication2 = (Product)this.productFactory.newMedication().drugSchedule(true).build();
        Product medication3 = this.productFactory.createMedication();
        Product merchandise = this.productFactory.createMerchandise();
        Product service = this.productFactory.createService();
        Product template = this.productFactory.createTemplate();
        Assert.assertFalse((boolean)this.rules.isRestricted(medication1));
        Assert.assertTrue((boolean)this.rules.isRestricted(medication2));
        Assert.assertFalse((boolean)this.rules.isRestricted(medication3));
        Assert.assertFalse((boolean)this.rules.isRestricted(merchandise));
        Assert.assertFalse((boolean)this.rules.isRestricted(service));
        Assert.assertFalse((boolean)this.rules.isRestricted(template));
    }

    @Before
    public void setUp() {
        this.rules = new ProductRules(this.getArchetypeService(), this.getLookupService());
    }

    private void checkBatches(List<Entity> matches, Entity ... batches) {
        Assert.assertEquals((long)batches.length, (long)matches.size());
        for (int i = 0; i < batches.length; ++i) {
            Assert.assertEquals((Object)batches[i], (Object)matches.get(i));
        }
    }

    private void deactivateRelationship(ProductSupplier relationship) {
        relationship.getRelationship().setActive(false);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

