/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.math.Currencies;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.product.AbstractProductTest;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.ProductPriceTestHelper;
import org.openvpms.archetype.rules.product.ServiceRatio;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestFixedPriceBuilder;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestPriceTemplateProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.product.TestUnitPriceBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class ProductPriceRulesTestCase
extends AbstractProductTest {
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    private Party practice;
    private Currency currency;
    private ProductPriceRules rules;

    @Before
    public void setUp() {
        this.practice = (Party)this.practiceFactory.newPractice().addTaxType(BigDecimal.TEN).build();
        this.rules = new ProductPriceRules((ArchetypeService)this.getArchetypeService());
        IMObjectBean bean = this.getBean((IMObject)this.practice);
        Currencies currencies = new Currencies(this.getArchetypeService(), this.getLookupService());
        this.currency = currencies.getCurrency(bean.getString("currency"));
    }

    @Test
    public void testGetProductPrice() {
        this.checkProductPrice(this.createMedication(), false);
        this.checkProductPrice(this.createMerchandise(), false);
        this.checkProductPrice(this.createService(), false);
        this.checkProductPrice(this.createPriceTemplate(), false);
        this.checkProductPrice(this.createTemplate(), false);
    }

    @Test
    public void testGetProductPriceWithPriceGroups() {
        this.checkProductPriceWithPriceGroups(this.createMedication(), false);
        this.checkProductPriceWithPriceGroups(this.createMerchandise(), false);
        this.checkProductPriceWithPriceGroups(this.createService(), false);
        this.checkProductPriceWithPriceGroups(this.createPriceTemplate(), false);
        this.checkProductPriceWithPriceGroups(this.createTemplate(), false);
    }

    @Test
    public void testGetProductPriceForProductWithPriceTemplate() {
        this.checkProductPrice(this.createMedication(), true);
        this.checkProductPrice(this.createMerchandise(), true);
        this.checkProductPrice(this.createService(), true);
    }

    @Test
    public void testGetProductPriceWithPriceGroupsForProductWithPriceTemplate() {
        this.checkProductPriceWithPriceGroups(this.createMedication(), true);
        this.checkProductPriceWithPriceGroups(this.createMerchandise(), true);
        this.checkProductPriceWithPriceGroups(this.createService(), true);
    }

    @Test
    public void testGetProductPriceForPrice() {
        this.checkGetProductPriceForPrice(this.createMedication(), false);
        this.checkGetProductPriceForPrice(this.createMerchandise(), false);
        this.checkGetProductPriceForPrice(this.createService(), false);
        this.checkGetProductPriceForPrice(this.createPriceTemplate(), false);
        this.checkGetProductPriceForPrice(this.createTemplate(), false);
    }

    @Test
    public void testGetProductPriceForPriceForProductWithPriceTemplate() {
        this.checkGetProductPriceForPrice(this.createMedication(), true);
        this.checkGetProductPriceForPrice(this.createMerchandise(), true);
        this.checkGetProductPriceForPrice(this.createService(), true);
    }

    @Test
    public void testGetProductPriceForPriceWithPriceGroups() {
        this.checkGetProductPriceForPriceWithPriceGroups(this.createMedication(), false);
        this.checkGetProductPriceForPriceWithPriceGroups(this.createMerchandise(), false);
        this.checkGetProductPriceForPriceWithPriceGroups(this.createService(), false);
        this.checkGetProductPriceForPriceWithPriceGroups(this.createPriceTemplate(), false);
        this.checkGetProductPriceForPriceWithPriceGroups(this.createTemplate(), false);
    }

    @Test
    public void testGetProductPriceForPriceWithPriceGroupsForProductWithPriceTemplate() {
        this.checkGetProductPriceForPriceWithPriceGroups(this.createMedication(), true);
        this.checkGetProductPriceForPriceWithPriceGroups(this.createMerchandise(), true);
        this.checkGetProductPriceForPriceWithPriceGroups(this.createService(), true);
    }

    @Test
    public void testGetProductPrices() {
        this.checkGetProductPrices(this.createMedication());
        this.checkGetProductPrices(this.createMerchandise());
        this.checkGetProductPrices(this.createService());
        this.checkGetProductPrices(this.createPriceTemplate());
        this.checkGetProductPrices(this.createTemplate());
    }

    @Test
    public void testGetProductPricesForProductWithPriceTemplate() {
        this.checkGetProductPricesForProductWithPriceTemplate(this.createMedication());
        this.checkGetProductPricesForProductWithPriceTemplate(this.createMerchandise());
        this.checkGetProductPricesForProductWithPriceTemplate(this.createService());
    }

    @Test
    public void testGetProductPricesWithPriceGroups() {
        this.checkGetProductPricesWithPriceGroups(this.createMedication());
        this.checkGetProductPricesWithPriceGroups(this.createMerchandise());
        this.checkGetProductPricesWithPriceGroups(this.createService());
        this.checkGetProductPricesWithPriceGroups(this.createPriceTemplate());
        this.checkGetProductPricesWithPriceGroups(this.createTemplate());
    }

    @Test
    public void testGetProductPricesWithPriceGroupsForProductWithPriceTemplate() {
        this.checkGetProductPricesWithPriceGroupsForProductWithPriceTemplate(this.createMedication());
        this.checkGetProductPricesWithPriceGroupsForProductWithPriceTemplate(this.createMerchandise());
        this.checkGetProductPricesWithPriceGroupsForProductWithPriceTemplate(this.createService());
    }

    @Test
    public void testDefaultProductPriceForPriceGroup() {
        Lookup groupA = this.productFactory.createPricingGroup("A");
        Date today = DateRules.getToday();
        ProductPrice price1 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().cost(0)).markup(0)).price(0)).maxDiscount(0)).fromDate(today)).toDate(null)).defaultPrice(true).build();
        ProductPrice price2 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().cost(1)).markup(0)).price(0)).maxDiscount(0)).fromDate(today)).toDate(null)).defaultPrice(false).build();
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().addPrice(price1)).addPrice(price2)).build();
        ProductPrice price = this.rules.getProductPrice(product, "productPrice.fixedPrice", today, null);
        Assert.assertEquals((Object)price, (Object)price1);
        price = this.rules.getProductPrice(product, "productPrice.fixedPrice", today, groupA);
        Assert.assertEquals((Object)price, (Object)price1);
        price2.addClassification(groupA);
        price = this.rules.getProductPrice(product, "productPrice.fixedPrice", today, groupA);
        Assert.assertEquals((Object)price, (Object)price2);
        price = this.rules.getProductPrice(product, "productPrice.fixedPrice", today, null);
        Assert.assertEquals((Object)price, (Object)price1);
        this.productFactory.updateFixedPrice(price2).defaultPrice(true).build();
        price = this.rules.getProductPrice(product, "productPrice.fixedPrice", today, groupA);
        Assert.assertEquals((Object)price, (Object)price2);
    }

    @Test
    public void testGetTaxIncPrice() {
        BigDecimal taxRate = new BigDecimal("8.25");
        this.practice = (Party)this.practiceFactory.updatePractice(this.practice).taxTypes(taxRate).build();
        ProductPrice unitPrice = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price("16.665")).cost("8.33")).markup("100.10")).maxDiscount(50)).fromDate(DateRules.getToday())).toDate(null)).build();
        Product product = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().addPrice(unitPrice)).build();
        BigDecimal price1 = this.rules.getTaxIncPrice(unitPrice.getPrice(), product, this.practice, this.currency);
        this.checkEquals(new BigDecimal("18.04"), price1);
        BigDecimal price2 = this.rules.getTaxIncPrice(unitPrice.getPrice(), taxRate, this.currency);
        this.checkEquals(new BigDecimal("18.04"), price2);
    }

    @Test
    public void testGetTaxIncPriceWithPriceRounding() {
        java.util.Currency AUD = java.util.Currency.getInstance("AUD");
        this.practice = (Party)this.practiceFactory.updatePractice(this.practice).removeTaxTypes().build();
        Product product = this.productFactory.createMedication();
        BigDecimal minDenomination = new BigDecimal("0.05");
        BigDecimal minPrice = new BigDecimal("0.20");
        Currency currency1 = new Currency(AUD, RoundingMode.HALF_UP, minDenomination, minPrice);
        this.checkGetTaxIncPrice("0.18", "0.20", product, currency1);
        this.checkGetTaxIncPrice("0.30", "0.40", product, currency1);
        this.checkGetTaxIncPrice("0.44", "0.40", product, currency1);
        this.checkGetTaxIncPrice("0.50", "0.60", product, currency1);
        this.checkGetTaxIncPrice("1.50", "1.60", product, currency1);
        this.checkGetTaxIncPrice("2.50", "2.60", product, currency1);
        Currency currency2 = new Currency(AUD, RoundingMode.HALF_DOWN, minDenomination, minPrice);
        this.checkGetTaxIncPrice("0.18", "0.20", product, currency2);
        this.checkGetTaxIncPrice("0.30", "0.20", product, currency2);
        this.checkGetTaxIncPrice("0.44", "0.40", product, currency2);
        this.checkGetTaxIncPrice("0.50", "0.40", product, currency2);
        this.checkGetTaxIncPrice("1.50", "1.40", product, currency2);
        this.checkGetTaxIncPrice("2.50", "2.40", product, currency2);
        Currency currency3 = new Currency(AUD, RoundingMode.HALF_EVEN, minDenomination, minPrice);
        this.checkGetTaxIncPrice("0.18", "0.20", product, currency3);
        this.checkGetTaxIncPrice("0.30", "0.40", product, currency3);
        this.checkGetTaxIncPrice("0.44", "0.40", product, currency3);
        this.checkGetTaxIncPrice("0.50", "0.40", product, currency3);
        this.checkGetTaxIncPrice("1.50", "1.60", product, currency3);
        this.checkGetTaxIncPrice("2.50", "2.40", product, currency3);
    }

    @Test
    public void testGetMarkup() {
        BigDecimal cost = BigDecimal.ONE;
        BigDecimal price = new BigDecimal("2");
        BigDecimal markup = this.rules.getMarkup(cost, price);
        this.checkEquals(BigDecimal.valueOf(100L), markup);
    }

    @Test
    public void testGetMaxDiscount() {
        ProductPrice price = ((TestFixedPriceBuilder)this.productFactory.newFixedPrice().dateRange(new Date(), new Date())).build();
        this.checkEquals(new BigDecimal(100), this.rules.getMaxDiscount(price));
        ((TestFixedPriceBuilder)this.productFactory.updateFixedPrice(price).maxDiscount(10)).build();
        this.checkEquals(BigDecimal.TEN, this.rules.getMaxDiscount(price));
    }

    @Test
    public void testUpdateUnitPrices() {
        BigDecimal cost = BigDecimal.ONE;
        BigDecimal markup = BigDecimal.valueOf(50L);
        BigDecimal price = new BigDecimal("1.5");
        BigDecimal maxDiscount = BigDecimal.valueOf(60L);
        Date date1 = DateRules.getYesterday();
        Date date2 = DateRules.getToday();
        Date date3 = DateRules.getTomorrow();
        Lookup groupA = this.productFactory.createPricingGroup("A");
        Lookup groupB = this.productFactory.createPricingGroup("B");
        Lookup groupC = this.productFactory.createPricingGroup("C");
        ProductPrice unit1 = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(price)).cost(cost)).markup(markup)).maxDiscount(maxDiscount)).dateRange(null, date1)).build();
        ProductPrice unit2 = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(price)).cost(cost)).markup(markup)).maxDiscount(maxDiscount)).dateRange(date2, null)).pricingGroups(groupA)).build();
        ProductPrice unit3 = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(price)).cost(cost)).markup(markup)).maxDiscount(maxDiscount)).allDates()).pricingGroups(groupB)).build();
        ProductPrice unit4 = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(price)).cost(cost)).markup(markup)).maxDiscount(maxDiscount)).dateRange(date3, null)).pricingGroups(groupC)).build();
        final Date now = DateRules.getDate((Date)date2, (int)12, (DateUnits)DateUnits.HOURS);
        ProductPriceRules rules = new ProductPriceRules((ArchetypeService)this.getArchetypeService()){

            protected Date getNow() {
                return now;
            }
        };
        Product product = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().addPrices(unit1, unit2, unit3, unit4)).build();
        BigDecimal newCost = BigDecimal.valueOf(2L);
        BigDecimal newPrice = BigDecimal.valueOf(3L);
        List updated1 = rules.updateUnitPrices(product, newCost, false, this.currency);
        Assert.assertEquals((long)4L, (long)updated1.size());
        Assert.assertFalse((boolean)updated1.contains(unit1));
        Assert.assertTrue((boolean)updated1.contains(unit2));
        Assert.assertTrue((boolean)updated1.contains(unit3));
        Assert.assertFalse((boolean)updated1.contains(unit4));
        ProductPriceTestHelper.checkPrice(unit1, price, cost, markup, maxDiscount, unit1.getFromDate(), unit1.getToDate(), null);
        ProductPriceTestHelper.checkPrice(unit2, price, cost, markup, maxDiscount, unit2.getFromDate(), now, groupA);
        ProductPriceTestHelper.checkPrice(unit3, price, cost, markup, maxDiscount, unit3.getFromDate(), now, groupB);
        ProductPriceTestHelper.checkPrice(unit4, price, cost, markup, maxDiscount, unit4.getFromDate(), unit4.getToDate(), groupC);
        this.checkPrice(updated1, cost, markup, price, maxDiscount, unit2.getFromDate(), now, groupA, unit2);
        ProductPrice unit5 = this.checkPrice(updated1, newCost, markup, newPrice, maxDiscount, now, null, groupA, null);
        this.checkPrice(updated1, cost, markup, price, maxDiscount, unit3.getFromDate(), now, groupB, unit3);
        ProductPrice unit6 = this.checkPrice(updated1, newCost, markup, newPrice, maxDiscount, now, null, groupB, null);
        List updated2 = rules.updateUnitPrices(product, BigDecimal.ONE, true, this.currency);
        Assert.assertEquals((long)0L, (long)updated2.size());
        ProductPriceTestHelper.checkPrice(unit1, price, cost, markup, maxDiscount, unit1.getFromDate(), unit1.getToDate(), null);
        ProductPriceTestHelper.checkPrice(unit2, price, cost, markup, maxDiscount, unit2.getFromDate(), now, groupA);
        ProductPriceTestHelper.checkPrice(unit3, price, cost, markup, maxDiscount, unit3.getFromDate(), now, groupB);
        ProductPriceTestHelper.checkPrice(unit4, price, cost, markup, maxDiscount, unit4.getFromDate(), unit4.getToDate(), groupC);
        ProductPriceTestHelper.checkPrice(unit5, newPrice, newCost, markup, maxDiscount, now, null, groupA);
        ProductPriceTestHelper.checkPrice(unit6, newPrice, newCost, markup, maxDiscount, now, null, groupB);
    }

    @Test
    public void testUpdateUnitPricesForUnsavedPrices() {
        BigDecimal cost1 = BigDecimal.ONE;
        BigDecimal markup = BigDecimal.valueOf(50L);
        BigDecimal price1 = new BigDecimal("1.5");
        BigDecimal maxDiscount = BigDecimal.valueOf(60L);
        Date from = DateRules.getToday();
        ProductPrice unit = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newMedication().newUnitPrice().price(price1)).cost(cost1)).markup(markup)).maxDiscount(maxDiscount)).dateRange(from, null)).build();
        Product product = this.productFactory.createMedication();
        product.addProductPrice(unit);
        BigDecimal cost2 = BigDecimal.valueOf(2L);
        BigDecimal price2 = BigDecimal.valueOf(3L);
        List updated1 = this.rules.updateUnitPrices(product, cost2, false, this.currency);
        Assert.assertEquals((long)1L, (long)updated1.size());
        ProductPriceTestHelper.checkPrice(unit, price2, cost2, markup, maxDiscount, from, null, null);
        this.checkPrice(updated1, cost2, markup, price2, maxDiscount, from, null, null, unit);
        List updated2 = this.rules.updateUnitPrices(product, BigDecimal.ONE, true, this.currency);
        Assert.assertEquals((long)0L, (long)updated2.size());
        BigDecimal cost3 = BigDecimal.valueOf(4L);
        BigDecimal price3 = BigDecimal.valueOf(6L);
        List updated3 = this.rules.updateUnitPrices(product, cost3, true, this.currency);
        Assert.assertEquals((long)1L, (long)updated3.size());
        ProductPriceTestHelper.checkPrice(unit, price3, cost3, markup, maxDiscount, from, null, null);
        this.checkPrice(updated1, cost3, markup, price3, maxDiscount, from, null, null, unit);
    }

    @Test
    public void testCalcMaxDiscount() {
        this.checkEquals(ProductPriceRules.DEFAULT_MAX_DISCOUNT, this.rules.getMaxDiscount(BigDecimal.ZERO));
        this.checkEquals(new BigDecimal("33.3"), this.rules.getMaxDiscount(BigDecimal.valueOf(50L)));
        this.checkEquals(new BigDecimal(50), this.rules.getMaxDiscount(BigDecimal.valueOf(100L)));
        this.checkEquals(new BigDecimal("66.7"), this.rules.getMaxDiscount(BigDecimal.valueOf(200L)));
    }

    @Test
    public void testGetServiceRatioForLocation() {
        Product product1 = this.productFactory.createMedication();
        Product product2 = this.productFactory.createMedication();
        Entity department = this.practiceFactory.createDepartment();
        Party location = this.practiceFactory.createLocation();
        Entity productType1 = this.productFactory.createProductType();
        Entity productType2 = this.productFactory.createProductType();
        this.checkNoServiceRatio(product1, null, location);
        this.checkNoServiceRatio(product2, null, location);
        this.checkNoServiceRatio(product1, department, location);
        this.checkNoServiceRatio(product2, department, location);
        ((TestMedicationProductBuilder)this.productFactory.updateMedication(product1).type(productType1)).build();
        ((TestMedicationProductBuilder)this.productFactory.updateMedication(product2).type(productType2)).build();
        this.checkNoServiceRatio(product1, null, location);
        this.checkNoServiceRatio(product2, null, location);
        this.checkNoServiceRatio(product1, department, location);
        this.checkNoServiceRatio(product2, department, location);
        Entity calendar = this.productFactory.createServiceRatioCalendar();
        BigDecimal ratioA = new BigDecimal("1.1");
        BigDecimal ratioB = new BigDecimal("1.2");
        BigDecimal ratioC = new BigDecimal("1.3");
        BigDecimal ratioD = new BigDecimal("1.4");
        this.practiceFactory.updateDepartment(department).addServiceRatio(productType1, ratioA, calendar).addServiceRatio(productType2, ratioB).build();
        this.practiceFactory.updateLocation(location).addServiceRatio(productType1, ratioC, calendar).addServiceRatio(productType2, ratioD).build();
        this.checkServiceRatio(product1, department, location, ratioA, calendar);
        this.checkServiceRatio(product2, department, location, ratioB, null);
        this.checkServiceRatio(product1, null, location, ratioC, calendar);
        this.checkServiceRatio(product2, null, location, ratioD, null);
    }

    @Test
    public void testCopy() {
        Lookup groupA = this.productFactory.createPricingGroup("A");
        Lookup groupB = this.productFactory.createPricingGroup("B");
        BigDecimal price = BigDecimal.TEN;
        BigDecimal cost = BigDecimal.ONE;
        BigDecimal markup = BigDecimal.valueOf(900L);
        BigDecimal maxDiscount = BigDecimal.valueOf(90L);
        Date fromDate = DateRules.getYesterday();
        Date toDate = DateRules.getTomorrow();
        ProductPrice fixed1 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(price)).cost(cost)).markup(markup)).maxDiscount(maxDiscount)).allDates()).defaultPrice(true).notes("notes")).pricingGroups(groupA)).build();
        ProductPrice fixed2 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(price)).cost(cost)).markup(markup)).maxDiscount(maxDiscount)).dateRange(fromDate, toDate)).defaultPrice(false).pricingGroups(groupB)).build();
        ProductPrice unit1 = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(price)).cost(cost)).markup(markup)).maxDiscount(maxDiscount)).allDates()).pricingGroups(groupA)).build();
        ProductPrice unit2 = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(price)).cost(cost)).markup(markup)).maxDiscount(maxDiscount)).dateRange(fromDate, toDate)).pricingGroups(groupB)).build();
        ((TestMedicationProductBuilder)this.productFactory.newMedication().addPrices(fixed1, fixed2, unit1, unit2)).build();
        this.checkCopy(fixed1);
        this.checkCopy(fixed2);
        this.checkCopy(unit1);
        this.checkCopy(unit2);
    }

    @Test
    public void testCopyAndClose() {
        Lookup groupA = this.productFactory.createPricingGroup("A");
        Lookup groupB = this.productFactory.createPricingGroup("A");
        BigDecimal price = BigDecimal.TEN;
        BigDecimal cost = BigDecimal.ONE;
        BigDecimal markup = BigDecimal.valueOf(900L);
        BigDecimal maxDiscount = BigDecimal.valueOf(90L);
        Date fromDate = DateRules.getYesterday();
        Date toDate = DateRules.getTomorrow();
        ProductPrice fixed1 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(price)).cost(cost)).markup(markup)).maxDiscount(maxDiscount)).allDates()).defaultPrice(true).pricingGroups(groupA)).notes("Some notes")).build();
        ProductPrice fixed2 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(price)).cost(cost)).markup(markup)).maxDiscount(maxDiscount)).dateRange(fromDate, toDate)).defaultPrice(false).pricingGroups(groupB)).build();
        ProductPrice unit1 = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(price)).cost(cost)).markup(markup)).maxDiscount(maxDiscount)).allDates()).pricingGroups(groupA)).build();
        ProductPrice unit2 = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(price)).cost(cost)).markup(markup)).maxDiscount(maxDiscount)).dateRange(fromDate, toDate)).pricingGroups(groupB)).build();
        ((TestMedicationProductBuilder)this.productFactory.newMedication().addPrices(fixed1, fixed2, unit1, unit2)).build();
        this.checkCopyAndClose(fixed1);
        this.checkCopyAndClose(fixed2);
        this.checkCopyAndClose(unit1);
        this.checkCopyAndClose(unit2);
    }

    private void checkNoServiceRatio(Product product, Entity department, Party location) {
        this.checkServiceRatio(product, department, location, null, null);
    }

    private void checkServiceRatio(Product product, Entity department, Party location, BigDecimal ratio, Entity calendar) {
        ServiceRatio actual = this.rules.getServiceRatio(product, department, location);
        if (ratio == null) {
            Assert.assertNull((Object)actual);
            Assert.assertNull((Object)calendar);
        } else {
            this.checkEquals(ratio, actual.getRatio());
            if (calendar != null) {
                Assert.assertEquals((Object)calendar.getObjectReference(), (Object)actual.getCalendar());
            } else {
                Assert.assertNull((Object)actual.getCalendar());
            }
        }
    }

    private void checkCopy(ProductPrice existing) {
        IMObjectBean bean = this.getBean((IMObject)existing);
        Lookup group = (Lookup)bean.getObject("pricingGroups", Lookup.class);
        Date from = existing.getFromDate();
        Date to = existing.getToDate();
        BigDecimal price = existing.getPrice();
        BigDecimal cost = bean.getBigDecimal("cost");
        BigDecimal markup = bean.getBigDecimal("markup");
        BigDecimal maxDiscount = bean.getBigDecimal("maxDiscount");
        Date tomorrow = DateRules.getTomorrow();
        ProductPrice copy = this.rules.copy(existing, tomorrow);
        Assert.assertTrue((boolean)copy.isNew());
        Assert.assertEquals((Object)existing.getArchetype(), (Object)copy.getArchetype());
        Assert.assertNull((Object)copy.getProduct());
        ProductPriceTestHelper.checkPrice(existing, price, cost, markup, maxDiscount, from, to, group);
        ProductPriceTestHelper.checkPrice(copy, price, cost, markup, maxDiscount, tomorrow, null, group);
        IMObjectBean copyBean = this.getBean((IMObject)copy);
        Assert.assertEquals((Object)bean.getBoolean("fixed"), (Object)copyBean.getBoolean("fixed"));
        Assert.assertNull((Object)copyBean.getString("notes"));
    }

    private void checkCopyAndClose(ProductPrice existing) {
        IMObjectBean bean = this.getBean((IMObject)existing);
        Lookup group = (Lookup)bean.getObject("pricingGroups", Lookup.class);
        Date from = existing.getFromDate();
        BigDecimal price = existing.getPrice();
        BigDecimal cost = bean.getBigDecimal("cost");
        BigDecimal markup = bean.getBigDecimal("markup");
        BigDecimal maxDiscount = bean.getBigDecimal("maxDiscount");
        Date tomorrow = DateRules.getTomorrow();
        ProductPrice copy = this.rules.copyAndClose(existing, tomorrow);
        Assert.assertTrue((boolean)copy.isNew());
        Assert.assertEquals((Object)existing.getArchetype(), (Object)copy.getArchetype());
        Assert.assertNull((Object)copy.getProduct());
        ProductPriceTestHelper.checkPrice(existing, price, cost, markup, maxDiscount, from, tomorrow, group);
        ProductPriceTestHelper.checkPrice(copy, price, cost, markup, maxDiscount, tomorrow, null, group);
        IMObjectBean copyBean = this.getBean((IMObject)copy);
        Assert.assertEquals((Object)bean.getBoolean("fixed"), (Object)copyBean.getBoolean("fixed"));
        Assert.assertNull((Object)copyBean.getString("notes"));
    }

    private ProductPrice checkPrice(List<ProductPrice> prices, BigDecimal cost, BigDecimal markup, BigDecimal price, BigDecimal maxDiscount, Date from, Date to, Lookup pricingGroup, ProductPrice expected) {
        ProductPrice match = ProductPriceTestHelper.checkPrice(prices, price, cost, markup, maxDiscount, from, to, pricingGroup);
        if (expected != null) {
            Assert.assertEquals((Object)expected, (Object)match);
        } else {
            Assert.assertTrue((boolean)match.isNew());
            Assert.assertNull((Object)match.getProduct());
        }
        return match;
    }

    private void checkProductPrice(Product product, boolean usePriceTemplate) {
        ProductPrice fixed1 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-02-01")).defaultPrice(false).build();
        ProductPrice fixed2 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().dateRange("2008-02-01", "2009-01-01")).price(1)).defaultPrice(false).build();
        ProductPrice fixed3 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-03-01", null)).defaultPrice(true).build();
        ProductPrice unit1 = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(1)).dateRange("2008-01-01", "2008-01-11")).build();
        ProductPrice unit2 = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(1)).dateRange("2008-02-01", null)).build();
        Assert.assertNull((Object)this.rules.getProductPrice(product, "productPrice.fixedPrice", new Date(), null));
        Assert.assertNull((Object)this.rules.getProductPrice(product, "productPrice.unitPrice", new Date(), null));
        ((TestMedicationProductBuilder)this.productFactory.updateMedication(product).addPrices(fixed1, fixed2, unit1, unit2)).build();
        this.checkPrice(null, "productPrice.fixedPrice", "2007-01-01", product, null);
        this.checkPrice(fixed1, "productPrice.fixedPrice", "2008-01-01", product, null);
        this.checkPrice(fixed1, "productPrice.fixedPrice", "2008-01-31", product, null);
        this.checkPrice(fixed2, "productPrice.fixedPrice", "2008-02-01", product, null);
        this.checkPrice(fixed2, "productPrice.fixedPrice", "2008-12-31", product, null);
        this.checkPrice(null, "productPrice.fixedPrice", "2009-01-01", product, null);
        this.checkPrice(null, "productPrice.unitPrice", "2007-12-31", product, null);
        this.checkPrice(unit1, "productPrice.unitPrice", "2008-01-01", product, null);
        this.checkPrice(unit1, "productPrice.unitPrice", "2008-01-10", product, null);
        this.checkPrice(null, "productPrice.unitPrice", "2008-01-11", product, null);
        this.checkPrice(unit2, "productPrice.unitPrice", "2008-02-01", product, null);
        this.checkPrice(unit2, "productPrice.unitPrice", "2010-02-01", product, null);
        if (usePriceTemplate) {
            Product priceTemplate = (Product)((TestPriceTemplateProductBuilder)this.productFactory.newPriceTemplate().addPrices(fixed3)).build();
            ((TestMedicationProductBuilder)this.productFactory.updateMedication(product).addPriceTemplate(priceTemplate, "2008-01-01", null)).build();
            this.checkPrice(fixed2, "productPrice.fixedPrice", "2008-02-01", product, null);
            this.checkPrice(fixed3, "productPrice.fixedPrice", "2008-03-01", product, null);
            priceTemplate.setActive(false);
            this.save((IMObject)priceTemplate);
            this.checkPrice(fixed2, "productPrice.fixedPrice", "2008-03-01", product, null);
        }
    }

    private void checkProductPriceWithPriceGroups(Product product, boolean usePriceTemplate) {
        Lookup groupA = this.productFactory.createPricingGroup("A");
        Lookup groupB = this.productFactory.createPricingGroup("B");
        ProductPrice fixed1A = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-02-01")).defaultPrice(false).pricingGroups(groupA)).build();
        ProductPrice fixed1B = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-02-01")).defaultPrice(false).pricingGroups(groupB)).build();
        ProductPrice fixed1C = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-02-01")).defaultPrice(false).build();
        ProductPrice fixed2A = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-02-01", "2009-01-01")).defaultPrice(false).pricingGroups(groupA)).build();
        ProductPrice fixed2B = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-02-01", "2009-01-01")).defaultPrice(false).pricingGroups(groupB)).build();
        ProductPrice fixed2C = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-02-01", "2009-01-01")).defaultPrice(false).build();
        ProductPrice fixed3A = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-03-01", null)).defaultPrice(true).pricingGroups(groupA)).build();
        ProductPrice fixed3B = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-03-01", null)).defaultPrice(true).pricingGroups(groupB)).build();
        ProductPrice fixed3C = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-03-01", null)).defaultPrice(true).build();
        ProductPrice unit1A = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(1)).dateRange("2008-01-01", "2008-01-11")).pricingGroups(groupA)).build();
        ProductPrice unit1B = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(1)).dateRange("2008-01-01", "2008-01-11")).pricingGroups(groupB)).build();
        ProductPrice unit1C = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(1)).dateRange("2008-01-01", "2008-01-11")).build();
        ProductPrice unit2A = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(1)).dateRange("2008-02-01", null)).pricingGroups(groupA)).build();
        ProductPrice unit2B = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(1)).dateRange("2008-02-01", null)).pricingGroups(groupB)).build();
        ProductPrice unit2C = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(1)).dateRange("2008-02-01", null)).build();
        Assert.assertNull((Object)this.rules.getProductPrice(product, "productPrice.fixedPrice", new Date(), null));
        Assert.assertNull((Object)this.rules.getProductPrice(product, "productPrice.unitPrice", new Date(), null));
        product.addProductPrice(fixed1A);
        product.addProductPrice(fixed1B);
        product.addProductPrice(fixed1C);
        product.addProductPrice(fixed2A);
        product.addProductPrice(fixed2B);
        product.addProductPrice(fixed2C);
        product.addProductPrice(unit1A);
        product.addProductPrice(unit1B);
        product.addProductPrice(unit1C);
        product.addProductPrice(unit2A);
        product.addProductPrice(unit2B);
        product.addProductPrice(unit2C);
        this.checkPrice(null, "productPrice.fixedPrice", "2007-01-01", product, groupA);
        this.checkPrice(null, "productPrice.fixedPrice", "2007-01-01", product, groupB);
        this.checkPrice(null, "productPrice.fixedPrice", "2007-01-01", product, null);
        this.checkPrice(fixed1A, "productPrice.fixedPrice", "2008-01-01", product, groupA);
        this.checkPrice(fixed1A, "productPrice.fixedPrice", "2008-01-31", product, groupA);
        this.checkPrice(fixed2A, "productPrice.fixedPrice", "2008-02-01", product, groupA);
        this.checkPrice(fixed2A, "productPrice.fixedPrice", "2008-12-31", product, groupA);
        this.checkPrice(null, "productPrice.fixedPrice", "2009-01-01", product, null);
        this.checkPrice(null, "productPrice.unitPrice", "2007-12-31", product, null);
        this.checkPrice(unit1A, "productPrice.unitPrice", "2008-01-01", product, groupA);
        this.checkPrice(unit1A, "productPrice.unitPrice", "2008-01-10", product, groupA);
        this.checkPrice(unit1B, "productPrice.unitPrice", "2008-01-01", product, groupB);
        this.checkPrice(unit1B, "productPrice.unitPrice", "2008-01-10", product, groupB);
        this.checkPrice(unit1C, "productPrice.unitPrice", "2008-01-01", product, null);
        this.checkPrice(unit1C, "productPrice.unitPrice", "2008-01-10", product, null);
        this.checkPrice(null, "productPrice.unitPrice", "2008-01-11", product, null);
        this.checkPrice(unit2A, "productPrice.unitPrice", "2008-02-01", product, groupA);
        this.checkPrice(unit2A, "productPrice.unitPrice", "2010-02-01", product, groupA);
        this.checkPrice(unit2B, "productPrice.unitPrice", "2008-02-01", product, groupB);
        this.checkPrice(unit2B, "productPrice.unitPrice", "2010-02-01", product, groupB);
        this.checkPrice(unit2C, "productPrice.unitPrice", "2008-02-01", product, null);
        this.checkPrice(unit2C, "productPrice.unitPrice", "2010-02-01", product, null);
        if (usePriceTemplate) {
            Product priceTemplate = (Product)((TestPriceTemplateProductBuilder)this.productFactory.newPriceTemplate().addPrices(fixed3A, fixed3B, fixed3C)).build();
            ((AbstractTestIMObjectBuilder)this.productFactory.updateProduct(product).addPriceTemplate(priceTemplate, "2008-01-01", null)).build();
            this.checkPrice(fixed2A, "productPrice.fixedPrice", "2008-02-01", product, groupA);
            this.checkPrice(fixed3A, "productPrice.fixedPrice", "2008-03-01", product, groupA);
            this.checkPrice(fixed3B, "productPrice.fixedPrice", "2008-03-01", product, groupB);
            this.checkPrice(fixed3C, "productPrice.fixedPrice", "2008-03-01", product, null);
            priceTemplate.setActive(false);
            this.save((IMObject)priceTemplate);
            this.checkPrice(fixed2A, "productPrice.fixedPrice", "2008-03-01", product, groupA);
        }
    }

    private void checkGetProductPriceForPrice(Product product, boolean usePriceTemplate) {
        BigDecimal one = BigDecimal.ONE;
        BigDecimal two = new BigDecimal("2.0");
        BigDecimal three = new BigDecimal("3.0");
        ProductPrice fixed1 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-01-31 10:00:00")).defaultPrice(false).build();
        ProductPrice fixed2 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(2)).dateRange("2008-02-01", "2009-01-01")).defaultPrice(false).build();
        ProductPrice fixed3 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(3)).dateRange("2008-03-01", null)).defaultPrice(true).build();
        ProductPrice unit1 = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(1)).dateRange("2008-01-01", "2008-01-11")).build();
        ProductPrice unit2 = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(2)).dateRange("2008-02-01", null)).build();
        Assert.assertNull((Object)this.rules.getProductPrice(product, one, "productPrice.fixedPrice", new Date(), null));
        Assert.assertNull((Object)this.rules.getProductPrice(product, one, "productPrice.unitPrice", new Date(), null));
        product.addProductPrice(fixed1);
        product.addProductPrice(fixed2);
        product.addProductPrice(unit1);
        product.addProductPrice(unit2);
        this.checkPrice(null, two, "productPrice.fixedPrice", "2008-01-01", product, null);
        this.checkPrice(fixed1, one, "productPrice.fixedPrice", "2008-01-01", product, null);
        this.checkPrice(null, two, "productPrice.fixedPrice", "2008-01-31", product, null);
        this.checkPrice(fixed1, one, "productPrice.fixedPrice", "2008-01-31", product, null);
        this.checkPrice(null, one, "productPrice.fixedPrice", "2008-02-01", product, null);
        this.checkPrice(fixed2, two, "productPrice.fixedPrice", TestHelper.getDatetime("2008-12-31 23:45:00"), product, null);
        this.checkPrice(null, two, "productPrice.fixedPrice", "2009-01-01", product, null);
        this.checkPrice(null, one, "productPrice.unitPrice", "2007-12-31", product, null);
        this.checkPrice(null, two, "productPrice.unitPrice", "2008-01-01", product, null);
        this.checkPrice(unit1, one, "productPrice.unitPrice", "2008-01-01", product, null);
        this.checkPrice(null, two, "productPrice.unitPrice", "2008-01-10", product, null);
        this.checkPrice(unit1, one, "productPrice.unitPrice", "2008-01-10", product, null);
        this.checkPrice(null, two, "productPrice.unitPrice", "2008-01-11", product, null);
        this.checkPrice(null, three, "productPrice.unitPrice", "2008-02-01", product, null);
        this.checkPrice(unit2, two, "productPrice.unitPrice", "2008-02-01", product, null);
        this.checkPrice(null, three, "productPrice.unitPrice", "2010-02-01", product, null);
        this.checkPrice(unit2, two, "productPrice.unitPrice", "2010-02-01", product, null);
        if (usePriceTemplate) {
            Product priceTemplate = (Product)((TestPriceTemplateProductBuilder)this.productFactory.newPriceTemplate().addPrice(fixed3)).build();
            ((AbstractTestIMObjectBuilder)this.productFactory.updateProduct(product).addPriceTemplate(priceTemplate, "2008-01-01", null)).build();
            this.checkPrice(fixed2, two, "productPrice.fixedPrice", "2008-02-01", product, null);
            this.checkPrice(fixed3, three, "productPrice.fixedPrice", "2008-03-01", product, null);
            this.checkPrice(fixed2, two, "productPrice.fixedPrice", "2008-03-01", product, null);
            priceTemplate.setActive(false);
            this.save((IMObject)priceTemplate);
            this.checkPrice(null, three, "productPrice.fixedPrice", "2008-03-01", product, null);
        }
    }

    private void checkGetProductPriceForPriceWithPriceGroups(Product product, boolean usePriceTemplate) {
        Lookup groupA = this.productFactory.createPricingGroup("A");
        Lookup groupB = this.productFactory.createPricingGroup("B");
        BigDecimal one = BigDecimal.ONE;
        BigDecimal two = new BigDecimal("2.0");
        BigDecimal three = new BigDecimal("3.0");
        ProductPrice fixed1A = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-01-31 10:00:00")).defaultPrice(false).pricingGroups(groupA)).build();
        ProductPrice fixed1B = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-01-31 10:00:00")).defaultPrice(false).pricingGroups(groupB)).build();
        ProductPrice fixed1C = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-01-31 10:00:00")).defaultPrice(false).build();
        ProductPrice fixed2A = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(2)).dateRange("2008-02-01", "2009-01-01")).defaultPrice(false).pricingGroups(groupA)).build();
        ProductPrice fixed2B = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(2)).dateRange("2008-02-01", "2009-01-01")).defaultPrice(false).pricingGroups(groupB)).build();
        ProductPrice fixed2C = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(2)).dateRange("2008-02-01", "2009-01-01")).defaultPrice(false).build();
        ProductPrice fixed3A = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(3)).dateRange("2008-03-01", null)).defaultPrice(true).pricingGroups(groupA)).build();
        ProductPrice fixed3B = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(3)).dateRange("2008-03-01", null)).defaultPrice(true).pricingGroups(groupB)).build();
        ProductPrice fixed3C = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(3)).dateRange("2008-03-01", null)).defaultPrice(true).build();
        ProductPrice unit1A = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(1)).dateRange("2008-01-01", "2008-01-11")).pricingGroups(groupA)).build();
        ProductPrice unit1B = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(1)).dateRange("2008-01-01", "2008-01-11")).pricingGroups(groupB)).build();
        ProductPrice unit1C = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(1)).dateRange("2008-01-01", "2008-01-11")).build();
        ProductPrice unit2A = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(2)).dateRange("2008-02-01", null)).pricingGroups(groupA)).build();
        ProductPrice unit2B = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(2)).dateRange("2008-02-01", null)).pricingGroups(groupB)).build();
        ProductPrice unit2C = ((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(2)).dateRange("2008-02-01", null)).build();
        Assert.assertNull((Object)this.rules.getProductPrice(product, one, "productPrice.fixedPrice", new Date(), null));
        Assert.assertNull((Object)this.rules.getProductPrice(product, one, "productPrice.unitPrice", new Date(), null));
        product.addProductPrice(fixed1A);
        product.addProductPrice(fixed1B);
        product.addProductPrice(fixed1C);
        product.addProductPrice(fixed2A);
        product.addProductPrice(fixed2B);
        product.addProductPrice(fixed2C);
        product.addProductPrice(unit1A);
        product.addProductPrice(unit1B);
        product.addProductPrice(unit1C);
        product.addProductPrice(unit2A);
        product.addProductPrice(unit2B);
        product.addProductPrice(unit2C);
        this.checkPrice(null, two, "productPrice.fixedPrice", "2008-01-01", product, null);
        this.checkPrice(fixed1A, one, "productPrice.fixedPrice", "2008-01-01", product, groupA);
        this.checkPrice(fixed1B, one, "productPrice.fixedPrice", "2008-01-01", product, groupB);
        this.checkPrice(fixed1C, one, "productPrice.fixedPrice", "2008-01-01", product, null);
        this.checkPrice(null, two, "productPrice.fixedPrice", "2008-01-31", product, null);
        this.checkPrice(fixed1A, one, "productPrice.fixedPrice", "2008-01-31", product, groupA);
        this.checkPrice(fixed1B, one, "productPrice.fixedPrice", "2008-01-31", product, groupB);
        this.checkPrice(fixed1C, one, "productPrice.fixedPrice", "2008-01-31", product, null);
        this.checkPrice(null, one, "productPrice.fixedPrice", "2008-02-01", product, null);
        this.checkPrice(fixed2A, two, "productPrice.fixedPrice", TestHelper.getDatetime("2008-12-31 23:45:00"), product, groupA);
        this.checkPrice(fixed2B, two, "productPrice.fixedPrice", TestHelper.getDatetime("2008-12-31 23:45:00"), product, groupB);
        this.checkPrice(fixed2C, two, "productPrice.fixedPrice", TestHelper.getDatetime("2008-12-31 23:45:00"), product, null);
        this.checkPrice(null, two, "productPrice.fixedPrice", "2009-01-01", product, null);
        this.checkPrice(null, one, "productPrice.unitPrice", "2007-12-31", product, null);
        this.checkPrice(null, two, "productPrice.unitPrice", "2008-01-01", product, null);
        this.checkPrice(unit1A, one, "productPrice.unitPrice", "2008-01-01", product, groupA);
        this.checkPrice(unit1B, one, "productPrice.unitPrice", "2008-01-01", product, groupB);
        this.checkPrice(unit1C, one, "productPrice.unitPrice", "2008-01-01", product, null);
        this.checkPrice(null, two, "productPrice.unitPrice", "2008-01-10", product, null);
        this.checkPrice(unit1A, one, "productPrice.unitPrice", "2008-01-10", product, groupA);
        this.checkPrice(unit1B, one, "productPrice.unitPrice", "2008-01-10", product, groupB);
        this.checkPrice(unit1C, one, "productPrice.unitPrice", "2008-01-10", product, null);
        this.checkPrice(null, two, "productPrice.unitPrice", "2008-01-11", product, null);
        this.checkPrice(null, three, "productPrice.unitPrice", "2008-02-01", product, null);
        this.checkPrice(unit2A, two, "productPrice.unitPrice", "2008-02-01", product, groupA);
        this.checkPrice(unit2B, two, "productPrice.unitPrice", "2008-02-01", product, groupB);
        this.checkPrice(unit2C, two, "productPrice.unitPrice", "2008-02-01", product, null);
        this.checkPrice(null, three, "productPrice.unitPrice", "2010-02-01", product, null);
        this.checkPrice(unit2A, two, "productPrice.unitPrice", "2010-02-01", product, groupA);
        this.checkPrice(unit2B, two, "productPrice.unitPrice", "2010-02-01", product, groupB);
        this.checkPrice(unit2C, two, "productPrice.unitPrice", "2010-02-01", product, null);
        if (usePriceTemplate) {
            Product priceTemplate = (Product)((TestPriceTemplateProductBuilder)this.productFactory.newPriceTemplate().addPrices(fixed3A, fixed3B, fixed3C)).build();
            ((AbstractTestIMObjectBuilder)this.productFactory.updateProduct(product).addPriceTemplate(priceTemplate, "2008-01-01", null)).build();
            this.checkPrice(fixed2A, two, "productPrice.fixedPrice", "2008-02-01", product, groupA);
            this.checkPrice(fixed2B, two, "productPrice.fixedPrice", "2008-02-01", product, groupB);
            this.checkPrice(fixed2C, two, "productPrice.fixedPrice", "2008-02-01", product, null);
            this.checkPrice(fixed3A, three, "productPrice.fixedPrice", "2008-03-01", product, groupA);
            this.checkPrice(fixed3B, three, "productPrice.fixedPrice", "2008-03-01", product, groupB);
            this.checkPrice(fixed3C, three, "productPrice.fixedPrice", "2008-03-01", product, null);
            this.checkPrice(fixed2A, two, "productPrice.fixedPrice", "2008-03-01", product, groupA);
            this.checkPrice(fixed2B, two, "productPrice.fixedPrice", "2008-03-01", product, groupB);
            this.checkPrice(fixed2C, two, "productPrice.fixedPrice", "2008-03-01", product, null);
            priceTemplate.setActive(false);
            this.save((IMObject)priceTemplate);
            this.checkPrice(fixed2A, two, "productPrice.fixedPrice", "2008-02-01", product, groupA);
            this.checkPrice(fixed2B, two, "productPrice.fixedPrice", "2008-02-01", product, groupB);
            this.checkPrice(fixed2C, two, "productPrice.fixedPrice", "2008-02-01", product, null);
            this.checkPrice(null, three, "productPrice.fixedPrice", "2008-03-01", product, groupA);
            this.checkPrice(null, three, "productPrice.fixedPrice", "2008-03-01", product, groupB);
            this.checkPrice(null, three, "productPrice.fixedPrice", "2008-03-01", product, null);
            this.checkPrice(fixed2A, two, "productPrice.fixedPrice", "2008-03-01", product, groupA);
            this.checkPrice(fixed2B, two, "productPrice.fixedPrice", "2008-03-01", product, groupB);
            this.checkPrice(fixed2C, two, "productPrice.fixedPrice", "2008-03-01", product, null);
        }
    }

    private void checkGetProductPrices(Product product) {
        ProductPrice fixed1 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-01-31")).build();
        ProductPrice fixed2 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-12-31")).build();
        product.addProductPrice(fixed1);
        product.addProductPrice(fixed2);
        this.save((IMObject)product);
        product = this.get(product);
        List prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2007-01-01"), PricingGroup.ALL);
        Assert.assertTrue((boolean)prices.isEmpty());
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-01-01"), PricingGroup.ALL);
        Assert.assertEquals((long)2L, (long)prices.size());
        Assert.assertTrue((boolean)prices.contains(fixed1));
        Assert.assertTrue((boolean)prices.contains(fixed2));
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-02-01"), PricingGroup.ALL);
        Assert.assertEquals((long)1L, (long)prices.size());
        Assert.assertFalse((boolean)prices.contains(fixed1));
        Assert.assertTrue((boolean)prices.contains(fixed2));
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2009-01-01"), PricingGroup.ALL);
        Assert.assertEquals((long)0L, (long)prices.size());
    }

    private void checkGetProductPricesWithPriceGroups(Product product) {
        Lookup groupA = this.productFactory.createPricingGroup("A");
        Lookup groupB = this.productFactory.createPricingGroup("B");
        ProductPrice fixed1A = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-01-31")).defaultPrice(false).pricingGroups(groupA)).build();
        ProductPrice fixed1B = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-01-31")).defaultPrice(false).pricingGroups(groupB)).build();
        ProductPrice fixed1C = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-01-31")).defaultPrice(false).build();
        ProductPrice fixed2A = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-12-31")).defaultPrice(false).pricingGroups(groupA)).build();
        ProductPrice fixed2B = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-12-31")).defaultPrice(false).pricingGroups(groupB)).build();
        ProductPrice fixed2C = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-12-31")).defaultPrice(false).build();
        product.addProductPrice(fixed1A);
        product.addProductPrice(fixed1B);
        product.addProductPrice(fixed1C);
        product.addProductPrice(fixed2A);
        product.addProductPrice(fixed2B);
        product.addProductPrice(fixed2C);
        this.save((IMObject)product);
        product = this.get(product);
        List prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2007-01-01"), PricingGroup.ALL);
        Assert.assertTrue((boolean)prices.isEmpty());
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-01-01"), PricingGroup.ALL);
        this.checkPrices(prices, fixed1A, fixed1B, fixed1C, fixed2A, fixed2B, fixed2C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-01-01"), new PricingGroup(groupA));
        this.checkPrices(prices, fixed1A, fixed1C, fixed2A, fixed2C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-01-01"), new PricingGroup(groupB));
        this.checkPrices(prices, fixed1B, fixed1C, fixed2B, fixed2C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-01-01"), new PricingGroup(null));
        this.checkPrices(prices, fixed1C, fixed2C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-02-01"), PricingGroup.ALL);
        this.checkPrices(prices, fixed2A, fixed2B, fixed2C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-02-01"), new PricingGroup(groupA));
        this.checkPrices(prices, fixed2A, fixed2C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-02-01"), new PricingGroup(groupB));
        this.checkPrices(prices, fixed2B, fixed2C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-02-01"), new PricingGroup(null));
        this.checkPrices(prices, fixed2C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2009-01-01"), PricingGroup.ALL);
        Assert.assertEquals((long)0L, (long)prices.size());
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2009-01-01"), new PricingGroup(groupA));
        Assert.assertEquals((long)0L, (long)prices.size());
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2009-01-01"), new PricingGroup(groupB));
        Assert.assertEquals((long)0L, (long)prices.size());
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2009-01-01"), new PricingGroup(null));
        Assert.assertEquals((long)0L, (long)prices.size());
    }

    private void checkGetProductPricesForProductWithPriceTemplate(Product product) {
        ProductPrice fixed1 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-01-31")).build();
        ProductPrice fixed2 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-12-31")).build();
        ProductPrice fixed3 = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-02-01", null)).build();
        product.addProductPrice(fixed1);
        product.addProductPrice(fixed2);
        Product priceTemplate = (Product)((TestPriceTemplateProductBuilder)this.productFactory.newPriceTemplate().addPrice(fixed3)).build();
        ((AbstractTestIMObjectBuilder)this.productFactory.updateProduct(product).addPriceTemplate(priceTemplate, "2008-01-01", null)).build();
        List prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2007-01-01"), PricingGroup.ALL);
        Assert.assertTrue((boolean)prices.isEmpty());
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-01-01"), PricingGroup.ALL);
        Assert.assertEquals((long)2L, (long)prices.size());
        Assert.assertTrue((boolean)prices.contains(fixed1));
        Assert.assertTrue((boolean)prices.contains(fixed2));
        Assert.assertFalse((boolean)prices.contains(fixed3));
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-02-01"), PricingGroup.ALL);
        Assert.assertEquals((long)2L, (long)prices.size());
        Assert.assertFalse((boolean)prices.contains(fixed1));
        Assert.assertTrue((boolean)prices.contains(fixed2));
        Assert.assertTrue((boolean)prices.contains(fixed3));
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2009-01-01"), PricingGroup.ALL);
        Assert.assertEquals((long)1L, (long)prices.size());
        Assert.assertFalse((boolean)prices.contains(fixed1));
        Assert.assertFalse((boolean)prices.contains(fixed2));
        Assert.assertTrue((boolean)prices.contains(fixed3));
        priceTemplate.setActive(false);
        this.save((IMObject)priceTemplate);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2009-01-01"), PricingGroup.ALL);
        Assert.assertEquals((long)0L, (long)prices.size());
    }

    private void checkGetProductPricesWithPriceGroupsForProductWithPriceTemplate(Product product) {
        Lookup groupA = this.productFactory.createPricingGroup("A");
        Lookup groupB = this.productFactory.createPricingGroup("B");
        ProductPrice fixed1A = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-01-31")).defaultPrice(false).pricingGroups(groupA)).build();
        ProductPrice fixed1B = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-01-31")).defaultPrice(false).pricingGroups(groupB)).build();
        ProductPrice fixed1C = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-01-31")).defaultPrice(false).build();
        ProductPrice fixed2A = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-12-31")).defaultPrice(false).pricingGroups(groupA)).build();
        ProductPrice fixed2B = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-12-31")).defaultPrice(false).pricingGroups(groupB)).build();
        ProductPrice fixed2C = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-01-01", "2008-12-31")).defaultPrice(false).build();
        ProductPrice fixed3A = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-02-01", null)).defaultPrice(false).pricingGroups(groupA)).build();
        ProductPrice fixed3B = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-02-01", null)).defaultPrice(false).pricingGroups(groupB)).build();
        ProductPrice fixed3C = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2008-02-01", null)).defaultPrice(false).build();
        Product priceTemplate = (Product)((TestPriceTemplateProductBuilder)this.productFactory.newPriceTemplate().addPrices(fixed3A, fixed3B, fixed3C)).build();
        ((AbstractTestIMObjectBuilder)((TestProductBuilder)this.productFactory.updateProduct(product).addPrices(fixed1A, fixed1B, fixed1C, fixed2A, fixed2B, fixed2C)).addPriceTemplate(priceTemplate, "2008-01-01", null)).build();
        product = this.get(product);
        List prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2007-01-01"), PricingGroup.ALL);
        Assert.assertTrue((boolean)prices.isEmpty());
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-01-01"), PricingGroup.ALL);
        this.checkPrices(prices, fixed1A, fixed1B, fixed1C, fixed2A, fixed2B, fixed2C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-01-01"), new PricingGroup(groupA));
        this.checkPrices(prices, fixed1A, fixed1C, fixed2A, fixed2C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-01-01"), new PricingGroup(groupB));
        this.checkPrices(prices, fixed1B, fixed1C, fixed2B, fixed2C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-01-01"), new PricingGroup(null));
        this.checkPrices(prices, fixed1C, fixed2C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-02-01"), PricingGroup.ALL);
        this.checkPrices(prices, fixed2A, fixed2B, fixed2C, fixed3A, fixed3B, fixed3C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-02-01"), new PricingGroup(groupA));
        this.checkPrices(prices, fixed2A, fixed2C, fixed3A, fixed3C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-02-01"), new PricingGroup(groupB));
        this.checkPrices(prices, fixed2B, fixed2C, fixed3B, fixed3C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-02-01"), new PricingGroup(null));
        this.checkPrices(prices, fixed2C, fixed3C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2009-01-01"), PricingGroup.ALL);
        this.checkPrices(prices, fixed3A, fixed3B, fixed3C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2009-01-01"), new PricingGroup(groupA));
        this.checkPrices(prices, fixed3A, fixed3C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2009-01-01"), new PricingGroup(groupB));
        this.checkPrices(prices, fixed3B, fixed3C);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2009-01-01"), new PricingGroup(null));
        this.checkPrices(prices, fixed3C);
        priceTemplate.setActive(false);
        this.save((IMObject)priceTemplate);
        prices = this.rules.getProductPrices(product, "productPrice.fixedPrice", TestHelper.getDate("2008-02-01"), new PricingGroup(groupA));
        this.checkPrices(prices, fixed2A, fixed2C);
    }

    private void checkGetTaxIncPrice(String taxExPrice, String taxIncPrice, Product product, Currency currency) {
        BigDecimal price = this.rules.getTaxIncPrice(new BigDecimal(taxExPrice), product, this.practice, currency);
        this.checkEquals(new BigDecimal(taxIncPrice), price);
    }

    private void checkPrices(List<ProductPrice> expected, ProductPrice ... prices) {
        Assert.assertEquals((long)expected.size(), (long)prices.length);
        for (ProductPrice price : prices) {
            Assert.assertTrue((boolean)expected.contains(price));
        }
    }

    private Product createMedication() {
        return (Product)this.productFactory.newMedication().build(false);
    }

    private Product createMerchandise() {
        return (Product)this.productFactory.newMerchandise().build(false);
    }

    private Product createService() {
        return (Product)this.productFactory.newService().build(false);
    }

    private Product createTemplate() {
        return (Product)this.productFactory.newTemplate().build(false);
    }

    private Product createPriceTemplate() {
        return (Product)this.productFactory.newPriceTemplate().build(false);
    }

    private void checkPrice(ProductPrice expected, String shortName, String date, Product product, Lookup pricingGroup) {
        this.checkPrice(expected, shortName, TestHelper.getDate(date), product, pricingGroup);
    }

    private void checkPrice(ProductPrice expected, String shortName, Date date, Product product, Lookup pricingGroup) {
        Assert.assertEquals((Object)expected, (Object)this.rules.getProductPrice(product, shortName, date, pricingGroup));
    }

    private void checkPrice(ProductPrice expected, BigDecimal price, String shortName, String date, Product product, Lookup pricingGroup) {
        this.checkPrice(expected, price, shortName, TestHelper.getDate(date), product, pricingGroup);
    }

    private void checkPrice(ProductPrice expected, BigDecimal price, String shortName, Date date, Product product, Lookup pricingGroup) {
        Assert.assertEquals((Object)expected, (Object)this.rules.getProductPrice(product, price, shortName, date, pricingGroup));
    }
}

