/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.prefs;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.prefs.PreferenceService;
import org.openvpms.archetype.rules.prefs.PreferenceServiceImpl;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class PreferenceServiceImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    PlatformTransactionManager transactionManager;
    private PreferenceService service;
    private User user;

    @Before
    public void setUp() {
        this.service = new PreferenceServiceImpl(this.getArchetypeService(), this.transactionManager);
        this.user = TestHelper.createUser();
    }

    @Test
    public void testReset() {
        this.service.reset((Party)this.user, null);
        Preferences prefs = this.service.getPreferences((Party)this.user, null, true);
        prefs.getPreference("entity.preferenceGroupSummary", "showReferral", (Object)"ALWAYS");
        Entity entity = this.service.getEntity((Party)this.user, null);
        Assert.assertNotNull((Object)entity);
        List<Entity> groups = this.getGroups(entity);
        Assert.assertEquals((long)1L, (long)groups.size());
        this.service.reset((Party)this.user, null);
        Assert.assertNull((Object)this.get(entity));
        Assert.assertNull((Object)this.get((IMObject)groups.get(0)));
    }

    @Test
    public void testCreateWithDefaults() {
        Party practice = TestHelper.getPractice();
        this.service.reset(practice, null);
        Preferences defaultPrefs = this.service.getPreferences(practice, null, true);
        defaultPrefs.setPreference("entity.preferenceGroupSummary", "showReferral", (Object)"ALWAYS");
        defaultPrefs.setPreference("entity.preferenceGroupSummary", "showCustomerAccount", (Object)false);
        Entity defaultPrefEntity = this.service.getEntity(practice, null);
        Assert.assertNotNull((Object)defaultPrefEntity);
        List<Entity> defaultGroups = this.getGroups(defaultPrefEntity);
        Assert.assertEquals((long)1L, (long)defaultGroups.size());
        Preferences prefs = this.service.getPreferences((Party)this.user, practice, true);
        Assert.assertEquals((Object)"ALWAYS", (Object)prefs.getString("entity.preferenceGroupSummary", "showReferral", "ACTIVE"));
        Assert.assertFalse((boolean)prefs.getBoolean("entity.preferenceGroupSummary", "showCustomerAccount", true));
        Entity entity = this.service.getEntity((Party)this.user, practice);
        Assert.assertNotNull((Object)entity);
        Assert.assertNotEquals((long)entity.getId(), (long)defaultPrefEntity.getId());
        List<Entity> groups = this.getGroups(entity);
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertNotEquals((long)defaultGroups.get(0).getId(), (long)groups.get(0).getId());
    }

    @Test
    public void testResetToPracticeDefaults() {
        Party practice = TestHelper.getPractice();
        this.service.reset(practice, null);
        Preferences defaultPrefs = this.service.getPreferences(practice, null, true);
        defaultPrefs.setPreference("entity.preferenceGroupSummary", "showReferral", (Object)"ALWAYS");
        Preferences prefs = this.service.getPreferences((Party)this.user, null, true);
        Assert.assertEquals((Object)"ACTIVE", (Object)prefs.getString("entity.preferenceGroupSummary", "showReferral", "ACTIVE"));
        prefs.setPreference("entity.preferenceGroupSummary", "showReferral", (Object)"NEVER");
        this.service.reset((Party)this.user, practice);
        prefs = this.service.getPreferences((Party)this.user, null, true);
        Assert.assertEquals((Object)"ALWAYS", (Object)prefs.getString("entity.preferenceGroupSummary", "showReferral", "ACTIVE"));
    }

    @Test
    public void testTransactionIsolation() {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        final Preferences preferences = this.service.getPreferences((Party)this.user, null, true);
        Assert.assertEquals((Object)"customer.information", (Object)preferences.getString("entity.preferenceGroupGeneral", "homePage", null));
        final Party customer = TestHelper.createCustomer();
        long version = customer.getVersion();
        String name = customer.getName();
        try {
            template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    IMObjectBean bean = PreferenceServiceImplTestCase.this.getBean((IMObject)customer);
                    bean.setValue("lastName", (Object)"Foo");
                    bean.save();
                    preferences.setPreference("entity.preferenceGroupGeneral", "homePage", (Object)"workflow.scheduling");
                    throw new IllegalStateException("Forcing rollback of outer transaction");
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Preferences preferences2 = this.service.getPreferences((Party)this.user, null, true);
        Assert.assertEquals((Object)"workflow.scheduling", (Object)preferences2.getString("entity.preferenceGroupGeneral", "homePage", null));
        Party customer2 = this.get(customer);
        Assert.assertEquals((long)version, (long)customer2.getVersion());
        Assert.assertEquals((Object)name, (Object)customer2.getName());
    }

    @Test
    public void testPreferenceRollbackDoesntAffectOuterTransaction() {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        Preferences preferences1 = this.service.getPreferences((Party)this.user, null, true);
        final Preferences preferences2 = this.service.getPreferences((Party)this.user, null, true);
        Assert.assertEquals((Object)"customer.information", (Object)preferences1.getString("entity.preferenceGroupGeneral", "homePage", null));
        Assert.assertEquals((Object)"customer.information", (Object)preferences2.getString("entity.preferenceGroupGeneral", "homePage", null));
        preferences1.setPreference("entity.preferenceGroupGeneral", "homePage", (Object)"customer.communication");
        Assert.assertEquals((Object)"customer.information", (Object)preferences2.getString("entity.preferenceGroupGeneral", "homePage", null));
        final Party customer = TestHelper.createCustomer();
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                IMObjectBean bean = PreferenceServiceImplTestCase.this.getBean((IMObject)customer);
                bean.setValue("lastName", (Object)"Foo");
                bean.save();
                preferences2.setPreference("entity.preferenceGroupGeneral", "homePage", (Object)"workflow.scheduling");
            }
        });
        Preferences preferences3 = this.service.getPreferences((Party)this.user, null, true);
        Assert.assertEquals((Object)"customer.communication", (Object)preferences3.getString("entity.preferenceGroupGeneral", "homePage", null));
        Party customer2 = this.get(customer);
        Assert.assertEquals((long)1L, (long)customer2.getVersion());
        Assert.assertEquals((Object)"Foo", (Object)this.getBean((IMObject)customer2).getString("lastName"));
    }

    private List<Entity> getGroups(Entity prefs) {
        IMObjectBean bean = this.getBean((IMObject)prefs);
        return bean.getTargets("groups", Entity.class);
    }
}

