/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.practice;

import java.util.List;
import javax.persistence.criteria.Expression;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.job.account.TestAccountReminderJobBuilder;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class PracticeServiceTestCase
extends ArchetypeServiceTest {
    @Autowired
    private PracticeRules practiceRules;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestUserFactory userFactory;

    @Test
    public void testAccountRemindersEnabled() {
        IArchetypeService service = this.getArchetypeService();
        this.disableJobs();
        PracticeService practiceService = new PracticeService(service, this.practiceRules, null);
        Assert.assertFalse((boolean)practiceService.accountRemindersEnabled());
        Entity job = (Entity)((TestAccountReminderJobBuilder)new TestAccountReminderJobBuilder((ArchetypeService)service).count().interval(2, DateUnits.DAYS).template("'dummy'").add().runAs(this.userFactory.createUser())).build();
        Assert.assertTrue((boolean)practiceService.accountRemindersEnabled());
        job.setActive(false);
        this.save((IMObject)job);
        Assert.assertFalse((boolean)practiceService.accountRemindersEnabled());
        practiceService.destroy();
    }

    @Test
    public void testGetLocations() {
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = (Party)((TestLocationBuilder)this.practiceFactory.newLocation().active(false)).build();
        final Party practice = (Party)this.practiceFactory.newPractice().locations(location1, location2, location3).build(false);
        PracticeService practiceService = new PracticeService(this.getArchetypeService(), this.practiceRules, null){

            public synchronized Party getPractice() {
                return practice;
            }
        };
        List locations1 = practiceService.getLocations();
        Assert.assertEquals((long)2L, (long)locations1.size());
        Assert.assertTrue((boolean)locations1.contains(location1));
        Assert.assertTrue((boolean)locations1.contains(location2));
        Assert.assertFalse((boolean)locations1.contains(location3));
    }

    @Test
    public void testGetMailServer() {
        final Party practice = (Party)this.practiceFactory.newPractice().mailServer(null).build(false);
        PracticeService practiceService = new PracticeService(this.getArchetypeService(), this.practiceRules, null){

            public synchronized Party getPractice() {
                return practice;
            }
        };
        Assert.assertNull((Object)practiceService.getMailServer());
        Entity mailServer = (Entity)this.practiceFactory.newMailServer().host("localhost").build();
        this.practiceFactory.updatePractice(practice).mailServer(mailServer).build(false);
        Assert.assertEquals((long)mailServer.getId(), (long)practiceService.getMailServer().getId());
        mailServer.setActive(false);
        this.save((IMObject)mailServer);
        Assert.assertNull((Object)practiceService.getMailServer());
        practiceService.destroy();
    }

    private void disableJobs() {
        IArchetypeService service = this.getArchetypeService();
        CriteriaBuilder builder = service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Entity.class);
        Root root = query.from(Entity.class, new String[]{"entity.jobAccountReminder"});
        query.where((Expression)builder.equal((Expression)root.get("active"), (Object)true));
        for (Entity job : service.createQuery(query).getResultList()) {
            job.setActive(false);
            this.save((IMObject)job);
        }
    }
}

