/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.practice;

import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.math.Currencies;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.util.EntityRelationshipHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class PracticeRulesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private Currencies currencies;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestUserFactory userFactory;
    private PracticeRules rules;

    @Before
    public void setUp() {
        IArchetypeService service = this.getArchetypeService();
        this.rules = new PracticeRules((ArchetypeService)service, this.currencies);
    }

    @Test
    public void testGetLocations() {
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = (Party)((TestLocationBuilder)this.practiceFactory.newLocation().active(false)).build();
        Party practice = (Party)this.newPractice().locations(location1, location2, location3).build(false);
        List locations1 = this.rules.getLocations(practice);
        Assert.assertEquals((long)2L, (long)locations1.size());
        Assert.assertTrue((boolean)locations1.contains(location1));
        Assert.assertTrue((boolean)locations1.contains(location2));
        Assert.assertFalse((boolean)locations1.contains(location3));
    }

    @Test
    public void testGetDefaultLocation() {
        Party practice = this.createPractice();
        Assert.assertNull((Object)this.rules.getDefaultLocation(practice));
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        IMObjectBean bean = this.getBean((IMObject)practice);
        bean.addTarget("locations", (IMObject)location1);
        EntityRelationship rel2 = (EntityRelationship)bean.addTarget("locations", (IMObject)location2);
        Party defaultLocation = this.rules.getDefaultLocation(practice);
        Assert.assertNotNull((Object)defaultLocation);
        Assert.assertTrue((defaultLocation.equals(location1) || defaultLocation.equals(location2) ? 1 : 0) != 0);
        EntityRelationshipHelper.setDefault((Entity)practice, (String)"locations", (Relationship)rel2, (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((Object)location2, (Object)this.rules.getDefaultLocation(practice));
    }

    @Test
    public void testIsActivePractice() {
        Party practice = this.practiceFactory.getPractice();
        Assert.assertTrue((boolean)this.rules.isActivePractice(practice));
        this.save((IMObject)practice);
        Party newPractice = this.createPractice();
        try {
            this.save((IMObject)newPractice);
            Assert.fail((String)"Expected save of another active practice to fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        newPractice.setActive(false);
        this.save((IMObject)newPractice);
        Assert.assertFalse((boolean)this.rules.isActivePractice(newPractice));
        Assert.assertTrue((boolean)this.rules.isActivePractice(practice));
    }

    @Test
    public void testEstimateExpiryDate() {
        Party practice = this.createPractice();
        IMObjectBean bean = this.getBean((IMObject)practice);
        bean.setValue("estimateExpiryUnits", null);
        Date startDate = TestHelper.getDate("2018-08-04");
        Assert.assertNull((Object)this.rules.getEstimateExpiryDate(startDate, practice));
        bean.setValue("estimateExpiryPeriod", (Object)1);
        bean.setValue("estimateExpiryUnits", (Object)"YEARS");
        Assert.assertEquals((Object)TestHelper.getDate("2019-08-04"), (Object)this.rules.getEstimateExpiryDate(startDate, practice));
        bean.setValue("estimateExpiryPeriod", (Object)6);
        bean.setValue("estimateExpiryUnits", (Object)"MONTHS");
        Assert.assertEquals((Object)TestHelper.getDate("2019-02-04"), (Object)this.rules.getEstimateExpiryDate(startDate, practice));
    }

    @Test
    public void testPrescriptionExpiryDate() {
        Party practice = this.createPractice();
        IMObjectBean bean = this.getBean((IMObject)practice);
        bean.setValue("prescriptionExpiryUnits", null);
        Date startDate = TestHelper.getDate("2013-07-01");
        Assert.assertEquals((Object)startDate, (Object)this.rules.getPrescriptionExpiryDate(startDate, practice));
        bean.setValue("prescriptionExpiryPeriod", (Object)1);
        bean.setValue("prescriptionExpiryUnits", (Object)"YEARS");
        Assert.assertEquals((Object)TestHelper.getDate("2014-07-01"), (Object)this.rules.getPrescriptionExpiryDate(startDate, practice));
        bean.setValue("prescriptionExpiryPeriod", (Object)6);
        bean.setValue("prescriptionExpiryUnits", (Object)"MONTHS");
        Assert.assertEquals((Object)TestHelper.getDate("2014-01-01"), (Object)this.rules.getPrescriptionExpiryDate(startDate, practice));
    }

    @Test
    public void testGetServiceUser() {
        Party practice = this.createPractice();
        Assert.assertNull((Object)this.rules.getServiceUser(practice));
        User user = this.userFactory.createUser();
        IMObjectBean bean = this.getBean((IMObject)practice);
        bean.addTarget("serviceUser", (IMObject)user);
        Assert.assertEquals((Object)user, (Object)this.rules.getServiceUser(practice));
    }

    @Test
    public void testGetCurrency() {
        Party practice = this.createPractice();
        Currency currency = this.rules.getCurrency(practice);
        Assert.assertEquals((Object)"AUD", (Object)currency.getCode());
        Assert.assertEquals((long)2L, (long)currency.getDefaultFractionDigits());
    }

    @Test
    public void testUseLocationProducts() {
        Party practice = this.createPractice();
        Assert.assertFalse((boolean)this.rules.useLocationProducts(practice));
        IMObjectBean bean = this.getBean((IMObject)practice);
        bean.setValue("useLocationProducts", (Object)true);
        Assert.assertTrue((boolean)this.rules.useLocationProducts(practice));
    }

    @Test
    public void testGetBaseUrl() {
        Party practice = this.createPractice();
        Assert.assertNull((Object)this.rules.getBaseURL(practice));
        IMObjectBean bean = this.getBean((IMObject)practice);
        bean.setValue("baseUrl", (Object)"http://localhost:8080/openvpms");
        Assert.assertEquals((Object)"http://localhost:8080/openvpms", (Object)this.rules.getBaseURL(practice));
    }

    @Test
    public void testPluginsEnabled() {
        Party practice = this.createPractice();
        IMObjectBean bean = this.getBean((IMObject)practice);
        bean.setValue("enablePlugins", (Object)true);
        Assert.assertTrue((boolean)this.rules.pluginsEnabled(practice));
        bean.setValue("enablePlugins", (Object)false);
        Assert.assertFalse((boolean)this.rules.pluginsEnabled(practice));
    }

    @Test
    public void testSMSEnabled() {
        Party practice = this.createPractice();
        Assert.assertFalse((boolean)this.rules.isSMSEnabled(practice));
        Entity sms = this.create("entity.SMSConfigEmailGeneric", Entity.class);
        sms.setName(TestHelper.randomName("zms"));
        this.save((IMObject)sms);
        IMObjectBean bean = this.getBean((IMObject)practice);
        bean.setTarget("sms", sms.getObjectReference());
        Assert.assertTrue((boolean)this.rules.isSMSEnabled(practice));
        sms.setActive(false);
        this.save((IMObject)sms);
        Assert.assertFalse((boolean)this.rules.isSMSEnabled(practice));
    }

    @Test
    public void testDefaultWeightUnits() {
        Party practice = this.createPractice();
        Assert.assertEquals((Object)WeightUnits.KILOGRAMS, (Object)this.rules.getDefaultWeightUnits(practice));
    }

    private Party createPractice() {
        return (Party)((TestPracticeBuilder)this.newPractice().name(ValueStrategy.random("xpractice"))).currency("AUD").build(false);
    }

    private TestPracticeBuilder newPractice() {
        return this.practiceFactory.updatePractice(this.create("party.organisationPractice", Party.class));
    }
}

