/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.reminder.ReminderQueueIterator;
import org.openvpms.archetype.rules.patient.reminder.ReminderQueueQueryFactory;
import org.openvpms.archetype.rules.patient.reminder.ReminderTestHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;

public class ReminderQueueIteratorTestCase
extends ArchetypeServiceTest {
    @Test
    public void testIterator() {
        Entity reminderType1 = ReminderTestHelper.createReminderType(1, DateUnits.YEARS, new Lookup[0]);
        Entity reminderType2 = ReminderTestHelper.createReminderType(1, DateUnits.YEARS, new Lookup[0]);
        Party customer1 = TestHelper.createCustomer();
        Party patient1 = TestHelper.createPatient(customer1);
        Party customer2 = TestHelper.createCustomer();
        Party patient2 = TestHelper.createPatient(customer2);
        Act reminder1 = ReminderTestHelper.createReminder(patient1, reminderType1);
        Act reminder2 = ReminderTestHelper.createReminder(patient2, reminderType1);
        Act reminder3 = ReminderTestHelper.createReminder(patient1, reminderType1);
        Act reminder4 = ReminderTestHelper.createReminder(patient2, reminderType1);
        Act reminder5 = ReminderTestHelper.createReminder(patient1, reminderType1);
        Act reminder6 = ReminderTestHelper.createReminder(patient2, reminderType1);
        Act reminder7 = ReminderTestHelper.createReminder(patient1, reminderType2);
        reminder5.setStatus("COMPLETED");
        reminder6.setStatus("CANCELLED");
        this.save((IMObject)reminder1);
        this.save((IMObject)reminder2);
        this.save((IMObject)reminder3);
        this.save((IMObject)reminder4);
        this.save((IMObject)reminder5);
        this.save((IMObject)reminder6);
        this.save((IMObject)reminder7);
        ReminderQueueIterator iterator1 = this.createIterator(DateRules.getTomorrow(), reminderType1, 1);
        this.checkIterator((Iterator<Act>)iterator1, reminder1, reminder2, reminder3, reminder4);
        ReminderQueueIterator iterator2 = this.createIterator(DateRules.getYesterday(), reminderType1, 1);
        this.checkIterator((Iterator<Act>)iterator2, new Act[0]);
        ReminderQueueIterator iterator3 = this.createIterator(DateRules.getTomorrow(), reminderType2, 1);
        this.checkIterator((Iterator<Act>)iterator3, reminder7);
    }

    @Test
    public void testUpdateIterator() {
        Entity reminderType = ReminderTestHelper.createReminderType(1, DateUnits.YEARS, new Lookup[0]);
        Party customer1 = TestHelper.createCustomer();
        Party patient1 = TestHelper.createPatient(customer1);
        Party customer2 = TestHelper.createCustomer();
        Party patient2 = TestHelper.createPatient(customer2);
        Act reminder1 = ReminderTestHelper.createReminder(patient1, reminderType);
        Act reminder2 = ReminderTestHelper.createReminder(patient2, reminderType);
        Act reminder3 = ReminderTestHelper.createReminder(patient1, reminderType);
        Act reminder4 = ReminderTestHelper.createReminder(patient2, reminderType);
        this.save((IMObject)reminder1);
        this.save((IMObject)reminder2);
        this.save((IMObject)reminder3);
        this.save((IMObject)reminder4);
        ReminderQueueIterator iterator = this.createIterator(DateRules.getTomorrow(), reminderType, 2);
        this.checkNext((Iterator<Act>)iterator, reminder1);
        reminder1.setStatus("COMPLETED");
        this.save((IMObject)reminder1);
        iterator.updated();
        this.checkNext((Iterator<Act>)iterator, reminder2);
        reminder2.setStatus("CANCELLED");
        this.save((IMObject)reminder2);
        iterator.updated();
        this.checkNext((Iterator<Act>)iterator, reminder3);
        this.checkNext((Iterator<Act>)iterator, reminder4);
        reminder4.setStatus("COMPLETED");
        this.save((IMObject)reminder4);
        iterator.updated();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testRemindersWithItems() {
        Date date = DateRules.getToday();
        Entity reminderType = ReminderTestHelper.createReminderType(1, DateUnits.YEARS, new Lookup[0]);
        Party customer = TestHelper.createCustomer();
        Party patient = TestHelper.createPatient(customer);
        Act email1 = ReminderTestHelper.createEmailReminder(date, date, "PENDING", 0);
        Act sms1 = ReminderTestHelper.createEmailReminder(date, date, "PENDING", 0);
        ReminderTestHelper.createReminder(date, patient, reminderType, "IN_PROGRESS", email1, sms1);
        Act email2 = ReminderTestHelper.createSMSReminder(date, date, "ERROR", 0);
        Act sms2 = ReminderTestHelper.createSMSReminder(date, date, "ERROR", 0);
        ReminderTestHelper.createReminder(date, patient, reminderType, "IN_PROGRESS", email2, sms2);
        Act email3 = ReminderTestHelper.createPrintReminder(date, date, "COMPLETED", 0);
        Act print3 = ReminderTestHelper.createPrintReminder(date, date, "COMPLETED", 0);
        Act reminder3 = ReminderTestHelper.createReminder(date, patient, reminderType, "IN_PROGRESS", email3, print3);
        Act email4 = ReminderTestHelper.createExportReminder(date, date, "CANCELLED", 0);
        Act export4 = ReminderTestHelper.createExportReminder(date, date, "CANCELLED", 0);
        Act reminder4 = ReminderTestHelper.createReminder(date, patient, reminderType, "IN_PROGRESS", email4, export4);
        Act email5 = ReminderTestHelper.createExportReminder(date, date, "PENDING", 0);
        Act sms5 = ReminderTestHelper.createExportReminder(date, date, "COMPLETED", 0);
        ReminderTestHelper.createReminder(date, patient, reminderType, "IN_PROGRESS", email5, sms5);
        ReminderQueueIterator iterator = this.createIterator(DateRules.getTomorrow(), reminderType, 2);
        this.checkIterator((Iterator<Act>)iterator, reminder3, reminder4);
    }

    private void checkIterator(Iterator<Act> iterator, Act ... reminders) {
        List<Act> list = Arrays.asList(reminders);
        ArrayList actual = new ArrayList();
        CollectionUtils.addAll(actual, iterator);
        Assert.assertEquals(list, actual);
    }

    private void checkNext(Iterator<Act> iterator, Act act) {
        Assert.assertTrue((boolean)iterator.hasNext());
        Act next = iterator.next();
        Assert.assertEquals((Object)act, (Object)next);
    }

    private ReminderQueueIterator createIterator(Date date, final Entity reminderType, int pageSize) {
        ReminderQueueQueryFactory factory = new ReminderQueueQueryFactory(){

            public ArchetypeQuery createQuery(Date date) {
                ArchetypeQuery query = super.createQuery(date);
                query.add((IConstraint)Constraints.join((String)"reminderType", (String)"r").add((IConstraint)Constraints.eq((String)"entity", (Object)reminderType)));
                return query;
            }
        };
        return new ReminderQueueIterator(factory, date, pageSize, this.getArchetypeService());
    }
}

