/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.reminder.ReminderQuery;
import org.openvpms.archetype.rules.patient.reminder.ReminderTestHelper;
import org.openvpms.archetype.rules.practice.Location;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.RelationalOp;

public class ReminderQueryTestCase
extends ArchetypeServiceTest {
    @Test
    public void testQuery() {
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        ReminderTestHelper.createReminders(10, reminderType);
        ReminderQuery query = new ReminderQuery(this.getArchetypeService());
        List<Act> reminders = this.getReminders(query);
        for (Act act : reminders) {
            Assert.assertTrue((boolean)TypeHelper.isA((IMObject)act, (String)"act.patientReminder"));
            Assert.assertEquals((Object)"IN_PROGRESS", (Object)act.getStatus());
        }
    }

    @Test
    public void testQueryReminderType() {
        int count = 10;
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        ReminderTestHelper.createReminders(10, reminderType);
        ReminderQuery query = new ReminderQuery(this.getArchetypeService());
        query.setReminderType(reminderType);
        List<Act> reminders = this.getReminders(query);
        Assert.assertEquals((long)10L, (long)reminders.size());
    }

    @Test
    public void testQueryDateRange() {
        int count = 10;
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        Party customer = TestHelper.createCustomer();
        Party patient = TestHelper.createPatient(customer);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1980, 0, 1);
        Date dueFrom = calendar.getTime();
        ((Calendar)calendar).add(6, 10);
        Date dueTo = calendar.getTime();
        for (int i = 0; i < 10; ++i) {
            ReminderTestHelper.createReminderWithDueDate(patient, reminderType, dueFrom);
        }
        int rangeCount = this.countReminders(dueFrom, dueTo, false);
        ReminderQuery query = new ReminderQuery(this.getArchetypeService());
        query.setFrom(dueFrom);
        query.setTo(dueTo);
        List<Act> reminders = this.getReminders(query);
        Assert.assertEquals((long)rangeCount, (long)reminders.size());
    }

    @Test
    public void testQueryReminderTypeDateRange() {
        int count = 10;
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        Date dueTo = null;
        GregorianCalendar calendar = new GregorianCalendar();
        Date dueFrom = calendar.getTime();
        for (int i = 0; i < 10; ++i) {
            ((Calendar)calendar).add(5, i + 1);
            Date dueDate = calendar.getTime();
            Party customer = TestHelper.createCustomer();
            Party patient = TestHelper.createPatient(customer);
            ReminderTestHelper.createReminderWithDueDate(patient, reminderType, dueDate);
            if (i != 4) continue;
            dueTo = dueDate;
        }
        ReminderQuery query = new ReminderQuery(this.getArchetypeService());
        query.setReminderType(reminderType);
        query.setFrom(dueFrom);
        query.setTo(dueTo);
        List<Act> reminders = this.getReminders(query);
        Assert.assertEquals((long)5L, (long)reminders.size());
    }

    @Test
    public void testQueryByCustomer() {
        int count = 10;
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        GregorianCalendar calendar = new GregorianCalendar();
        Party customer = TestHelper.createCustomer();
        for (int i = 0; i < 10; ++i) {
            calendar.set(5, i + 1);
            Date dueDate = calendar.getTime();
            Party patient = TestHelper.createPatient(customer);
            ReminderTestHelper.createReminderWithDueDate(patient, reminderType, dueDate);
        }
        ReminderQuery query = new ReminderQuery(this.getArchetypeService());
        query.setCustomer(customer);
        List<Act> reminders = this.getReminders(query);
        Assert.assertEquals((long)10L, (long)reminders.size());
    }

    @Test
    public void testExcludeInactivePatients() {
        Party customer = TestHelper.createCustomer();
        Party patient1 = TestHelper.createPatient(customer);
        Party patient2 = TestHelper.createPatient(customer);
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        Act reminder1 = ReminderTestHelper.createReminderWithDueDate(patient1, reminderType, DateRules.getTomorrow());
        Act reminder2 = ReminderTestHelper.createReminderWithDueDate(patient2, reminderType, DateRules.getTomorrow());
        ReminderQuery query = new ReminderQuery(this.getArchetypeService());
        query.setCustomer(customer);
        List<Act> reminders1 = this.getReminders(query);
        Assert.assertEquals((long)2L, (long)reminders1.size());
        Assert.assertTrue((boolean)reminders1.contains(reminder1));
        Assert.assertTrue((boolean)reminders1.contains(reminder2));
        IMObjectBean bean = this.getBean((IMObject)customer);
        List owner = bean.getValues("patients", EntityRelationship.class, Predicates.targetEquals((IMObject)patient1));
        Assert.assertEquals((long)1L, (long)owner.size());
        ((EntityRelationship)owner.get(0)).setActiveEndTime(new Date());
        this.save((IMObject[])new Party[]{customer, patient1});
        List<Act> reminders2 = this.getReminders(query);
        Assert.assertEquals((long)1L, (long)reminders2.size());
        Assert.assertFalse((boolean)reminders2.contains(reminder1));
        Assert.assertTrue((boolean)reminders2.contains(reminder2));
    }

    @Test
    public void testQueryByLocation() {
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        Party location1 = TestHelper.createLocation();
        Party location2 = TestHelper.createLocation();
        Party customer1 = this.createCustomer(location1);
        Party customer2 = this.createCustomer(location2);
        Party patient1 = TestHelper.createPatient(customer1);
        Party patient2 = TestHelper.createPatient(customer2);
        Act act1 = ReminderTestHelper.createReminder(patient1, reminderType);
        Act act2 = ReminderTestHelper.createReminder(patient2, reminderType);
        Act act3 = ReminderTestHelper.createReminder(patient2, reminderType);
        this.save((IMObject[])new Act[]{act1, act2, act3});
        ReminderQuery query = new ReminderQuery(this.getArchetypeService());
        query.setLocation(new Location(location1));
        List<Act> reminders = this.getReminders(query);
        Assert.assertEquals((long)1L, (long)reminders.size());
        query.setLocation(new Location(location2));
        reminders = this.getReminders(query);
        Assert.assertEquals((long)2L, (long)reminders.size());
    }

    @Test
    public void testQueryByNoLocation() {
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        Party location = TestHelper.createLocation();
        Party customer1 = this.createCustomer(location);
        Party customer2 = TestHelper.createCustomer();
        Party patient1 = TestHelper.createPatient(customer1);
        Party patient2 = TestHelper.createPatient(customer2);
        Act act1 = ReminderTestHelper.createReminder(patient1, reminderType);
        Act act2 = ReminderTestHelper.createReminder(patient2, reminderType);
        Act act3 = ReminderTestHelper.createReminder(patient2, reminderType);
        this.save((IMObject[])new Act[]{act1, act2, act3});
        ReminderQuery query = new ReminderQuery(this.getArchetypeService());
        query.setLocation(Location.NONE);
        List<Act> reminders = this.getReminders(query);
        Assert.assertFalse((boolean)reminders.contains(act1));
        Assert.assertTrue((boolean)reminders.contains(act2));
        Assert.assertTrue((boolean)reminders.contains(act3));
    }

    private List<Act> getReminders(ReminderQuery query) {
        ArrayList<Act> result = new ArrayList<Act>();
        for (Act set : query.query()) {
            result.add(set);
        }
        return result;
    }

    private int countReminders(Date dueFrom, Date dueTo, boolean noLocation) {
        int result = 0;
        ArchetypeQuery query = new ArchetypeQuery("act.patientReminder", false, true);
        query.add((IConstraint)new NodeConstraint("status", (Object)"IN_PROGRESS"));
        if (dueFrom != null && dueTo != null) {
            query.add((IConstraint)new NodeConstraint("endTime", RelationalOp.BTW, new Object[]{DateRules.getDate((Date)dueFrom), DateRules.getDate((Date)dueTo)}));
        }
        query.add((IConstraint)Constraints.join((String)"reminderType").add((IConstraint)Constraints.join((String)"entity").add((IConstraint)Constraints.eq((String)"active", (Object)true))));
        query.setMaxResults(-1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.getArchetypeService(), (IArchetypeQuery)query);
        while (iterator.hasNext()) {
            IMObjectBean entityBean;
            Party customer;
            IMObjectBean bean = this.getBean((IMObject)iterator.next());
            Party patient = (Party)bean.getTarget("patient", Party.class);
            if (patient == null || (customer = (Party)(entityBean = this.getBean((IMObject)patient)).getSource("customers", Party.class, Policies.any((Predicate)Predicates.isA((String[])new String[]{"entityRelationship.patientOwner"})))) == null) continue;
            if (noLocation) {
                IMObjectBean customerBean = this.getBean((IMObject)customer);
                if (customerBean.getTarget("practice") != null) continue;
                ++result;
                continue;
            }
            ++result;
        }
        return result;
    }

    private Party createCustomer(Party location) {
        Party customer = TestHelper.createCustomer();
        IMObjectBean bean = this.getBean((IMObject)customer);
        bean.setTarget("practice", (IMObject)location);
        bean.save();
        return customer;
    }
}

