/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderProcessor;
import org.openvpms.archetype.rules.patient.reminder.ReminderRule;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderTestHelper;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class ReminderProcessorTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private PatientRules rules;
    private ReminderRules reminderRules;
    private Party customer;
    private Party patient;
    private Entity reminderType;
    private ReminderConfiguration config;

    @Before
    public void setUp() {
        IArchetypeService service = this.getArchetypeService();
        this.reminderRules = new ReminderRules(service, this.rules);
        this.customer = this.customerFactory.createCustomer();
        Assert.assertEquals((long)0L, (long)this.customer.getContacts().size());
        this.patient = TestHelper.createPatient(this.customer);
        this.reminderType = ReminderTestHelper.createReminderType(1, DateUnits.MONTHS, 1, DateUnits.DAYS, new Lookup[0]);
        IMObject object = this.create("entity.reminderConfigurationType");
        IMObjectBean bean = this.getBean(object);
        bean.setValue("emailInterval", (Object)2);
        bean.setValue("emailUnits", (Object)DateUnits.DAYS.toString());
        bean.setValue("smsInterval", (Object)3);
        bean.setValue("smsUnits", (Object)DateUnits.DAYS.toString());
        bean.setValue("printInterval", (Object)1);
        bean.setValue("printUnits", (Object)DateUnits.WEEKS.toString());
        bean.setValue("exportInterval", (Object)2);
        bean.setValue("exportUnits", (Object)DateUnits.WEEKS.toString());
        bean.setValue("listInterval", (Object)1);
        bean.setValue("listUnits", (Object)DateUnits.MONTHS.toString());
        this.config = new ReminderConfiguration(object, (ArchetypeService)this.getArchetypeService());
    }

    @Test
    public void testContact() {
        Entity template = this.createDocumentTemplate();
        ReminderTestHelper.addReminderCount(this.reminderType, 0, 0, DateUnits.DAYS, template, ReminderTestHelper.createContactRule());
        Act reminder = this.createReminderDueTomorrow();
        this.checkProcess(false, false, false, false, true, reminder);
        this.addContacts(this.createEmail(false, true), this.createPhone(true, false, true), this.createLocation(false, true));
        this.checkProcess(false, false, false, false, true, reminder);
        this.addContacts(this.createEmail(true, true));
        this.checkProcess(true, false, false, false, false, reminder);
        this.addContacts(this.createPhone(true, true, true));
        this.checkProcess(true, true, false, false, false, reminder);
        this.addContacts(this.createLocation(true, true));
        this.checkProcess(true, true, true, false, false, reminder);
    }

    @Test
    public void testContactWithPreferred() {
        Entity template = this.createDocumentTemplate();
        ReminderTestHelper.addReminderCount(this.reminderType, 0, 0, DateUnits.DAYS, template, ReminderTestHelper.createContactRule());
        Act reminder = this.createReminderDueTomorrow();
        this.addContacts(this.createEmail(false, true));
        this.addContacts(this.createPhone(true, false, true));
        this.addContacts(this.createPhone(false, false, true));
        this.addContacts(this.createLocation(false, true));
        this.checkProcess(false, false, false, false, true, reminder);
        this.addContacts(this.createEmail(true, false));
        this.checkProcess(true, false, false, false, false, reminder);
        this.clearContacts();
        this.addContacts(this.createEmail(true, true));
        this.checkProcess(true, false, false, false, false, reminder);
        this.clearContacts();
        this.addContacts(this.createPhone(true, true, false));
        this.checkProcess(false, true, false, false, false, reminder);
        this.clearContacts();
        this.addContacts(this.createPhone(true, true, true));
        this.checkProcess(false, true, false, false, false, reminder);
        this.clearContacts();
        this.addContacts(this.createLocation(true, false));
        this.checkProcess(false, false, true, false, false, reminder);
        this.clearContacts();
        this.addContacts(this.createLocation(true, true));
        this.checkProcess(false, false, true, false, false, reminder);
    }

    @Test
    public void testEmail() {
        Entity template = this.createDocumentTemplate();
        ReminderTestHelper.addReminderCount(this.reminderType, 0, 0, DateUnits.DAYS, template, ReminderTestHelper.createEmailRule());
        Act reminder = this.createReminderDueTomorrow();
        this.addContacts(this.createEmail(false, true));
        this.checkProcess(true, false, false, false, false, reminder);
        this.clearContacts();
        this.checkProcess(false, false, false, false, true, reminder);
    }

    @Test
    public void testEmailForNoEmailTemplate() {
        Entity template = this.createDocumentTemplate(false, true);
        ReminderTestHelper.addReminderCount(this.reminderType, 0, 0, DateUnits.DAYS, template, ReminderTestHelper.createEmailRule());
        Act reminder = this.createReminderDueTomorrow();
        this.addContacts(this.createEmail(false, true));
        this.checkProcess(false, false, false, false, true, reminder);
        this.documentFactory.updateTemplate(template).emailTemplate("subject", "text").build();
        this.checkProcess(true, false, false, false, false, reminder);
    }

    @Test
    public void testSMS() {
        Entity template = this.createDocumentTemplate();
        ReminderTestHelper.addReminderCount(this.reminderType, 0, 0, DateUnits.DAYS, template, ReminderTestHelper.createSMSRule());
        Act reminder = this.createReminderDueTomorrow();
        this.addContacts(this.createPhone(true, false, true));
        this.checkProcess(false, true, false, false, false, reminder);
        this.clearContacts();
        this.checkProcess(false, false, false, false, true, reminder);
        this.addContacts(this.createPhone(false, false, true));
        this.checkProcess(false, false, false, false, true, reminder);
    }

    @Test
    public void testSMSForNoSMSTemplate() {
        Entity template = this.createDocumentTemplate(true, false);
        ReminderTestHelper.addReminderCount(this.reminderType, 0, 0, DateUnits.DAYS, template, ReminderTestHelper.createSMSRule());
        Act reminder = this.createReminderDueTomorrow();
        this.addContacts(this.createPhone(true, false, true));
        this.checkProcess(false, false, false, false, true, reminder);
        this.documentFactory.updateTemplate(template).smsTemplate("text").build();
        this.checkProcess(false, true, false, false, false, reminder);
    }

    @Test
    public void testPrint() {
        Entity template = this.createDocumentTemplate(false, false);
        ReminderTestHelper.addReminderCount(this.reminderType, 0, 0, DateUnits.DAYS, template, ReminderTestHelper.createPrintRule());
        Act reminder = this.createReminderDueTomorrow();
        this.addContacts(this.createLocation(false, true));
        this.checkProcess(false, false, true, false, false, reminder);
        this.clearContacts();
        this.checkProcess(false, false, false, false, true, reminder);
    }

    @Test
    public void testPrintForNoPrintTemplate() {
        Entity count = ReminderTestHelper.addReminderCount(this.reminderType, 0, 0, DateUnits.DAYS, null, ReminderTestHelper.createPrintRule());
        Act reminder = this.createReminderDueTomorrow();
        this.addContacts(this.createLocation(false, true));
        this.checkProcess(false, false, false, false, true, reminder);
        IMObjectBean bean = this.getBean((IMObject)count);
        bean.setTarget("template", (IMObject)this.createDocumentTemplate(false, false));
        bean.save();
        this.checkProcess(false, false, true, false, false, reminder);
    }

    @Test
    public void testProcessExport() {
        Entity template = this.createDocumentTemplate(false, false);
        ReminderTestHelper.addReminderCount(this.reminderType, 0, 0, DateUnits.DAYS, template, ReminderTestHelper.createExportRule());
        Act reminder = this.createReminderDueTomorrow();
        this.addContacts(this.createLocation(false, true));
        this.checkProcess(false, false, false, true, false, reminder);
        this.clearContacts();
        this.checkProcess(false, false, false, false, true, reminder);
    }

    @Test
    public void testProcessList() {
        Entity template = this.createDocumentTemplate(false, false);
        ReminderTestHelper.addReminderCount(this.reminderType, 0, 0, DateUnits.DAYS, template, ReminderTestHelper.createListRule());
        Act reminder = this.createReminderDueTomorrow();
        this.checkProcess(false, false, false, false, true, reminder);
    }

    @Test
    public void testListForNoReminderCount() {
        Act reminder = this.createReminderDueTomorrow();
        this.checkProcess(false, false, false, false, true, reminder);
    }

    @Test
    public void testSkipForNoReminderCountGreaterThanZero() {
        Act reminder = this.createReminderDueTomorrow();
        IMObjectBean bean = this.getBean((IMObject)reminder);
        bean.setValue("reminderCount", (Object)1);
        List<Act> acts = this.process(reminder);
        Assert.assertEquals((long)0L, (long)acts.size());
    }

    @Test
    public void testCancelForInactiveCustomer() {
        Act reminder = this.createReminderDueTomorrow();
        this.customer.setActive(false);
        this.save((IMObject)this.customer);
        List<Act> acts = this.process(reminder);
        Assert.assertEquals((long)1L, (long)acts.size());
        Assert.assertTrue((boolean)TypeHelper.isA((IMObject)((IMObject)acts.get(0)), (String)"act.patientReminder"));
        Assert.assertEquals((Object)"CANCELLED", (Object)acts.get(0).getStatus());
    }

    @Test
    public void testCancelForNoCustomer() {
        Act reminder = this.createReminderDueTomorrow();
        this.remove((IMObject)this.customer);
        List<Act> acts = this.process(reminder);
        Assert.assertEquals((long)1L, (long)acts.size());
        Assert.assertTrue((boolean)TypeHelper.isA((IMObject)((IMObject)acts.get(0)), (String)"act.patientReminder"));
        Assert.assertEquals((Object)"CANCELLED", (Object)acts.get(0).getStatus());
    }

    @Test
    public void testCancelForInactiveReminderType() {
        Act reminder = this.createReminderDueTomorrow();
        this.reminderType.setActive(false);
        this.save((IMObject)this.reminderType);
        List<Act> acts = this.process(reminder);
        Assert.assertEquals((long)1L, (long)acts.size());
        Assert.assertTrue((boolean)TypeHelper.isA((IMObject)((IMObject)acts.get(0)), (String)"act.patientReminder"));
        Assert.assertEquals((Object)"CANCELLED", (Object)acts.get(0).getStatus());
    }

    @Test
    public void testCancelForPastDue() {
        Act reminder = this.createReminder(DateRules.getYesterday());
        Assert.assertTrue((boolean)this.reminderRules.shouldCancel(reminder, new Date()));
        List<Act> acts = this.process(reminder);
        Assert.assertEquals((long)1L, (long)acts.size());
        Assert.assertTrue((boolean)TypeHelper.isA((IMObject)((IMObject)acts.get(0)), (String)"act.patientReminder"));
        Assert.assertEquals((Object)"CANCELLED", (Object)acts.get(0).getStatus());
    }

    @Test
    public void testCancelForDeceased() {
        Act reminder = this.createReminderDueTomorrow();
        this.rules.setDeceased(this.patient);
        this.save((IMObject)this.patient);
        this.addContacts(this.createLocation(false, true));
        List<Act> acts = this.process(reminder);
        Assert.assertEquals((long)1L, (long)acts.size());
        Assert.assertTrue((boolean)TypeHelper.isA((IMObject)((IMObject)acts.get(0)), (String)"act.patientReminder"));
        Assert.assertEquals((Object)"CANCELLED", (Object)acts.get(0).getStatus());
    }

    @Test
    public void testMultipleCounts() {
        Entity template = this.createDocumentTemplate();
        Entity allRule = ReminderTestHelper.createRule(false, true, true, true, true, true, ReminderRule.SendTo.ALL);
        ReminderTestHelper.addReminderCount(this.reminderType, 0, 0, DateUnits.DAYS, template, allRule);
        ReminderTestHelper.addReminderCount(this.reminderType, 1, 1, DateUnits.WEEKS, template, allRule);
        ReminderTestHelper.addReminderCount(this.reminderType, 2, 2, DateUnits.MONTHS, template, allRule);
        ReminderTestHelper.addReminderCount(this.reminderType, 3, 3, DateUnits.YEARS, template, allRule);
        Act reminder = this.createReminderDueTomorrow();
        this.addContacts(this.createEmail(false, true), this.createPhone(true, false, true), this.createLocation(false, true));
        this.checkProcess(true, true, true, true, true, reminder);
        this.completeItems(reminder, 0);
        this.checkProcess(true, true, true, true, true, reminder);
        this.completeItems(reminder, 1);
        this.checkProcess(true, true, true, true, true, reminder);
        this.completeItems(reminder, 2);
        this.checkProcess(true, true, true, true, true, reminder);
        this.completeItems(reminder, 3);
        List<Act> acts = this.process(reminder);
        Assert.assertTrue((boolean)acts.isEmpty());
    }

    @Test
    public void testPhoneContactWithAlLRulesExceptExport() {
        this.addContacts(this.createPhone(false, true, true));
        Entity template = this.createDocumentTemplate(false, false);
        Entity rule = ReminderTestHelper.createRule(true, true, true, true, false, true, ReminderRule.SendTo.ANY);
        ReminderTestHelper.addReminderCount(this.reminderType, 0, 0, DateUnits.DAYS, template, rule);
        Act reminder = this.createReminderDueTomorrow();
        this.checkProcess(false, false, false, false, true, reminder);
    }

    private Entity createDocumentTemplate() {
        return this.createDocumentTemplate(true, true);
    }

    private Entity createDocumentTemplate(boolean email, boolean sms) {
        TestDocumentTemplateBuilder builder = (TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.patientDocumentForm").document("/documents/vaccination first reminder.odt", "application/vnd.oasis.opendocument.text");
        if (email) {
            builder.emailTemplate("subject", "text");
        }
        if (sms) {
            builder.smsTemplate("text");
        }
        return (Entity)builder.build();
    }

    private void completeItems(Act reminder, int count) {
        IMObjectBean bean = this.getBean((IMObject)reminder);
        Assert.assertEquals((long)count, (long)bean.getInt("reminderCount"));
        List items = bean.getTargets("items", Act.class);
        for (Act item : items) {
            IMObjectBean itemBean = this.getBean((IMObject)item);
            if (itemBean.getInt("count") != count) continue;
            item.setStatus("COMPLETED");
            this.save((IMObject)item);
            if (!this.reminderRules.updateReminder(reminder, item)) continue;
            this.save((IMObject[])new Act[]{reminder, item});
        }
        Assert.assertEquals((long)(count + 1), (long)bean.getInt("reminderCount"));
    }

    private void addContacts(Contact ... contacts) {
        for (Contact contact : contacts) {
            this.customer.addContact(contact);
        }
        this.save((IMObject)this.customer);
    }

    private void clearContacts() {
        this.customer.getContacts().clear();
        this.save((IMObject)this.customer);
    }

    private Act createReminder(Date due) {
        return ReminderTestHelper.createReminder(due, this.patient, this.reminderType, new Act[0]);
    }

    private Act createReminderDueTomorrow() {
        return this.createReminder(DateRules.getTomorrow());
    }

    private void checkProcess(boolean email, boolean sms, boolean print, boolean export, boolean list, Act reminder) {
        List<Act> acts = this.process(reminder);
        Assert.assertFalse((boolean)acts.isEmpty());
        this.save(acts);
        ReminderType type = new ReminderType(this.reminderType, (ArchetypeService)this.getArchetypeService());
        this.checkActs(reminder, type, acts, "act.patientReminderItemEmail", email);
        this.checkActs(reminder, type, acts, "act.patientReminderItemSMS", sms);
        this.checkActs(reminder, type, acts, "act.patientReminderItemPrint", print);
        this.checkActs(reminder, type, acts, "act.patientReminderItemExport", export);
        this.checkActs(reminder, type, acts, "act.patientReminderItemList", list);
    }

    private void checkActs(Act reminder, ReminderType type, List<Act> acts, String shortName, boolean exists) {
        Act item = null;
        for (Act act : acts) {
            if (!TypeHelper.isA((IMObject)act, (String)shortName)) continue;
            if (item != null) {
                Assert.fail((String)(shortName + " found more than once"));
            } else if (!exists) {
                Assert.fail((String)(shortName + " found"));
            }
            item = act;
        }
        if (item != null) {
            IMObjectBean bean = this.getBean((IMObject)reminder);
            int reminderCount = bean.getInt("reminderCount");
            IMObjectBean itemBean = this.getBean((IMObject)item);
            Assert.assertEquals((long)reminderCount, (long)itemBean.getInt("count"));
            Date dueDate = type.getNextDueDate(reminder.getActivityEndTime(), reminderCount);
            if (dueDate == null) {
                dueDate = reminder.getActivityStartTime();
            }
            Date sendDate = this.config.getSendDate(dueDate, shortName);
            Assert.assertEquals((Object)sendDate, (Object)item.getActivityStartTime());
        }
    }

    private List<Act> process(Act reminder) {
        ReminderProcessor processor = new ReminderProcessor(new Date(), this.config, false, this.getArchetypeService(), this.rules);
        return processor.process(reminder);
    }

    private Contact createLocation(boolean addReminderPurpose, boolean preferred) {
        Contact contact = TestHelper.createLocationContact("Foo", "ELTHAM", "VIC", "3095");
        IMObjectBean bean = this.getBean((IMObject)contact);
        bean.setValue("preferred", (Object)preferred);
        if (addReminderPurpose) {
            this.addReminderPurpose(contact);
        }
        return contact;
    }

    private Contact createEmail(boolean addReminderPurpose, boolean preferred) {
        Contact contact = TestHelper.createEmailContact("foo@bar.com", preferred, null);
        if (addReminderPurpose) {
            this.addReminderPurpose(contact);
        }
        return contact;
    }

    private Contact createPhone(boolean sms, boolean addReminderPurpose, boolean preferred) {
        Contact contact = TestHelper.createPhoneContact("03", "1234566789", sms, preferred, null);
        if (addReminderPurpose) {
            this.addReminderPurpose(contact);
        }
        return contact;
    }

    private void addReminderPurpose(Contact contact) {
        contact.addClassification(TestHelper.getLookup("lookup.contactPurpose", "REMINDER"));
    }
}

