/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.rules.patient.reminder.ReminderCSVExporter;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderTestHelper;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;

public class ReminderCSVExporterTestCase
extends ArchetypeServiceTest {
    private ReminderCSVExporter exporter;
    private DocumentHandlers handlers;
    private Party location;
    private Party practice;

    @Before
    public void setUp() {
        IArchetypeService service = this.getArchetypeService();
        this.practice = this.create("party.organisationPractice", Party.class);
        PracticeRules practiceRules = new PracticeRules((ArchetypeService)service, null);
        PracticeService practiceService = new PracticeService(service, practiceRules, null){

            public synchronized Party getPractice() {
                return ReminderCSVExporterTestCase.this.practice;
            }
        };
        LookupService lookups = this.getLookupService();
        PartyRules partyRules = new PartyRules(service, lookups);
        PatientRules patientRules = new PatientRules(practiceRules, practiceService, service, lookups);
        AppointmentRules appointmentRules = new AppointmentRules(service);
        this.handlers = new DocumentHandlers((ArchetypeService)this.getArchetypeService());
        this.exporter = new ReminderCSVExporter(practiceService, partyRules, patientRules, appointmentRules, service, this.handlers);
        this.location = TestHelper.createLocation();
    }

    @Test
    public void testCSVExport() throws IOException {
        Party customer = this.createCustomer("Foo", "F", "Bar", "Embedded, Commas");
        this.checkExport(customer, true);
    }

    @Test
    public void testTabExport() throws IOException {
        Party customer = this.createCustomer("Foo", "F", "Bar", "Embedded\tTabs");
        this.checkExport(customer, false);
    }

    @Test
    public void testEmbeddedQuotes() throws IOException {
        Party customer = this.createCustomer("Foo", "F", "Bar", "\"Embedded Quotes\"");
        this.checkExport(customer, true);
    }

    private void checkExport(Party customer, boolean commaSeparated) throws IOException {
        IMObjectBean practiceBean = this.getBean((IMObject)this.practice);
        practiceBean.setValue("fileExportFormat", (Object)(commaSeparated ? "COMMA" : "TAB"));
        if (commaSeparated) {
            Assert.assertEquals((long)44L, (long)this.exporter.getSeparator());
        } else {
            Assert.assertEquals((long)9L, (long)this.exporter.getSeparator());
        }
        Contact address = TestHelper.createLocationContact("Twenty Second Avenue", "SAWTELL", "Sawtell", "NSW", "New South Wales", "2452");
        customer.addContact(address);
        customer.addContact(TestHelper.createPhoneContact("03", "1234 5678"));
        Contact mobile = TestHelper.createPhoneContact(null, "5678 1234");
        IMObjectBean phoneBean = this.getBean((IMObject)mobile);
        phoneBean.setValue("sms", (Object)true);
        phoneBean.setValue("preferred", (Object)false);
        customer.addContact(mobile);
        customer.addContact(TestHelper.createEmailContact("foo@bar.com"));
        Party patient = this.createPatient(customer);
        PatientTestHelper.createWeight(patient, TestHelper.getDate("2014-01-01"), BigDecimal.ONE, WeightUnits.KILOGRAMS);
        PatientTestHelper.createWeight(patient, TestHelper.getDate("2015-01-01"), BigDecimal.TEN, WeightUnits.KILOGRAMS);
        Party schedule = ScheduleTestHelper.createSchedule(this.location);
        java.util.Date start1 = DateRules.getYesterday();
        java.util.Date start2 = DateRules.getTomorrow();
        java.util.Date start3 = DateRules.getDate((java.util.Date)DateRules.getNextDate((java.util.Date)start2), (int)15, (DateUnits)DateUnits.HOURS);
        Act appointment1 = ScheduleTestHelper.createAppointment(start1, DateRules.getDate((java.util.Date)start1, (int)15, (DateUnits)DateUnits.MINUTES), (Entity)schedule, customer, patient);
        Act appointment2 = ScheduleTestHelper.createAppointment(start2, DateRules.getDate((java.util.Date)start2, (int)15, (DateUnits)DateUnits.MINUTES), (Entity)schedule, customer, patient);
        Act appointment3 = ScheduleTestHelper.createAppointment(start3, DateRules.getDate((java.util.Date)start2, (int)15, (DateUnits)DateUnits.MINUTES), (Entity)schedule, customer, patient);
        appointment1.setStatus("PENDING");
        appointment2.setStatus("CANCELLED");
        appointment3.setStatus("CONFIRMED");
        this.save((IMObject[])new Act[]{appointment1, appointment2, appointment3});
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        Act reminder = ReminderTestHelper.createReminder(patient, reminderType);
        IMObjectBean reminderBean = this.getBean((IMObject)reminder);
        reminderBean.setValue("lastSent", (Object)TestHelper.getDate("2013-06-05"));
        reminderBean.save();
        ReminderEvent event = this.createReminderEvent(customer, address, patient, reminderType, reminder);
        Document document = this.exporter.export(Collections.singletonList(event), new java.util.Date());
        List<String[]> lines = this.readCSV(document);
        Assert.assertNotNull(lines);
        Assert.assertEquals((long)2L, (long)lines.size());
        Assert.assertArrayEquals((Object[])ReminderCSVExporter.HEADER, (Object[])lines.get(0));
        IMObjectBean bean = this.getBean((IMObject)customer);
        String firstName = bean.getString("firstName");
        String initials = bean.getString("initials");
        String lastName = bean.getString("lastName");
        String companyName = bean.getString("companyName");
        String startTime = ReminderCSVExporter.getDateTime((java.util.Date)start3);
        Object[] expected = new String[]{this.getId((IMObject)customer), "Mr", firstName, initials, lastName, companyName, "Twenty Second Avenue", "Sawtell", "New South Wales", "2452", "(03) 1234 5678", "5678 1234", "foo@bar.com", this.getId((IMObject)patient), patient.getName(), "Canine", "Kelpie", "Male", "Black", "2013-02-01", this.getId((IMObject)reminderType), reminderType.getName(), this.getDate(reminder.getActivityEndTime()), "0", "2013-06-05", "10", "KILOGRAMS", "2015-01-01", this.location.getName(), startTime};
        Assert.assertArrayEquals((Object[])expected, (Object[])lines.get(1));
    }

    private ReminderEvent createReminderEvent(Party customer, Contact contact, Party patient, Entity reminderType, Act reminder) {
        Act item = this.create("act.patientReminderItemExport", Act.class);
        ReminderEvent event = new ReminderEvent(reminder, item, patient, customer);
        event.setContact(contact);
        event.setReminderType(reminderType);
        return event;
    }

    private Party createCustomer(String firstName, String initials, String lastName, String companyName) {
        Party customer = this.create("party.customerperson", Party.class);
        IMObjectBean bean = this.getBean((IMObject)customer);
        TestHelper.getLookup("lookup.personTitle", "MR", "Mr", true);
        bean.setValue("title", (Object)"MR");
        bean.setValue("firstName", (Object)firstName);
        bean.setValue("initials", (Object)initials);
        bean.setValue("lastName", (Object)lastName);
        bean.setValue("companyName", (Object)companyName);
        bean.setTarget("practice", (IMObject)this.location);
        bean.save();
        return customer;
    }

    private List<String[]> readCSV(Document document) throws IOException {
        InputStreamReader reader = new InputStreamReader(this.handlers.get(document).getContent(document));
        CSVReader csv = new CSVReader((Reader)reader, this.exporter.getSeparator());
        return csv.readAll();
    }

    private Party createPatient(Party customer) {
        Lookup species = TestHelper.getLookup("lookup.species", "CANINE", "Canine", true);
        TestHelper.getLookup("lookup.breed", "KELPIE", "Kelpie", species, "lookupRelationship.speciesBreed");
        Party patient = TestHelper.createPatient(customer);
        IMObjectBean patientBean = this.getBean((IMObject)patient);
        patientBean.setValue("breed", (Object)"KELPIE");
        patientBean.setValue("sex", (Object)"MALE");
        patientBean.setValue("dateOfBirth", (Object)TestHelper.getDate("2013-02-01"));
        patientBean.setValue("colour", (Object)"Black");
        patientBean.save();
        return patient;
    }

    private String getDate(java.util.Date date) {
        return new Date(date.getTime()).toString();
    }

    private String getId(IMObject object) {
        return Long.toString(object.getId());
    }
}

