/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.prescription;

import java.util.Date;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;

public class PrescriptionTestHelper {
    public static Act createPrescription(Party patient, Product product, User clinician) {
        return PrescriptionTestHelper.createPrescription(patient, product, clinician, 1);
    }

    public static Act createPrescription(Party patient, Product product, User clinician, int quantity) {
        return PrescriptionTestHelper.createPrescription(patient, product, clinician, quantity, 5, DateRules.getDate((Date)new Date(), (int)1, (DateUnits)DateUnits.YEARS));
    }

    public static Act createPrescription(Party patient, Product product, User clinician, int quantity, int repeats, Date expiryDate) {
        Act act = (Act)TestHelper.create("act.patientPrescription");
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        bean.setValue("quantity", (Object)quantity);
        bean.setValue("repeats", (Object)repeats);
        bean.setValue("endTime", (Object)expiryDate);
        bean.setTarget("patient", (IMObject)patient);
        bean.setTarget("product", (IMObject)product);
        bean.setTarget("clinician", (IMObject)clinician);
        bean.save();
        return act;
    }
}

