/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient;

import java.util.Date;
import org.junit.After;
import org.junit.Test;
import org.openvpms.archetype.i18n.time.DurationFormatterTestHelper;
import org.openvpms.archetype.rules.patient.PatientAgeFormatter;
import org.openvpms.archetype.rules.patient.PatientAgeFormatterTestCase;
import org.openvpms.archetype.rules.patient.RefreshablePatientAgeFormatter;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class RefreshablePatientAgeFormatterTestCase
extends PatientAgeFormatterTestCase {
    private RefreshablePatientAgeFormatter formatter;

    @After
    public void tearDown() {
        if (this.formatter != null) {
            this.formatter.destroy();
        }
    }

    @Test
    public void testRefresh() {
        Party practice = TestHelper.getPractice();
        this.setPracticeFormat(practice, null);
        PatientAgeFormatter formatter = this.createFormatter();
        Date from = TestHelper.getDate("2011-01-01");
        Date to = TestHelper.getDate("2013-02-02");
        this.checkFormat("2 Years", from, to, formatter);
        Lookup formats = DurationFormatterTestHelper.createDurationFormats();
        Lookup format = DurationFormatterTestHelper.addFormat(formats, 2, DateUnits.YEARS, true, true, false, false);
        this.checkFormat("2 Years", from, to, formatter);
        this.setPracticeFormat(practice, formats);
        this.checkFormat("2 Years 1 Month", from, to, formatter);
        IMObjectBean bean = this.getBean((IMObject)format);
        bean.setValue("showDays", (Object)true);
        bean.save();
        this.checkFormat("2 Years 1 Month 1 Day", from, to, formatter);
        this.remove((IMObject)format);
        this.checkFormat("2 Years", from, to, formatter);
    }

    @Override
    protected PatientAgeFormatter createFormatter() {
        IArchetypeService service = this.getArchetypeService();
        PracticeRules rules = new PracticeRules((ArchetypeService)service, null);
        this.formatter = new RefreshablePatientAgeFormatter(this.getLookupService(), rules, service);
        return this.formatter;
    }
}

