/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.finance.discount.DiscountTestHelper;
import org.openvpms.archetype.rules.party.AbstractPartyMergerTest;
import org.openvpms.archetype.rules.party.MergeException;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class PatientMergerTestCase
extends AbstractPartyMergerTest {
    @Autowired
    private PatientRules rules;
    private TransactionTemplate template;

    @Test
    public void testMergeOwnerRelationships() {
        Party owner1 = TestHelper.createCustomer();
        Party owner2 = TestHelper.createCustomer();
        Party from = TestHelper.createPatient();
        Party to = TestHelper.createPatient();
        EntityRelationship owner1Rel = this.rules.addPatientOwnerRelationship(owner1, from);
        EntityRelationship owner2Rel = this.rules.addPatientOwnerRelationship(owner2, to);
        owner1Rel.setActiveStartTime(new Date(System.currentTimeMillis() - 60000L));
        Assert.assertTrue((boolean)owner1Rel.getActiveStartTime().before(owner2Rel.getActiveStartTime()));
        Party merged = this.checkMerge(from, to);
        owner1 = this.get(owner1);
        owner2 = this.get(owner2);
        Assert.assertTrue((boolean)this.rules.isOwner(owner2, merged));
        Assert.assertFalse((boolean)this.rules.isOwner(owner1, merged));
    }

    @Test
    public void testMergeEntityIdentities() {
        Party from = TestHelper.createPatient();
        Party to = TestHelper.createPatient();
        EntityIdentity id1 = this.createIdentity("ABC1234");
        from.addIdentity(id1);
        EntityIdentity id2 = this.createIdentity("XYZ1234");
        to.addIdentity(id2);
        Party merged = this.checkMerge(from, to);
        EntityIdentity[] identities = merged.getIdentities().toArray(new EntityIdentity[merged.getIdentities().size()]);
        String idA = identities[0].getIdentity();
        String idB = identities[1].getIdentity();
        Assert.assertTrue((id1.getIdentity().equals(idA) || id1.getIdentity().equals(idB) ? 1 : 0) != 0);
        Assert.assertTrue((id2.getIdentity().equals(idA) || id2.getIdentity().equals(idB) ? 1 : 0) != 0);
    }

    @Test
    public void testMergeParticipations() {
        Party customer = TestHelper.createCustomer();
        Party from = TestHelper.createPatient();
        Party to = TestHelper.createPatient();
        Product product = TestHelper.createProduct();
        Assert.assertEquals((long)0L, (long)this.countParticipations(from));
        Assert.assertEquals((long)0L, (long)this.countParticipations(to));
        for (int i = 0; i < 10; ++i) {
            List<FinancialAct> invoice = FinancialTestHelper.createChargesInvoice((BigDecimal)new Money(100), customer, from, product, "POSTED");
            this.save(invoice);
        }
        int fromRefs = this.countParticipations(from);
        Assert.assertTrue((fromRefs >= 10 ? 1 : 0) != 0);
        this.checkMerge(from, to);
        Assert.assertEquals((long)0L, (long)this.countParticipations(from));
        int toRefs = this.countParticipations(to);
        Assert.assertEquals((long)toRefs, (long)fromRefs);
    }

    @Test
    public void testMergeDiscounts() {
        Party from = TestHelper.createPatient();
        Party to = TestHelper.createPatient();
        Entity discount = this.createDiscount();
        IMObjectBean bean = this.getBean((IMObject)from);
        bean.addTarget("discounts", (IMObject)discount);
        bean.save();
        Party merged = this.checkMerge(from, to);
        bean = this.getBean((IMObject)merged);
        List discounts = bean.getTargets("discounts");
        Assert.assertEquals((long)1L, (long)discounts.size());
        Assert.assertEquals((Object)discount, discounts.get(0));
    }

    @Test
    public void testMergeDesexed() {
        Party from1 = TestHelper.createPatient();
        Party to1 = TestHelper.createPatient();
        Party merged1 = this.checkMerge(from1, to1);
        Assert.assertFalse((boolean)this.rules.isDesexed(merged1));
        Party from2 = TestHelper.createPatient();
        Party to2 = TestHelper.createPatient();
        this.rules.setDesexed(from2);
        Party merged2 = this.checkMerge(from2, to2);
        Assert.assertTrue((boolean)this.rules.isDesexed(merged2));
        Party from3 = TestHelper.createPatient();
        Party to3 = TestHelper.createPatient();
        this.rules.setDesexed(to3);
        Party merged3 = this.checkMerge(from3, to3);
        Assert.assertTrue((boolean)this.rules.isDesexed(merged3));
    }

    @Test
    public void testMergeDeceased() {
        Party from1 = TestHelper.createPatient();
        Party to1 = TestHelper.createPatient();
        this.rules.setDeceased(from1);
        Party merged1 = this.checkMerge(from1, to1);
        Assert.assertTrue((boolean)this.rules.isDeceased(merged1));
        Party from2 = TestHelper.createPatient();
        Party to2 = TestHelper.createPatient();
        this.rules.setDeceased(to2);
        Party merged2 = this.checkMerge(from2, to2);
        Assert.assertTrue((boolean)this.rules.isDeceased(merged2));
    }

    @Test
    public void testMergeInvalidParty() {
        Party from = TestHelper.createPatient();
        Party to = TestHelper.createCustomer();
        try {
            this.checkMerge(from, to);
            Assert.fail((String)"Expected merge to invalid party to fail");
        }
        catch (MergeException expected) {
            Assert.assertEquals((Object)MergeException.ErrorCode.InvalidType, (Object)expected.getErrorCode());
        }
    }

    @Test
    public void testMergeToSamePatient() {
        Party from = TestHelper.createPatient();
        try {
            this.checkMerge(from, from);
            Assert.fail((String)"Expected merge to same patient to fail");
        }
        catch (MergeException expected) {
            Assert.assertEquals((Object)MergeException.ErrorCode.CannotMergeToSameObject, (Object)expected.getErrorCode());
        }
    }

    @Before
    public void setUp() {
        PlatformTransactionManager mgr = (PlatformTransactionManager)this.applicationContext.getBean("txnManager");
        this.template = new TransactionTemplate(mgr);
    }

    private Party checkMerge(final Party from, final Party to) {
        this.template.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus transactionStatus) {
                PatientMergerTestCase.this.rules.mergePatients(from, to);
                return null;
            }
        });
        Assert.assertNull((Object)this.get(from));
        Party merged = this.get(to);
        Assert.assertNotNull((Object)merged);
        return merged;
    }

    private EntityIdentity createIdentity(String identity) {
        EntityIdentity id = this.create("entityIdentity.petTag", EntityIdentity.class);
        id.setIdentity(identity);
        return id;
    }

    private Entity createDiscount() {
        return DiscountTestHelper.createDiscount(BigDecimal.TEN, true, "PERCENTAGE");
    }
}

