/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.till;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.till.TillRuleException;

public class TillRuleExceptionTestCase {
    @Test
    public void testMessages() {
        Assert.assertEquals((String)"Need to update tests to incorporate new messages", (long)13L, (long)TillRuleException.ErrorCode.values().length);
        this.checkException(TillRuleException.ErrorCode.InvalidTillArchetype, "foo is not a valid till act", "foo");
        this.checkException(TillRuleException.ErrorCode.MissingTill, "No till specified in act foo", "foo");
        this.checkException(TillRuleException.ErrorCode.UnclearedTillExists, "Cannot save till balance. An uncleared till exists for till foo", "foo");
        this.checkException(TillRuleException.ErrorCode.ClearedTill, "Cannot modify Cleared till", new Object[0]);
        this.checkException(TillRuleException.ErrorCode.CantAddActToTill, "Cannot add acts of type foo to till", "foo");
        this.checkException(TillRuleException.ErrorCode.TillNotFound, "Failed to retrieve till foo", "foo");
        this.checkException(TillRuleException.ErrorCode.BalanceNotFound, "Failed to retrieve till balance", new Object[0]);
        this.checkException(TillRuleException.ErrorCode.MissingRelationship, "No act relationship found", new Object[0]);
        this.checkException(TillRuleException.ErrorCode.InvalidTransferTill, "Cannot transfer to till foo", "foo");
        this.checkException(TillRuleException.ErrorCode.InvalidStatusForStartClear, "Cannot start clearing till with status foo", "foo");
        this.checkException(TillRuleException.ErrorCode.InvalidStatusForClear, "Cannot clear till with status foo", "foo");
        this.checkException(TillRuleException.ErrorCode.ClearInProgress, "Cannot clear this Till Balance. Another Till Balance is being cleared.", new Object[0]);
        this.checkException(TillRuleException.ErrorCode.DifferentTills, "Cannot add foo to Till Balance. The tills are different", "foo");
    }

    private void checkException(TillRuleException.ErrorCode code, String expected, Object ... args) {
        TillRuleException exception = new TillRuleException(code, args);
        Assert.assertEquals((Object)code, (Object)exception.getErrorCode());
        Assert.assertEquals((Object)expected, (Object)exception.getMessage());
    }
}

