/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.tax;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.tax.CustomerTaxRules;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;

public class CustomerTaxRulesTestCase
extends ArchetypeServiceTest {
    private Lookup taxType;
    private CustomerTaxRules rules;
    private Party practice;

    @Test
    public void testCalculateTaxForNoTaxes() {
        Party customer = TestHelper.createCustomer();
        Product product = TestHelper.createProduct();
        this.checkCalculateTax(customer, product, BigDecimal.ZERO);
    }

    @Test
    public void testCalculateTaxForProductTax() {
        Party customer = TestHelper.createCustomer();
        Product product = TestHelper.createProduct();
        product.addClassification(this.taxType);
        this.save((IMObject)product);
        this.checkCalculateTax(customer, product, new BigDecimal("0.091"));
    }

    @Test
    public void testCalculateTaxForProductTypeTax() {
        Party customer = TestHelper.createCustomer();
        Product product = this.createProductWithProductTypeTax();
        this.checkCalculateTax(customer, product, new BigDecimal("0.091"));
    }

    @Test
    public void testGetTaxExemptions() {
        Party customer = TestHelper.createCustomer();
        Assert.assertTrue((boolean)this.rules.getTaxExemptions(customer).isEmpty());
        customer.addClassification(this.taxType);
        List exemptions = this.rules.getTaxExemptions(customer);
        Assert.assertEquals((long)1L, (long)exemptions.size());
        Assert.assertTrue((boolean)exemptions.contains(this.taxType));
    }

    @Test
    public void testCalculateTaxForCustomerTaxExemption() {
        Party customer = this.createCustomerWithTaxExemption();
        Product product = this.createProductWithTax();
        this.checkCalculateTax(customer, product, BigDecimal.ZERO);
    }

    @Test
    public void testGetTaxRate() {
        Party customer = TestHelper.createCustomer();
        Product product = TestHelper.createProduct();
        this.checkEquals(BigDecimal.ZERO, this.rules.getTaxRate(product, customer));
        this.practice.addClassification(this.taxType);
        this.rules = new CustomerTaxRules(this.practice, this.getArchetypeService());
        this.checkEquals(BigDecimal.TEN, this.rules.getTaxRate(product, customer));
        customer.addClassification(this.taxType);
        this.checkEquals(BigDecimal.ZERO, this.rules.getTaxRate(product, customer));
    }

    @Before
    public void setUp() {
        this.taxType = TestHelper.createTaxType(BigDecimal.TEN);
        this.practice = this.create("party.organisationPractice", Party.class);
        this.rules = new CustomerTaxRules(this.practice, this.getArchetypeService());
    }

    private void checkCalculateTax(Party customer, Product product, BigDecimal expectedTax) {
        IMObject object = this.create("act.customerAccountInvoiceItem");
        IMObjectBean bean = this.getBean(object);
        bean.setValue("quantity", (Object)BigDecimal.ONE);
        bean.setValue("unitPrice", (Object)BigDecimal.ONE);
        bean.setValue("fixedPrice", (Object)BigDecimal.ZERO);
        bean.setValue("total", (Object)BigDecimal.ONE);
        bean.setTarget("product", (IMObject)product);
        FinancialAct act = (FinancialAct)bean.getObject();
        this.rules.calculateTax(act, customer);
        BigDecimal tax = bean.getBigDecimal("tax");
        this.checkEquals(expectedTax, tax);
    }

    private Party createCustomerWithTaxExemption() {
        Party customer = TestHelper.createCustomer();
        customer.addClassification(this.taxType);
        return customer;
    }

    private Product createProductWithTax() {
        Product product = TestHelper.createProduct();
        product.addClassification(this.taxType);
        this.save((IMObject)product);
        return product;
    }

    private Product createProductWithProductTypeTax() {
        Product product = TestHelper.createProduct();
        Entity type = this.create("entity.productType", Entity.class);
        type.setName("TaxRulesTestCase-entity" + type.hashCode());
        type.addClassification(this.taxType);
        this.save((IMObject)type);
        ProductTestHelper.addProductType(product, type);
        return product;
    }
}

