/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.statement;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.finance.account.AccountType;
import org.openvpms.archetype.rules.finance.statement.AbstractStatementTest;
import org.openvpms.archetype.rules.finance.statement.StatementProcessorException;
import org.openvpms.archetype.rules.finance.statement.StatementRules;
import org.openvpms.archetype.rules.finance.statement.StatementService;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Party;
import org.springframework.beans.factory.annotation.Autowired;

public class StatementServiceTestCase
extends AbstractStatementTest {
    @Autowired
    private LaboratoryRules laboratoryRules;
    private StatementRules rules;
    private StatementService statementService;

    @Before
    public void setUp() {
        Party practice = this.getPractice();
        PracticeService practiceService = (PracticeService)Mockito.mock(PracticeService.class);
        Mockito.when((Object)practiceService.getPractice()).thenReturn((Object)practice);
        this.statementService = new StatementService((IArchetypeRuleService)this.getArchetypeService(), this.accountRules, this.laboratoryRules, practiceService);
        this.rules = new StatementRules(practice, this.getArchetypeService(), this.accountRules);
    }

    @Test
    public void testEndPeriodStatementDate() {
        Party customer = this.customerFactory.createCustomer();
        try {
            this.statementService.endPeriod(customer, DateRules.getToday(), true);
            Assert.fail((String)"Expected StatementProcessorException to be thrown");
        }
        catch (StatementProcessorException expected) {
            Assert.assertEquals((Object)StatementProcessorException.ErrorCode.InvalidStatementDate, (Object)expected.getErrorCode());
        }
        try {
            this.statementService.endPeriod(customer, DateRules.getTomorrow(), true);
            Assert.fail((String)"Expected StatementProcessorException to be thrown");
        }
        catch (StatementProcessorException expected) {
            Assert.assertEquals((Object)StatementProcessorException.ErrorCode.InvalidStatementDate, (Object)expected.getErrorCode());
        }
        Date yesterday = DateRules.getYesterday();
        this.statementService.endPeriod(customer, DateRules.getPreviousDate((Date)yesterday), true);
        this.statementService.endPeriod(customer, yesterday, true);
    }

    @Test
    public void testEndOfPeriod() {
        Lookup accountType = (Lookup)this.customerFactory.newAccountType().paymentTerms(30, DateUnits.DAYS).accountFee(10, AccountType.FeeType.FIXED).accountFeeDays(30).build();
        Party customer = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addClassifications(accountType)).build();
        Date statementDate = this.getDate("2007-01-01");
        Assert.assertFalse((boolean)this.rules.hasStatement(customer, statementDate));
        List<Act> acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)0L, (long)acts.size());
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice1 = this.createChargesInvoice(amount, customer, this.getDatetime("2007-01-01 10:00:00"));
        this.save(invoice1);
        acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)1L, (long)acts.size());
        this.checkAct(acts.get(0), invoice1.get(0), "POSTED");
        this.statementService.endPeriod(customer, statementDate, true);
        Assert.assertTrue((boolean)this.rules.hasStatement(customer, statementDate));
        acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)2L, (long)acts.size());
        this.checkAct(acts.get(0), invoice1.get(0), "POSTED");
        this.checkClosingBalance(acts.get(1), amount, BigDecimal.ZERO);
        this.statementService.endPeriod(customer, statementDate, true);
        acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)2L, (long)acts.size());
        List<FinancialAct> invoice2 = this.createChargesInvoice(amount, customer, this.getDatetime("2007-01-02 10:00:00"));
        this.save(invoice2);
        acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)2L, (long)acts.size());
        statementDate = this.getDate("2007-01-02");
        Assert.assertFalse((boolean)this.rules.hasStatement(customer, statementDate));
        acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)2L, (long)acts.size());
        this.checkOpeningBalance(acts.get(0), new BigDecimal("100"));
        this.checkAct(acts.get(1), invoice2.get(0), "POSTED");
    }
}

