/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.statement;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.AccountType;
import org.openvpms.archetype.rules.finance.statement.AbstractStatementTest;
import org.openvpms.archetype.rules.finance.statement.EndOfPeriodProcessor;
import org.openvpms.archetype.rules.finance.statement.StatementProcessorException;
import org.openvpms.archetype.rules.finance.statement.StatementRules;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.patient.TestInvestigationBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.springframework.beans.factory.annotation.Autowired;

public class EndOfPeriodProcessorTestCase
extends AbstractStatementTest {
    @Autowired
    private LaboratoryRules laboratoryRules;
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testStatementDate() {
        Date now = new Date();
        IArchetypeRuleService service = (IArchetypeRuleService)this.getArchetypeService();
        try {
            new EndOfPeriodProcessor(now, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
            Assert.fail((String)"Expected StatementProcessorException to be thrown");
        }
        catch (StatementProcessorException expected) {
            Assert.assertEquals((Object)StatementProcessorException.ErrorCode.InvalidStatementDate, (Object)expected.getErrorCode());
        }
        try {
            new EndOfPeriodProcessor(DateRules.getYesterday(), true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        }
        catch (StatementProcessorException exception) {
            Assert.fail((String)("Construction failed with exception: " + (Object)((Object)exception)));
        }
    }

    @Test
    public void testEndOfPeriod() {
        IArchetypeRuleService service = (IArchetypeRuleService)this.getArchetypeService();
        StatementRules rules = new StatementRules(this.getPractice(), (IArchetypeService)service, this.accountRules);
        Party customer = this.getCustomer();
        Lookup accountType = (Lookup)this.customerFactory.newAccountType().paymentTerms(30, DateUnits.DAYS).accountFee(10, AccountType.FeeType.FIXED).accountFeeDays(30).build();
        customer.addClassification(accountType);
        this.save((IMObject)customer);
        Date statementDate = this.getDate("2007-01-01");
        Assert.assertFalse((boolean)rules.hasStatement(customer, statementDate));
        List<Act> acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)0L, (long)acts.size());
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice1 = this.createChargesInvoice(amount, this.getDatetime("2007-01-01 10:00:00"));
        this.save(invoice1);
        acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)1L, (long)acts.size());
        this.checkAct(acts.get(0), invoice1.get(0), "POSTED");
        EndOfPeriodProcessor processor = new EndOfPeriodProcessor(statementDate, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        Assert.assertTrue((boolean)rules.hasStatement(customer, statementDate));
        acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)2L, (long)acts.size());
        this.checkAct(acts.get(0), invoice1.get(0), "POSTED");
        this.checkClosingBalance(acts.get(1), amount, BigDecimal.ZERO);
        processor.process(customer);
        acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)2L, (long)acts.size());
        List<FinancialAct> invoice2 = this.createChargesInvoice(amount, this.getDatetime("2007-01-02 10:00:00"));
        this.save(invoice2);
        acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)2L, (long)acts.size());
        statementDate = this.getDate("2007-01-02");
        Assert.assertFalse((boolean)rules.hasStatement(customer, statementDate));
        acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)2L, (long)acts.size());
        this.checkOpeningBalance(acts.get(0), new BigDecimal("100"));
        this.checkAct(acts.get(1), invoice2.get(0), "POSTED");
    }

    @Test
    public void testPostCompleted() {
        IArchetypeRuleService service = (IArchetypeRuleService)this.getArchetypeService();
        Party customer = this.getCustomer();
        Lookup accountType = (Lookup)this.customerFactory.newAccountType().paymentTerms(60, DateUnits.DAYS).accountFee(10, AccountType.FeeType.FIXED).accountFeeDays(60).build();
        customer.addClassification(accountType);
        this.save((IMObject)customer);
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice1 = this.createChargesInvoice(amount, this.getDatetime("2007-01-01 10:00:00"), "COMPLETED");
        this.save(invoice1);
        List<FinancialAct> invoice2 = this.createChargesInvoice(amount, this.getDatetime("2007-01-01 11:00:00"), "IN_PROGRESS");
        this.save(invoice2);
        List<FinancialAct> invoice3 = this.createChargesInvoice(amount, this.getDatetime("2007-01-01 11:00:00"), "ON_HOLD");
        this.save(invoice3);
        List<FinancialAct> invoice4 = this.createChargesInvoice(amount, this.getDatetime("2007-01-01 11:00:00"));
        this.save(invoice4);
        List<FinancialAct> invoice5 = this.createCompletedInvoiceWithInvestigation("PENDING");
        this.save(invoice5);
        List<FinancialAct> invoice6 = this.createCompletedInvoiceWithInvestigation("SENT");
        this.save(invoice6);
        List<FinancialAct> invoice7 = this.createCompletedInvoiceWithOrder("ORDERED");
        List<FinancialAct> invoice8 = this.createCompletedInvoiceWithOrder("DISCONTINUED");
        Date statementDate = this.getDate("2007-02-01");
        EndOfPeriodProcessor processor = new EndOfPeriodProcessor(statementDate, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        List<Act> acts = this.getPostedActs(customer, statementDate);
        Assert.assertEquals((long)5L, (long)acts.size());
        this.checkAct(acts, invoice1.get(0), "POSTED");
        this.checkAct(acts, invoice4.get(0), "POSTED");
        this.checkAct(acts, invoice6.get(0), "POSTED");
        this.checkAct(acts, invoice8.get(0), "POSTED");
        this.checkClosingBalance(acts.get(4), new BigDecimal(400), BigDecimal.ZERO);
        this.checkStatus(invoice2, "IN_PROGRESS");
        this.checkStatus(invoice3, "ON_HOLD");
        this.checkStatus(invoice5, "COMPLETED");
        this.checkStatus(invoice7, "COMPLETED");
    }

    @Test
    public void testNoPostCompleted() {
        IArchetypeRuleService service = (IArchetypeRuleService)this.getArchetypeService();
        Party customer = this.getCustomer();
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice1 = this.createChargesInvoice(amount, this.getDatetime("2007-01-01 10:00:00"), "COMPLETED");
        this.save(invoice1);
        List<FinancialAct> invoice2 = this.createChargesInvoice(amount, this.getDatetime("2007-01-01 11:00:00"), "IN_PROGRESS");
        this.save(invoice2);
        List<FinancialAct> invoice3 = this.createChargesInvoice(amount, this.getDatetime("2007-01-01 11:00:00"), "ON_HOLD");
        this.save(invoice3);
        List<FinancialAct> invoice4 = this.createChargesInvoice(amount, this.getDatetime("2007-01-01 11:00:00"));
        this.save(invoice4);
        Date statementDate = this.getDate("2007-02-01");
        EndOfPeriodProcessor processor = new EndOfPeriodProcessor(statementDate, false, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        List<Act> acts = this.getPostedActs(customer, statementDate);
        Assert.assertEquals((long)2L, (long)acts.size());
        this.checkAct(acts.get(0), invoice4.get(0), "POSTED");
        this.checkClosingBalance(acts.get(1), amount, amount);
    }

    @Test
    public void testEndOfPeriodWithFixedAccountFees() {
        IArchetypeRuleService service = (IArchetypeRuleService)this.getArchetypeService();
        Party customer = this.getCustomer();
        BigDecimal feeAmount = new BigDecimal("25.00");
        Lookup accountType = (Lookup)this.customerFactory.newAccountType().paymentTerms(30, DateUnits.DAYS).accountFee(feeAmount, AccountType.FeeType.FIXED).accountFeeDays(30).build();
        customer.addClassification(accountType);
        this.save((IMObject)customer);
        BigDecimal amount = new BigDecimal(100);
        Date datetime = this.getDatetime("2007-01-01 10:00:00");
        List<FinancialAct> invoice = this.createChargesInvoice(amount, customer, datetime);
        this.save(invoice);
        Date statementDate = DateRules.getDate((Date)datetime, (int)29, (DateUnits)DateUnits.DAYS);
        EndOfPeriodProcessor processor = new EndOfPeriodProcessor(statementDate, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        List<Act> acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)2L, (long)acts.size());
        Assert.assertEquals((Object)invoice.get(0), (Object)acts.get(0));
        FinancialAct closing = (FinancialAct)acts.get(1);
        this.checkClosingBalance((Act)closing, amount, BigDecimal.ZERO);
        Assert.assertTrue((boolean)closing.isCredit());
        statementDate = DateRules.getDate((Date)statementDate, (int)30, (DateUnits)DateUnits.DAYS);
        processor = new EndOfPeriodProcessor(statementDate, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)3L, (long)acts.size());
        BigDecimal closingBalance = amount.add(feeAmount);
        this.checkOpeningBalance(acts.get(0), amount);
        this.checkDebitAdjust(acts.get(1), feeAmount, "Accounting Fee");
        this.checkClosingBalance(acts.get(2), closingBalance, amount);
        this.checkEquals(closingBalance, this.accountRules.getBalance(customer));
    }

    @Test
    public void testEndOfPeriodWithPercentageAccountFees() {
        IArchetypeRuleService service = (IArchetypeRuleService)this.getArchetypeService();
        Party customer = this.getCustomer();
        BigDecimal feePercent = new BigDecimal("1.25");
        Lookup accountType = (Lookup)this.customerFactory.newAccountType().paymentTerms(30, DateUnits.DAYS).accountFee(feePercent, AccountType.FeeType.PERCENTAGE).accountFeeDays(30).accountFeeBalance(0).accountFeeMessage("Test Accounting Fee").build();
        customer.addClassification(accountType);
        this.save((IMObject)customer);
        BigDecimal amount = new BigDecimal(50);
        Date datetime = this.getDatetime("2007-01-01 10:00:00");
        List<FinancialAct> invoice = this.createChargesInvoice(amount, customer, datetime);
        this.save(invoice);
        Date statementDate = DateRules.getDate((Date)datetime, (int)29, (DateUnits)DateUnits.DAYS);
        EndOfPeriodProcessor processor = new EndOfPeriodProcessor(statementDate, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        List<Act> acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)2L, (long)acts.size());
        Assert.assertEquals((Object)invoice.get(0), (Object)acts.get(0));
        FinancialAct closing = (FinancialAct)acts.get(1);
        this.checkClosingBalance((Act)closing, amount, BigDecimal.ZERO);
        Assert.assertTrue((boolean)closing.isCredit());
        statementDate = DateRules.getDate((Date)statementDate, (int)30, (DateUnits)DateUnits.DAYS);
        processor = new EndOfPeriodProcessor(statementDate, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)3L, (long)acts.size());
        BigDecimal feeAmount = new BigDecimal("0.63");
        BigDecimal closingBalance = amount.add(feeAmount);
        this.checkOpeningBalance(acts.get(0), amount);
        this.checkDebitAdjust(acts.get(1), feeAmount, "Test Accounting Fee");
        this.checkClosingBalance(acts.get(2), closingBalance, amount);
        this.checkEquals(closingBalance, this.accountRules.getBalance(customer));
    }

    @Test
    public void testEndOfPeriodForNoActivity() {
        IArchetypeRuleService service = (IArchetypeRuleService)this.getArchetypeService();
        Party customer = this.getCustomer();
        Date statementDate = this.getDate("2007-05-02");
        EndOfPeriodProcessor processor = new EndOfPeriodProcessor(statementDate, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        List<Act> acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)0L, (long)acts.size());
        Date statementDate2 = this.getDate("2007-06-30");
        acts = this.getActs(customer, statementDate2);
        Assert.assertEquals((long)0L, (long)acts.size());
    }

    @Test
    public void testEndOfPeriodForZeroBalance() {
        IArchetypeRuleService service = (IArchetypeRuleService)this.getArchetypeService();
        Party customer = this.getCustomer();
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice = this.createChargesInvoice(amount, this.getDatetime("2007-01-01 10:00:00"));
        this.save(invoice);
        FinancialAct payment = this.createPayment(amount, this.getDatetime("2007-01-01 11:00:00"));
        this.save((IMObject)payment);
        this.checkEquals(BigDecimal.ZERO, this.accountRules.getBalance(customer));
        Date statementDate = this.getDate("2007-05-02");
        EndOfPeriodProcessor processor = new EndOfPeriodProcessor(statementDate, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        List<Act> acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)3L, (long)acts.size());
        this.checkAct(acts.get(0), invoice.get(0), "POSTED");
        this.checkAct(acts.get(1), payment, "POSTED");
        FinancialAct closing = (FinancialAct)acts.get(2);
        this.checkClosingBalance((Act)closing, BigDecimal.ZERO, BigDecimal.ZERO);
        Assert.assertTrue((boolean)closing.isCredit());
        Date statementDate2 = this.getDate("2007-06-30");
        acts = this.getActs(customer, statementDate2);
        Assert.assertEquals((long)1L, (long)acts.size());
        this.checkOpeningBalance(acts.get(0), BigDecimal.ZERO);
    }

    @Test
    public void testEndOfPeriodForCreditBalance() {
        IArchetypeRuleService service = (IArchetypeRuleService)this.getArchetypeService();
        Party customer = this.getCustomer();
        Lookup accountType = (Lookup)this.customerFactory.newAccountType().paymentTerms(30, DateUnits.DAYS).accountFee(10, AccountType.FeeType.FIXED).accountFeeDays(30).build();
        customer.addClassification(accountType);
        this.save((IMObject)customer);
        BigDecimal amount = new BigDecimal(100);
        FinancialAct payment = this.createPayment(amount, this.getDatetime("2007-01-01 11:00:00"));
        this.save((IMObject)payment);
        this.checkEquals(amount.negate(), this.accountRules.getBalance(customer));
        Date statementDate = this.getDate("2007-02-01");
        EndOfPeriodProcessor processor = new EndOfPeriodProcessor(statementDate, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        List<Act> acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)2L, (long)acts.size());
        this.checkAct(acts.get(0), payment, "POSTED");
        FinancialAct closing = (FinancialAct)acts.get(1);
        this.checkClosingBalance((Act)closing, amount, BigDecimal.ZERO);
        Assert.assertFalse((boolean)closing.isCredit());
        Date nextStatementDate = this.getDate("2007-03-01");
        acts = this.getActs(customer, nextStatementDate);
        Assert.assertEquals((long)1L, (long)acts.size());
        FinancialAct opening = (FinancialAct)acts.get(0);
        this.checkOpeningBalance((Act)opening, amount);
        Assert.assertTrue((boolean)opening.isCredit());
        this.checkEquals(amount.negate(), this.accountRules.getBalance(customer));
        processor = new EndOfPeriodProcessor(nextStatementDate, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        acts = this.getActs(customer, nextStatementDate);
        Assert.assertEquals((long)2L, (long)acts.size());
        opening = (FinancialAct)acts.get(0);
        closing = (FinancialAct)acts.get(1);
        this.checkOpeningBalance((Act)opening, amount);
        this.checkClosingBalance((Act)closing, amount, BigDecimal.ZERO);
        Assert.assertTrue((boolean)opening.isCredit());
        Assert.assertFalse((boolean)closing.isCredit());
    }

    @Test
    public void testBackdatedEOP() {
        IArchetypeRuleService service = (IArchetypeRuleService)this.getArchetypeService();
        Party customer = this.getCustomer();
        BigDecimal feeAmount = new BigDecimal("25.00");
        Lookup accountType = (Lookup)this.customerFactory.newAccountType().paymentTerms(30, DateUnits.DAYS).accountFee(feeAmount, AccountType.FeeType.FIXED).accountFeeDays(30).build();
        customer.addClassification(accountType);
        this.save((IMObject)customer);
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice1 = this.createChargesInvoice(amount, customer, this.getDatetime("2007-01-01 10:00:00"));
        this.save(invoice1);
        List<FinancialAct> invoice2 = this.createChargesInvoice(amount, customer, this.getDatetime("2007-02-02 12:00:00"));
        this.save(invoice2);
        Date statementDate1 = this.getDate("2007-02-01");
        EndOfPeriodProcessor processor = new EndOfPeriodProcessor(statementDate1, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        List<Act> acts = this.getActs(customer, statementDate1);
        Assert.assertEquals((long)3L, (long)acts.size());
        BigDecimal balance = amount.add(feeAmount);
        this.checkAct(acts.get(0), invoice1.get(0), "POSTED");
        this.checkAct(acts.get(1), "act.customerAccountDebitAdjust", feeAmount);
        this.checkClosingBalance(acts.get(2), balance, amount);
        Date statementDate2 = this.getDate("2007-03-01");
        acts = this.getActs(customer, statementDate2);
        Assert.assertEquals((long)2L, (long)acts.size());
        this.checkOpeningBalance(acts.get(0), balance);
        this.checkAct(acts.get(1), invoice2.get(0), "POSTED");
        processor = new EndOfPeriodProcessor(statementDate2, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        acts = this.getActs(customer, statementDate2);
        Assert.assertEquals((long)4L, (long)acts.size());
        this.checkOpeningBalance(acts.get(0), balance);
        this.checkAct(acts.get(1), invoice2.get(0), "POSTED");
        this.checkDebitAdjust(acts.get(2), feeAmount, "Accounting Fee");
        balance = balance.multiply(BigDecimal.valueOf(2L));
        this.checkClosingBalance(acts.get(3), balance, amount);
        Date statementDate3 = this.getDate("2008-04-30");
        acts = this.getActs(customer, statementDate3);
        Assert.assertEquals((long)1L, (long)acts.size());
        this.checkOpeningBalance(acts.get(0), balance);
    }

    @Test
    public void testLatePaymentForInvoiceInPriorStatementPeriod() {
        IArchetypeRuleService service = (IArchetypeRuleService)this.getArchetypeService();
        Party customer = this.getCustomer();
        BigDecimal feeAmount = new BigDecimal("10.00");
        Lookup accountType = (Lookup)this.customerFactory.newAccountType().paymentTerms(30, DateUnits.DAYS).accountFee(feeAmount, AccountType.FeeType.FIXED).accountFeeDays(30).build();
        customer.addClassification(accountType);
        this.save((IMObject)customer);
        BigDecimal amount = new BigDecimal("50.00");
        List<FinancialAct> invoice1 = this.createChargesInvoice(amount, customer, this.getDatetime("2008-04-15 10:00:00"));
        this.save(invoice1);
        Date statementDate1 = this.getDate("2008-04-30");
        EndOfPeriodProcessor processor = new EndOfPeriodProcessor(statementDate1, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        List<Act> acts = this.getActs(customer, statementDate1);
        Assert.assertEquals((long)2L, (long)acts.size());
        this.checkAct(acts.get(0), invoice1.get(0), "POSTED");
        this.checkClosingBalance(acts.get(1), amount, BigDecimal.ZERO);
        FinancialAct payment = this.createPayment(amount, this.getDatetime("2008-05-25 11:00:00"));
        this.save((IMObject)payment);
        Date statementDate2 = this.getDate("2008-05-31");
        acts = this.getActs(customer, statementDate2);
        Assert.assertEquals((long)2L, (long)acts.size());
        processor = new EndOfPeriodProcessor(statementDate2, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        acts = this.getActs(customer, statementDate2);
        Assert.assertEquals((long)3L, (long)acts.size());
        this.checkOpeningBalance(acts.get(0), amount);
        this.checkAct(acts.get(1), payment, "POSTED");
        this.checkClosingBalance(acts.get(2), BigDecimal.ZERO, BigDecimal.ZERO);
        Date statementDate3 = this.getDate("2008-06-30");
        acts = this.getActs(customer, statementDate3);
        Assert.assertEquals((long)1L, (long)acts.size());
        this.checkOpeningBalance(acts.get(0), BigDecimal.ZERO);
    }

    @Test
    public void testNoFeeForOverdueLessThanFeeBalance() {
        IArchetypeRuleService service = (IArchetypeRuleService)this.getArchetypeService();
        Party customer = this.getCustomer();
        Lookup accountType = (Lookup)this.customerFactory.newAccountType().paymentTerms(30, DateUnits.DAYS).accountFee(10, AccountType.FeeType.FIXED).accountFeeDays(30).accountFeeBalance(10).accountFeeMessage("Test Accounting Fee").build();
        customer.addClassification(accountType);
        this.save((IMObject)customer);
        BigDecimal amount = new BigDecimal("155.00");
        List<FinancialAct> invoice1 = this.createChargesInvoice(amount, customer, this.getDatetime("2008-04-29 10:00:00"));
        this.save(invoice1);
        Date statementDate1 = this.getDate("2008-04-30");
        EndOfPeriodProcessor processor = new EndOfPeriodProcessor(statementDate1, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        List<Act> acts = this.getActs(customer, statementDate1);
        Assert.assertEquals((long)2L, (long)acts.size());
        this.checkAct(acts.get(0), invoice1.get(0), "POSTED");
        this.checkClosingBalance(acts.get(1), amount, BigDecimal.ZERO);
        BigDecimal amount2 = new BigDecimal("150");
        FinancialAct payment = this.createPayment(amount2, this.getDatetime("2008-05-15 11:00:00"));
        this.save((IMObject)payment);
        Date statementDate2 = this.getDate("2008-05-30");
        processor = new EndOfPeriodProcessor(statementDate2, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        acts = this.getActs(customer, statementDate2);
        Assert.assertEquals((long)3L, (long)acts.size());
        BigDecimal amount3 = new BigDecimal("5.00");
        this.checkOpeningBalance(acts.get(0), amount);
        this.checkAct(acts.get(1), payment, "POSTED");
        this.checkClosingBalance(acts.get(2), amount3, amount3);
        Date statementDate3 = this.getDate("2008-06-30");
        acts = this.getActs(customer, statementDate3);
        Assert.assertEquals((long)1L, (long)acts.size());
        this.checkOpeningBalance(acts.get(0), amount3);
    }

    @Test
    public void testFeeForOverdueEqualFeeBalance() {
        IArchetypeRuleService service = (IArchetypeRuleService)this.getArchetypeService();
        Party customer = this.getCustomer();
        BigDecimal feeAmount = new BigDecimal("10.00");
        Lookup accountType = (Lookup)this.customerFactory.newAccountType().paymentTerms(30, DateUnits.DAYS).accountFee(10, AccountType.FeeType.FIXED).accountFeeDays(30).accountFeeBalance(10).accountFeeMessage("Test Accounting Fee").build();
        customer.addClassification(accountType);
        this.save((IMObject)customer);
        BigDecimal amount = new BigDecimal("160.00");
        List<FinancialAct> invoice1 = this.createChargesInvoice(amount, customer, this.getDatetime("2008-04-15 10:00:00"));
        this.save(invoice1);
        Date statementDate1 = this.getDate("2008-04-30");
        EndOfPeriodProcessor processor = new EndOfPeriodProcessor(statementDate1, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        List<Act> acts = this.getActs(customer, statementDate1);
        Assert.assertEquals((long)2L, (long)acts.size());
        this.checkAct(acts.get(0), invoice1.get(0), "POSTED");
        this.checkClosingBalance(acts.get(1), amount, BigDecimal.ZERO);
        BigDecimal amount2 = new BigDecimal("150");
        FinancialAct payment = this.createPayment(amount2, this.getDatetime("2008-05-25 11:00:00"));
        this.save((IMObject)payment);
        Date statementDate2 = this.getDate("2008-05-31");
        processor = new EndOfPeriodProcessor(statementDate2, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        acts = this.getActs(customer, statementDate2);
        Assert.assertEquals((long)4L, (long)acts.size());
        BigDecimal amount3 = new BigDecimal("10.00");
        BigDecimal closingBalance = amount3.add(feeAmount);
        this.checkOpeningBalance(acts.get(0), amount);
        this.checkAct(acts.get(1), payment, "POSTED");
        this.checkDebitAdjust(acts.get(2), feeAmount, "Test Accounting Fee");
        this.checkClosingBalance(acts.get(3), closingBalance, amount3);
        this.checkEquals(closingBalance, this.accountRules.getBalance(customer));
        Date statementDate3 = this.getDate("2008-06-30");
        acts = this.getActs(customer, statementDate3);
        Assert.assertEquals((long)1L, (long)acts.size());
        this.checkOpeningBalance(acts.get(0), closingBalance);
    }

    @Test
    public void testDifferentOverdueDateAndFeeDate() {
        IArchetypeRuleService service = (IArchetypeRuleService)this.getArchetypeService();
        Party customer = this.getCustomer();
        BigDecimal feeAmount = new BigDecimal("10.00");
        Lookup accountType = (Lookup)this.customerFactory.newAccountType().paymentTerms(30, DateUnits.DAYS).accountFee(feeAmount, AccountType.FeeType.FIXED).accountFeeDays(60).accountFeeBalance(10).accountFeeMessage("Test Accounting Fee").build();
        customer.addClassification(accountType);
        this.save((IMObject)customer);
        BigDecimal amount = new BigDecimal("160.00");
        List<FinancialAct> invoice1 = this.createChargesInvoice(amount, customer, this.getDatetime("2007-04-15 10:00:00"));
        this.save(invoice1);
        Date statementDate1 = this.getDate("2007-04-30");
        EndOfPeriodProcessor processor = new EndOfPeriodProcessor(statementDate1, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        List<Act> acts = this.getActs(customer, statementDate1);
        Assert.assertEquals((long)2L, (long)acts.size());
        this.checkAct(acts.get(0), invoice1.get(0), "POSTED");
        this.checkClosingBalance(acts.get(1), amount, BigDecimal.ZERO);
        Date statementDate2 = this.getDate("2007-05-31");
        processor = new EndOfPeriodProcessor(statementDate2, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        acts = this.getActs(customer, statementDate2);
        Assert.assertEquals((long)2L, (long)acts.size());
        this.checkOpeningBalance(acts.get(0), amount);
        this.checkClosingBalance(acts.get(1), amount, amount);
        Date statementDate3 = this.getDate("2007-06-30");
        processor = new EndOfPeriodProcessor(statementDate3, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        processor.process(customer);
        acts = this.getActs(customer, statementDate3);
        Assert.assertEquals((long)3L, (long)acts.size());
        BigDecimal closingBalance = amount.add(feeAmount);
        this.checkOpeningBalance(acts.get(0), amount);
        this.checkDebitAdjust(acts.get(1), feeAmount, "Test Accounting Fee");
        this.checkClosingBalance(acts.get(2), closingBalance, amount);
        this.checkEquals(closingBalance, this.accountRules.getBalance(customer));
        Date statementDate4 = this.getDate("2007-07-31");
        acts = this.getActs(customer, statementDate4);
        Assert.assertEquals((long)1L, (long)acts.size());
        this.checkOpeningBalance(acts.get(0), closingBalance);
    }

    private List<FinancialAct> createCompletedInvoiceWithInvestigation(String orderStatus) {
        List<FinancialAct> invoice = this.createChargesInvoice(new BigDecimal("100"), this.getDatetime("2007-01-01 12:00:00"), "COMPLETED");
        this.save(invoice);
        Entity investigationType = this.laboratoryFactory.createInvestigationType();
        Entity laboratory = this.laboratoryFactory.createLaboratory(this.practiceFactory.createLocation());
        Act investigation = (Act)((TestInvestigationBuilder)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(this.getPatient())).laboratory(laboratory).investigationType(investigationType).status2(orderStatus)).build();
        IMObjectBean bean = this.getBean((IMObject)invoice.get(1));
        bean.addTarget("investigations", (IMObject)investigation);
        bean.save();
        return invoice;
    }

    private List<FinancialAct> createCompletedInvoiceWithOrder(String invoiceItemStatus) {
        List<FinancialAct> invoice = this.createChargesInvoice(new BigDecimal(100), this.getDatetime("2007-01-01 11:00:00"), "COMPLETED");
        invoice.get(1).setStatus(invoiceItemStatus);
        this.save(invoice);
        return invoice;
    }

    private void checkStatus(List<FinancialAct> invoice, String status) {
        FinancialAct reloaded = (FinancialAct)this.get((IMObject)invoice.get(0));
        Assert.assertEquals((Object)status, (Object)reloaded.getStatus());
    }
}

