/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.reminder;

import java.math.BigDecimal;
import java.util.Date;
import org.hibernate.validator.internal.util.Contracts;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.reminder.AccountReminderRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCounterSaleBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCounterSaleItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.insurance.TestInsuranceFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.springframework.beans.factory.annotation.Autowired;

public class AccountReminderRulesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private AccountReminderRules rules;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestInsuranceFactory insuranceFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestUserFactory userFactory;

    @Test
    public void testNeedsReminder() {
        this.checkNeedsReminder(true);
        this.checkNeedsReminder(false);
    }

    @Test
    public void testNeedsReminderForInvoiceInGapClaim() {
        Party customer = this.customerFactory.createCustomer();
        FinancialAct invoice = this.createInvoice(customer, 100, true, "POSTED");
        IMObjectBean bean = this.getBean((IMObject)invoice);
        FinancialAct item = (FinancialAct)bean.getTarget("items", FinancialAct.class);
        Contracts.assertNotNull((Object)item);
        Act policy = this.insuranceFactory.createPolicy(customer, this.patientFactory.createPatient(customer), this.insuranceFactory.createInsurer(), "ABCDEFG");
        User clinician = this.userFactory.createClinician();
        FinancialAct claim = (FinancialAct)this.insuranceFactory.newClaim().policy(policy).location(this.practiceFactory.createLocation()).clinician(clinician).claimHandler(clinician).gapClaim(true).item().diagnosis("VENOM_328", "Abcess", "328").invoiceItems(item).add().build();
        Assert.assertFalse((boolean)this.rules.needsReminder(invoice, BigDecimal.ZERO));
        claim.setStatus("CANCELLED");
        this.save((IMObject)claim);
        Assert.assertTrue((boolean)this.rules.needsReminder(invoice, BigDecimal.ZERO));
    }

    @Test
    public void testResolveError() {
        Act reminder1 = this.createReminder("PENDING", null);
        Act reminder2 = this.createReminder("COMPLETED", null);
        Act reminder3 = this.createReminder("CANCELLED", null);
        Act reminder4 = this.createReminder("ERROR", "foo");
        Assert.assertFalse((boolean)this.rules.resolveError(reminder1));
        Assert.assertFalse((boolean)this.rules.resolveError(reminder2));
        Assert.assertFalse((boolean)this.rules.resolveError(reminder3));
        Assert.assertTrue((boolean)this.rules.resolveError(reminder4));
        IMObjectBean bean = this.getBean((IMObject)this.get(reminder4));
        Assert.assertEquals((Object)"PENDING", (Object)bean.getString("status"));
        Assert.assertNull((Object)bean.getString("error"));
    }

    @Test
    public void testEnableReminders() {
        FinancialAct invoice1 = this.createInvoice(false);
        FinancialAct invoice2 = this.createInvoice(true);
        Assert.assertTrue((boolean)this.rules.canEnableReminders(invoice1));
        Assert.assertTrue((boolean)this.rules.enableReminders(invoice1));
        Assert.assertFalse((boolean)this.rules.enableReminders(invoice1));
        Assert.assertFalse((boolean)this.rules.enableReminders(invoice2));
        Assert.assertFalse((boolean)this.rules.canEnableReminders(invoice2));
        FinancialAct openingBalance = this.create("act.customerAccountOpeningBalance", FinancialAct.class);
        Assert.assertFalse((boolean)this.rules.canEnableReminders(openingBalance));
        Assert.assertFalse((boolean)this.rules.enableReminders(openingBalance));
    }

    @Test
    public void testDisableReminders() {
        FinancialAct invoice1 = this.createInvoice(true);
        Act reminder1 = this.addReminder(invoice1, "PENDING");
        FinancialAct invoice2 = this.createInvoice(true);
        Act reminder2 = this.addReminder(invoice2, "ERROR");
        FinancialAct invoice3 = this.createInvoice(true);
        Act reminder3 = this.addReminder(invoice3, "CANCELLED");
        FinancialAct invoice4 = this.createInvoice(true);
        Act reminder4 = this.addReminder(invoice4, "COMPLETED");
        FinancialAct invoice5 = this.createInvoice(false);
        Assert.assertTrue((boolean)this.rules.canDisableReminders(invoice1));
        Assert.assertTrue((boolean)this.rules.disableReminders(invoice1));
        Assert.assertNull((Object)this.get(reminder1));
        Assert.assertTrue((boolean)this.rules.canDisableReminders(invoice2));
        Assert.assertTrue((boolean)this.rules.disableReminders(invoice2));
        Assert.assertNull((Object)this.get(reminder2));
        Assert.assertTrue((boolean)this.rules.canDisableReminders(invoice3));
        Assert.assertTrue((boolean)this.rules.disableReminders(invoice3));
        Contracts.assertNotNull((Object)this.get(reminder3));
        Assert.assertTrue((boolean)this.rules.canDisableReminders(invoice4));
        Assert.assertTrue((boolean)this.rules.disableReminders(invoice4));
        Contracts.assertNotNull((Object)this.get(reminder4));
        Assert.assertFalse((boolean)this.rules.canDisableReminders(invoice5));
        Assert.assertFalse((boolean)this.rules.disableReminders(invoice5));
        FinancialAct openingBalance = this.create("act.customerAccountOpeningBalance", FinancialAct.class);
        Assert.assertFalse((boolean)this.rules.canDisableReminders(openingBalance));
        Assert.assertFalse((boolean)this.rules.disableReminders(openingBalance));
    }

    private Act addReminder(FinancialAct charge, String status) {
        IMObjectBean bean = this.getBean((IMObject)charge);
        Act reminder = this.createReminder(status, null);
        bean.addTarget("reminders", (IMObject)reminder, "charge");
        this.save((IMObject[])new Act[]{charge, reminder});
        return reminder;
    }

    private Act createReminder(String status, String error) {
        Act reminder = this.create("act.customerChargeReminderSMS", Act.class);
        reminder.setActivityStartTime(new Date());
        reminder.setStatus(status);
        if (error != null) {
            IMObjectBean bean = this.getBean((IMObject)reminder);
            bean.setValue("error", (Object)error);
        }
        this.save((IMObject)reminder);
        return reminder;
    }

    private void checkNeedsReminder(boolean invoice) {
        FinancialAct charge;
        String[] statuses;
        Party customer = this.customerFactory.createCustomer();
        for (String status : statuses = new String[]{"IN_PROGRESS", "ON_HOLD", "COMPLETED", "POSTED"}) {
            charge = this.createCharge(customer, 100, false, status, invoice);
            Assert.assertFalse((boolean)this.rules.needsReminder(charge, BigDecimal.ZERO));
        }
        for (String status : statuses) {
            charge = this.createCharge(customer, 50, true, status, invoice);
            boolean reminder = "POSTED".equals(status);
            Assert.assertEquals((Object)reminder, (Object)this.rules.needsReminder(charge, BigDecimal.ZERO));
        }
        FinancialAct charge1 = this.createCharge(customer, 10, true, "POSTED", invoice);
        Assert.assertTrue((boolean)this.rules.needsReminder(charge1, BigDecimal.ZERO));
        Assert.assertTrue((boolean)this.rules.needsReminder(charge1, BigDecimal.TEN));
        Assert.assertFalse((boolean)this.rules.needsReminder(charge1, new BigDecimal("10.01")));
        Lookup accountType = (Lookup)this.customerFactory.newAccountType().paymentTerms(30, DateUnits.DAYS).build();
        ((TestCustomerBuilder)this.customerFactory.updateCustomer(customer).addClassifications(accountType)).build();
        Assert.assertFalse((boolean)this.rules.needsReminder(charge1, BigDecimal.ZERO));
        charge1.setActivityEndTime(DateRules.getDate((Date)charge1.getActivityStartTime(), (int)-31, (DateUnits)DateUnits.DAYS));
        Assert.assertTrue((boolean)this.rules.needsReminder(charge1, BigDecimal.ZERO));
    }

    private FinancialAct createCharge(Party customer, int amount, boolean sendReminder, String status, boolean invoice) {
        return invoice ? this.createInvoice(customer, amount, sendReminder, status) : this.createCounterSale(customer, amount, sendReminder, status);
    }

    private FinancialAct createInvoice(boolean sendReminder) {
        return this.createInvoice(this.customerFactory.createCustomer(), 100, sendReminder, "POSTED");
    }

    private FinancialAct createInvoice(Party customer, int amount, boolean sendReminder, String status) {
        return (FinancialAct)((TestInvoiceBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)this.accountFactory.newInvoice().customer(customer)).status(status)).endTime("POSTED".equals(status) ? new Date() : null)).sendReminder(sendReminder)).item().patient(this.patientFactory.createPatient(customer))).medicationProduct()).unitPrice(amount)).add()).build();
    }

    private FinancialAct createCounterSale(Party customer, int amount, boolean sendReminder, String status) {
        return (FinancialAct)((TestCounterSaleBuilder)((TestCounterSaleItemBuilder)((TestCounterSaleItemBuilder)((TestCounterSaleBuilder)((TestCounterSaleBuilder)((TestCounterSaleBuilder)((TestCounterSaleBuilder)this.accountFactory.newCounterSale().customer(customer)).status(status)).endTime("POSTED".equals(status) ? new Date() : null)).sendReminder(sendReminder)).item().medicationProduct()).unitPrice(amount)).add()).build();
    }
}

