/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.estimate;

import java.math.BigDecimal;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;

public class EstimateTestHelper {
    public static Act createEstimate(Party customer, Act ... items) {
        Act estimate = (Act)TestHelper.create("act.customerEstimation");
        IMObjectBean bean = new IMObjectBean((IMObject)estimate);
        bean.setTarget("customer", (IMObject)customer);
        BigDecimal lowTotal = BigDecimal.ZERO;
        BigDecimal highTotal = BigDecimal.ZERO;
        int sequence = 0;
        for (Act item : items) {
            IMObjectBean itemBean = new IMObjectBean((IMObject)item);
            ActRelationship relationship = (ActRelationship)bean.addTarget("items", (IMObject)item);
            relationship.setSequence(sequence++);
            item.addActRelationship(relationship);
            highTotal = highTotal.add(itemBean.getBigDecimal("highTotal"));
            lowTotal = lowTotal.add(itemBean.getBigDecimal("lowTotal"));
        }
        bean.setValue("highTotal", (Object)highTotal);
        bean.setValue("lowTotal", (Object)lowTotal);
        return estimate;
    }

    public static Act createEstimateItem(Party patient, Product product, BigDecimal fixedPrice) {
        IMObjectBean bean = EstimateTestHelper.createEstimateItem(patient, product);
        bean.setValue("fixedPrice", (Object)fixedPrice);
        bean.setValue("lowTotal", (Object)fixedPrice);
        bean.setValue("highTotal", (Object)fixedPrice);
        return (Act)bean.getObject();
    }

    public static Act createEstimateItem(Party patient, Product product, BigDecimal quantity, BigDecimal unitPrice) {
        IMObjectBean bean = EstimateTestHelper.createEstimateItem(patient, product);
        bean.setValue("highQty", (Object)quantity);
        bean.setValue("highUnitPrice", (Object)unitPrice);
        bean.deriveValues();
        return (Act)bean.getObject();
    }

    public static Act createEstimateItem(Party patient, Product product, Product template, int group, BigDecimal quantity, BigDecimal unitPrice) {
        Act act = EstimateTestHelper.createEstimateItem(patient, product, quantity, unitPrice);
        if (template != null) {
            IMObjectBean bean = new IMObjectBean((IMObject)act);
            bean.setTarget("template", (IMObject)template);
            Relationship relationship = (Relationship)bean.getObject("template", Relationship.class);
            IMObjectBean relBean = new IMObjectBean((IMObject)relationship);
            relBean.setValue("group", (Object)group);
        }
        return act;
    }

    private static IMObjectBean createEstimateItem(Party patient, Product product) {
        Act item = (Act)TestHelper.create("act.customerEstimationItem");
        IMObjectBean bean = new IMObjectBean((IMObject)item);
        bean.setTarget("patient", (IMObject)patient);
        bean.setTarget("product", (IMObject)product);
        return bean;
    }
}

