/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.estimate;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.finance.estimate.EstimateRules;
import org.openvpms.archetype.rules.finance.estimate.EstimateTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.security.AuthenticationContextImpl;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;

public class EstimateRulesTestCase
extends ArchetypeServiceTest {
    protected EstimateRules rules;

    @Before
    public void setUp() {
        this.rules = new EstimateRules(this.getArchetypeService());
    }

    @Test
    public void testCopy() {
        AuthenticationContextImpl context = new AuthenticationContextImpl();
        User user1 = TestHelper.createUser();
        User user2 = TestHelper.createUser();
        context.setUser(user1);
        Party customer = TestHelper.createCustomer();
        Product product = TestHelper.createProduct();
        Party patient = TestHelper.createPatient();
        BigDecimal fixedPrice = new BigDecimal("10.00");
        Act item = EstimateTestHelper.createEstimateItem(patient, product, fixedPrice);
        Act estimate = EstimateTestHelper.createEstimate(customer, item);
        estimate.setStatus("INVOICED");
        List<FinancialAct> invoice = FinancialTestHelper.createChargesInvoice(fixedPrice, customer, patient, product, "POSTED");
        IMObjectBean bean = this.getBean((IMObject)estimate);
        bean.addTarget("invoice", (IMObject)invoice.get(0), "estimates");
        IMObjectBean itemBean = this.getBean((IMObject)item);
        itemBean.setValue("minQuantity", (Object)BigDecimal.ONE);
        this.save((IMObject[])new Act[]{estimate, item, (Act)invoice.get(0), (Act)invoice.get(1)});
        Assert.assertNotNull((Object)item.getCreated());
        Assert.assertEquals((Object)user1.getObjectReference(), (Object)item.getCreatedBy());
        Assert.assertNull((Object)item.getUpdated());
        Assert.assertNull((Object)item.getUpdatedBy());
        String title = "Copy";
        context.setUser(user2);
        Act copy = this.rules.copy(estimate, title);
        Assert.assertNotEquals((long)copy.getId(), (long)estimate.getId());
        Assert.assertNotNull((Object)copy.getCreated());
        Assert.assertEquals((Object)copy.getCreatedBy(), (Object)user2.getObjectReference());
        Assert.assertNull((Object)copy.getUpdated());
        Assert.assertNull((Object)copy.getUpdatedBy());
        IMObjectBean copyBean = this.getBean((IMObject)copy);
        Assert.assertEquals((Object)title, (Object)copy.getTitle());
        Assert.assertEquals((Object)"COMPLETED", (Object)copy.getStatus());
        Assert.assertEquals((Object)customer, (Object)copyBean.getTarget("customer"));
        this.checkEquals(bean.getBigDecimal("lowTotal"), copyBean.getBigDecimal("lowTotal"));
        this.checkEquals(bean.getBigDecimal("highTotal"), copyBean.getBigDecimal("highTotal"));
        List acts = copyBean.getTargets("items", Act.class);
        Assert.assertEquals((long)1L, (long)acts.size());
        Act itemCopy = (Act)acts.get(0);
        Assert.assertNotEquals((long)itemCopy.getId(), (long)item.getId());
        IMObjectBean itemCopyBean = this.getBean((IMObject)itemCopy);
        this.checkEquals(itemBean.getBigDecimal("minQuantity"), itemCopyBean.getBigDecimal("minQuantity"));
        this.checkEquals(itemBean.getBigDecimal("lowQty"), itemCopyBean.getBigDecimal("lowQty"));
        this.checkEquals(itemBean.getBigDecimal("highQty"), itemCopyBean.getBigDecimal("highQty"));
        this.checkEquals(itemBean.getBigDecimal("fixedPrice"), itemCopyBean.getBigDecimal("fixedPrice"));
        this.checkEquals(itemBean.getBigDecimal("lowTotal"), itemCopyBean.getBigDecimal("lowTotal"));
        this.checkEquals(itemBean.getBigDecimal("highTotal"), itemCopyBean.getBigDecimal("highTotal"));
        Assert.assertEquals((Object)patient, (Object)itemCopyBean.getTarget("patient"));
        Assert.assertEquals((Object)product, (Object)itemCopyBean.getTarget("product"));
        Assert.assertNull((Object)copyBean.getTarget("invoice"));
    }

    @Test
    public void testInvoice() {
        Party customer = TestHelper.createCustomer();
        Product product = TestHelper.createProduct();
        Party patient = TestHelper.createPatient();
        User clinician = TestHelper.createClinician();
        BigDecimal fixedPrice = new BigDecimal("10.00");
        Act item = EstimateTestHelper.createEstimateItem(patient, product, fixedPrice);
        Act estimate = EstimateTestHelper.createEstimate(customer, item);
        IMObjectBean itemBean = this.getBean((IMObject)item);
        itemBean.setValue("minQuantity", (Object)BigDecimal.ONE);
        this.save((IMObject[])new Act[]{estimate, item});
        FinancialAct invoice = this.rules.invoice(estimate, clinician);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)invoice.getStatus());
        Assert.assertEquals((Object)"INVOICED", (Object)estimate.getStatus());
        IMObjectBean bean = this.getBean((IMObject)invoice);
        IMObjectBean estimateBean = this.getBean((IMObject)estimate);
        IMObjectBean estimateItemBean = this.getBean((IMObject)item);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)1L, (long)items.size());
        itemBean = this.getBean((IMObject)items.get(0));
        this.checkEquals(estimateBean.getBigDecimal("highTotal"), bean.getBigDecimal("amount"));
        Assert.assertEquals((Object)estimateBean.getTarget("invoice"), (Object)invoice);
        List estimates = bean.getSources("estimates", Act.class);
        Assert.assertEquals((long)1L, (long)estimates.size());
        Assert.assertTrue((boolean)estimates.contains(estimate));
        Assert.assertEquals((Object)customer, (Object)bean.getTarget("customer"));
        Assert.assertEquals((Object)clinician, (Object)bean.getTarget("clinician"));
        Assert.assertEquals((Object)patient, (Object)itemBean.getTarget("patient"));
        Assert.assertEquals((Object)product, (Object)itemBean.getTarget("product"));
        Assert.assertEquals((Object)clinician, (Object)itemBean.getTarget("clinician"));
        this.checkEquals(itemBean.getBigDecimal("minQuantity"), estimateItemBean.getBigDecimal("minQuantity"));
        this.checkEquals(itemBean.getBigDecimal("total"), estimateItemBean.getBigDecimal("highTotal"));
        List dispensing = itemBean.getTargets("dispensing", Act.class);
        Assert.assertEquals((long)1L, (long)dispensing.size());
        IMObjectBean medicationBean = this.getBean((IMObject)dispensing.get(0));
        Assert.assertEquals((Object)patient, (Object)medicationBean.getTarget("patient"));
        Assert.assertEquals((Object)product, (Object)medicationBean.getTarget("product"));
        this.remove((IMObject)estimate);
        Assert.assertNotNull((Object)this.get(invoice));
    }

    @Test
    public void testIsPatientEstimate() {
        Party customer = TestHelper.createCustomer();
        Product product = TestHelper.createProduct();
        Party patient1 = TestHelper.createPatient();
        Party patient2 = TestHelper.createPatient();
        BigDecimal fixedPrice = new BigDecimal("10.00");
        Act item1 = EstimateTestHelper.createEstimateItem(patient1, product, fixedPrice);
        Act item2 = EstimateTestHelper.createEstimateItem(patient2, product, fixedPrice);
        Act estimate1 = EstimateTestHelper.createEstimate(customer, item1, item2);
        this.save((IMObject[])new Act[]{estimate1, item1, item2});
        Assert.assertFalse((boolean)this.rules.isPatientEstimate(estimate1, patient1));
        Assert.assertFalse((boolean)this.rules.isPatientEstimate(estimate1, patient2));
        Act item3 = EstimateTestHelper.createEstimateItem(patient1, product, fixedPrice);
        Act item4 = EstimateTestHelper.createEstimateItem(patient1, product, fixedPrice);
        Act estimate2 = EstimateTestHelper.createEstimate(customer, item3, item4);
        this.save((IMObject[])new Act[]{estimate2, item3, item4});
        Assert.assertTrue((boolean)this.rules.isPatientEstimate(estimate2, patient1));
        Assert.assertFalse((boolean)this.rules.isPatientEstimate(estimate2, patient2));
    }
}

