/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.deposit;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.deposit.DepositRuleException;
import org.openvpms.archetype.rules.finance.deposit.DepositRules;
import org.openvpms.archetype.rules.finance.deposit.DepositTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.ruleengine.RuleEngineException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;

public class DepositRulesTestCase
extends ArchetypeServiceTest {
    private Party account;

    @Test
    public void testSaveUndepositedDeposit() {
        Act deposit1 = this.createDeposit("UNDEPOSITED");
        this.save((IMObject)deposit1);
        this.save((IMObject)deposit1);
        Act deposit2 = this.createDeposit("UNDEPOSITED");
        try {
            this.save((IMObject)deposit2);
            Assert.fail((String)"Expected save of second undeposited bank deposit to fail");
        }
        catch (RuleEngineException expected) {
            Throwable cause;
            for (cause = expected.getCause(); cause != null && !(cause instanceof DepositRuleException); cause = cause.getCause()) {
            }
            Assert.assertNotNull((Object)cause);
            DepositRuleException exception = (DepositRuleException)cause;
            Assert.assertEquals((Object)DepositRuleException.ErrorCode.UndepositedDepositExists, (Object)exception.getErrorCode());
        }
    }

    @Test
    public void testSaveDepositedDeposit() {
        for (int i = 0; i < 3; ++i) {
            Act deposit = this.createDeposit("DEPOSITED");
            this.save((IMObject)deposit);
        }
    }

    @Test
    public void testCheckCanSaveBankDepositWithInvalidAct() {
        FinancialAct act = this.create("act.tillBalance", FinancialAct.class);
        try {
            DepositRules.checkCanSaveBankDeposit((FinancialAct)act, (IArchetypeService)this.getArchetypeService());
        }
        catch (DepositRuleException expected) {
            Assert.assertEquals((Object)DepositRuleException.ErrorCode.InvalidDepositArchetype, (Object)expected.getErrorCode());
        }
    }

    @Test
    public void testDeposit() {
        Act deposit = this.createDeposit("UNDEPOSITED");
        DepositRules.deposit((Act)deposit, (IArchetypeService)this.getArchetypeService());
        this.account = this.get(this.account);
        Assert.assertNotNull((Object)this.account);
        IMObjectBean bean = this.getBean((IMObject)this.account);
        Date lastDeposit = bean.getDate("lastDeposit");
        Date now = new Date();
        Assert.assertTrue((now.compareTo(lastDeposit) >= 0 ? 1 : 0) != 0);
    }

    @Before
    public void setUp() {
        this.account = DepositTestHelper.createDepositAccount();
    }

    private Act createDeposit(String status) {
        Act act = this.create("act.bankDeposit", Act.class);
        act.setStatus(status);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("depositAccount", (IMObject)this.account);
        return act;
    }
}

