/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestEFTPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestEFTRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestRefundBuilder;
import org.openvpms.archetype.test.builder.eft.TestEFTPOSPaymentBuilder;
import org.openvpms.archetype.test.builder.eft.TestEFTPOSRefundBuilder;
import org.openvpms.archetype.test.builder.paymentprocessor.TestPaymentProcessorFactory;
import org.openvpms.archetype.test.builder.paymentprocessor.TestPaymentProcessorPaymentBuilder;
import org.openvpms.archetype.test.builder.paymentprocessor.TestPaymentProcessorRefundBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomerAccountActTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestPaymentProcessorFactory paymentProcessorFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testDeletePayment() {
        Party customer = this.customerFactory.createCustomer();
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        Party location = this.practiceFactory.createLocation();
        FinancialAct eftposTransaction = (FinancialAct)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)this.accountFactory.newEFTPOSPayment().customer(customer)).amount(BigDecimal.TEN)).terminal(terminal)).location(location)).status("PENDING")).build();
        FinancialAct eftposItem = (FinancialAct)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.accountFactory.newEFTPaymentItem().addTransaction(eftposTransaction)).amount(BigDecimal.TEN)).build(false);
        FinancialAct ppTransaction = (FinancialAct)((TestPaymentProcessorPaymentBuilder)((TestPaymentProcessorPaymentBuilder)((TestPaymentProcessorPaymentBuilder)((TestPaymentProcessorPaymentBuilder)((TestPaymentProcessorPaymentBuilder)this.accountFactory.newPaymentProcessorPayment().customer(customer)).amount(BigDecimal.TEN)).paymentProcessor(this.paymentProcessorFactory.createPaymentProcessor())).location(location)).status("PENDING")).build();
        FinancialAct ppItem = (FinancialAct)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)this.accountFactory.newPaymentProcessorPaymentItem().processor(this.paymentProcessorFactory.createPaymentProcessor())).addTransaction(ppTransaction)).amount(BigDecimal.TEN)).build(false);
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(customer)).till(this.practiceFactory.createTill())).add(eftposItem, ppItem)).status("IN_PROGRESS")).build();
        Assert.assertNotNull((Object)this.get(payment));
        Assert.assertNotNull((Object)this.get(eftposItem));
        Assert.assertNotNull((Object)this.get(eftposTransaction));
        Assert.assertNotNull((Object)this.get(ppItem));
        Assert.assertNotNull((Object)this.get(ppTransaction));
        List eft = this.getBean((IMObject)eftposItem).getTargets("transactions");
        Assert.assertEquals((long)1L, (long)eft.size());
        Assert.assertEquals((Object)eftposTransaction, eft.get(0));
        List ppTransactions = this.getBean((IMObject)ppItem).getTargets("transactions");
        Assert.assertEquals((long)1L, (long)ppTransactions.size());
        Assert.assertEquals((Object)ppTransaction, ppTransactions.get(0));
        this.remove((IMObject)payment);
        Assert.assertNull((Object)this.get(eftposItem));
        Assert.assertNotNull((Object)this.get(eftposTransaction));
        Assert.assertNull((Object)this.get(ppItem));
        Assert.assertNotNull((Object)this.get(ppTransaction));
    }

    @Test
    public void testDeleteRefund() {
        Party customer = this.customerFactory.createCustomer();
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        Party location = this.practiceFactory.createLocation();
        FinancialAct eftposTransaction = (FinancialAct)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)this.accountFactory.newEFTPOSRefund().customer(customer)).amount(BigDecimal.TEN)).terminal(terminal)).location(location)).status("PENDING")).build();
        FinancialAct eftposItem = (FinancialAct)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)this.accountFactory.newEFTRefundItem().addTransaction(eftposTransaction)).amount(BigDecimal.TEN)).build(false);
        Entity paymentProcessor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct ppTransaction = (FinancialAct)((TestPaymentProcessorRefundBuilder)((TestPaymentProcessorRefundBuilder)((TestPaymentProcessorRefundBuilder)((TestPaymentProcessorRefundBuilder)((TestPaymentProcessorRefundBuilder)this.accountFactory.newPaymentProcessorRefund().customer(customer)).amount(BigDecimal.TEN)).paymentProcessor(paymentProcessor)).location(location)).status("PENDING")).build();
        FinancialAct ppItem = (FinancialAct)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)this.accountFactory.newPaymentProcessorRefundItem().processor(paymentProcessor)).addTransaction(ppTransaction)).amount(BigDecimal.TEN)).build(false);
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().customer(customer)).till(this.practiceFactory.createTill())).add(eftposItem, ppItem)).status("IN_PROGRESS")).build();
        Assert.assertNotNull((Object)this.get(refund));
        Assert.assertNotNull((Object)this.get(eftposItem));
        Assert.assertNotNull((Object)this.get(eftposTransaction));
        Assert.assertNotNull((Object)this.get(ppItem));
        Assert.assertNotNull((Object)this.get(ppTransaction));
        List eft = this.getBean((IMObject)eftposItem).getTargets("transactions");
        Assert.assertEquals((long)1L, (long)eft.size());
        Assert.assertEquals((Object)eftposTransaction, eft.get(0));
        List ppTransactions = this.getBean((IMObject)ppItem).getTargets("transactions");
        Assert.assertEquals((long)1L, (long)ppTransactions.size());
        Assert.assertEquals((Object)ppTransaction, ppTransactions.get(0));
        this.remove((IMObject)refund);
        Assert.assertNull((Object)this.get(eftposItem));
        Assert.assertNotNull((Object)this.get(eftposTransaction));
        Assert.assertNull((Object)this.get(ppItem));
        Assert.assertNotNull((Object)this.get(ppTransaction));
    }
}

