/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.doc.TestEmailTemplateBuilder;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class EmailTemplateTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestDocumentFactory documentFactory;

    @Test
    public void testDefaults() {
        this.checkDefaults("entity.documentTemplateEmailSystem");
        this.checkDefaults("entity.documentTemplateEmailUser");
    }

    @Test
    public void testAccessors() {
        Document handout1 = this.documentFactory.createPDF("Patient Handout.pdf");
        Entity attachment1 = (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().name("Patient Handout")).type("act.patientDocumentForm").document(handout1)).build();
        Document handout2 = this.documentFactory.createPDF("Customer Handout.pdf");
        Entity attachment2 = (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().name("Customer Handout")).type("act.customerDocumentForm").document(handout2)).build();
        Document handout3 = this.documentFactory.createPDF("Inactive Handout.pdf");
        Entity attachment3 = (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.customerDocumentForm").document(handout3)).active(false)).build();
        Entity attachment4 = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.customerDocumentForm").blankDocument()).build();
        Entity entity = (Entity)((TestEmailTemplateBuilder)((TestEmailTemplateBuilder)this.documentFactory.newEmailTemplate().name("Z Test Email Template")).subject("plain text subject").subjectSource(".").content("content ignored when document set").document("/documents/Vaccination Reminders.jrxml", "text/xml")).contentSource("$patient").addAttachments(attachment1, attachment2, attachment3, attachment4).build();
        EmailTemplate template = new EmailTemplate(entity, (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((Object)"Z Test Email Template", (Object)template.getName());
        Assert.assertEquals((Object)EmailTemplate.SubjectType.TEXT, (Object)template.getSubjectType());
        Assert.assertEquals((Object)"plain text subject", (Object)template.getSubject());
        Assert.assertEquals((Object)".", (Object)template.getSubjectSource());
        Assert.assertEquals((Object)EmailTemplate.ContentType.DOCUMENT, (Object)template.getContentType());
        Assert.assertEquals((Object)"content ignored when document set", (Object)template.getContent());
        Assert.assertNotNull((Object)template.getDocument());
        List attachmentsById = template.getAttachments();
        Assert.assertEquals((long)2L, (long)attachmentsById.size());
        Assert.assertEquals((Object)attachment1, (Object)((DocumentTemplate)attachmentsById.get(0)).getEntity());
        Assert.assertEquals((Object)attachment2, (Object)((DocumentTemplate)attachmentsById.get(1)).getEntity());
        List attachmentsByName = template.getAttachments(true);
        Assert.assertEquals((long)2L, (long)attachmentsByName.size());
        Assert.assertEquals((Object)attachment2, (Object)((DocumentTemplate)attachmentsByName.get(0)).getEntity());
        Assert.assertEquals((Object)attachment1, (Object)((DocumentTemplate)attachmentsByName.get(1)).getEntity());
    }

    private void checkDefaults(String archetype) {
        Entity entity = this.create(archetype, Entity.class);
        EmailTemplate template = new EmailTemplate(entity, (ArchetypeService)this.getArchetypeService());
        Assert.assertNull((Object)template.getName());
        Assert.assertEquals((Object)EmailTemplate.SubjectType.TEXT, (Object)template.getSubjectType());
        Assert.assertNull((Object)template.getSubject());
        Assert.assertNull((Object)template.getSubjectSource());
        Assert.assertEquals((Object)EmailTemplate.ContentType.TEXT, (Object)template.getContentType());
        Assert.assertNull((Object)template.getContent());
        Assert.assertNull((Object)template.getDocument());
        Assert.assertTrue((boolean)template.getAttachments().isEmpty());
    }
}

